/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CheckTypesOfStringsUtil;

public class IntervalAnalysisState
implements Serializable,
LatticeAbstractState<IntervalAnalysisState>,
AbstractQueryableState,
Graphable {
    private static final long serialVersionUID = -2030700797958100666L;
    private static final Splitter propertySplitter = Splitter.on((String)"<=").trimResults();
    private PersistentMap<String, Interval> intervals;
    private PersistentMap<String, Integer> referenceCounts;

    public IntervalAnalysisState() {
        this.intervals = PathCopyingPersistentTreeMap.of();
        this.referenceCounts = PathCopyingPersistentTreeMap.of();
    }

    public IntervalAnalysisState(PersistentMap<String, Interval> intervals, PersistentMap<String, Integer> referencesMap) {
        this.intervals = intervals;
        this.referenceCounts = referencesMap;
    }

    public Interval getInterval(String variableName) {
        return this.intervals.containsKey((Object)variableName) ? (Interval)this.intervals.get((Object)variableName) : Interval.createUnboundInterval();
    }

    private Integer getReferenceCount(String variableName) {
        return this.referenceCounts.containsKey((Object)variableName) ? (Integer)this.referenceCounts.get((Object)variableName) : 0;
    }

    @Deprecated
    public boolean exceedsThreshold(String variableName, Integer threshold) {
        Integer referenceCount = this.referenceCounts.containsKey((Object)variableName) ? (Integer)this.referenceCounts.get((Object)variableName) : 0;
        return referenceCount > threshold;
    }

    public boolean contains(String variableName) {
        return this.intervals.containsKey((Object)variableName);
    }

    public IntervalAnalysisState addInterval(String variableName, Interval interval, int pThreshold) {
        if (interval.isUnbound()) {
            this.removeInterval(variableName);
            return this;
        }
        if (!this.intervals.containsKey((Object)variableName) || !((Interval)this.intervals.get((Object)variableName)).equals(interval)) {
            int referenceCount = this.getReferenceCount(variableName);
            if (pThreshold == -1 || referenceCount < pThreshold) {
                this.referenceCounts = this.referenceCounts.putAndCopy((Object)variableName, (Object)(referenceCount + 1));
                this.intervals = this.intervals.putAndCopy((Object)variableName, (Object)interval);
            } else {
                this.removeInterval(variableName);
            }
        }
        return this;
    }

    public IntervalAnalysisState removeInterval(String variableName) {
        if (this.intervals.containsKey((Object)variableName)) {
            this.intervals = this.intervals.removeAndCopy((Object)variableName);
        }
        return this;
    }

    public void dropFrame(String pCalledFunctionName) {
        for (String variableName : this.intervals.keySet()) {
            if (!variableName.startsWith(pCalledFunctionName + "::")) continue;
            this.removeInterval(variableName);
        }
    }

    @Override
    public IntervalAnalysisState join(IntervalAnalysisState reachedState) {
        boolean changed = false;
        PersistentSortedMap newIntervals = PathCopyingPersistentTreeMap.of();
        PersistentMap newReferences = this.referenceCounts;
        for (String variableName : reachedState.intervals.keySet()) {
            if (this.intervals.containsKey((Object)variableName)) {
                Interval mergedInterval = this.getInterval(variableName).union(reachedState.getInterval(variableName));
                if (mergedInterval != reachedState.getInterval(variableName)) {
                    changed = true;
                }
                if (!mergedInterval.isUnbound()) {
                    newIntervals = newIntervals.putAndCopy((Object)variableName, (Object)mergedInterval);
                }
                int newRefCount = Math.max(this.getReferenceCount(variableName), reachedState.getReferenceCount(variableName));
                if (mergedInterval != reachedState.getInterval(variableName) && newRefCount > reachedState.getReferenceCount(variableName)) {
                    changed = true;
                    newReferences = newReferences.putAndCopy((Object)variableName, (Object)newRefCount);
                    continue;
                }
                newReferences = newReferences.putAndCopy((Object)variableName, (Object)reachedState.getReferenceCount(variableName));
                continue;
            }
            newReferences = newReferences.putAndCopy((Object)variableName, (Object)reachedState.getReferenceCount(variableName));
            changed = true;
        }
        if (changed) {
            return new IntervalAnalysisState((PersistentMap<String, Interval>)newIntervals, newReferences);
        }
        return reachedState;
    }

    @Override
    public boolean isLessOrEqual(IntervalAnalysisState reachedState) {
        if (this.intervals.equals(reachedState.intervals)) {
            return true;
        }
        if (this.intervals.size() < reachedState.intervals.size()) {
            return false;
        }
        for (String variableName : reachedState.intervals.keySet()) {
            if (this.intervals.containsKey((Object)variableName) && reachedState.getInterval(variableName).contains(this.getInterval(variableName))) continue;
            return false;
        }
        return true;
    }

    public static IntervalAnalysisState copyOf(IntervalAnalysisState old) {
        IntervalAnalysisState newElement = new IntervalAnalysisState(old.intervals, old.referenceCounts);
        return newElement;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        IntervalAnalysisState otherElement = (IntervalAnalysisState)other;
        if (this.intervals.size() != otherElement.intervals.size()) {
            return false;
        }
        for (String variableName : this.intervals.keySet()) {
            if (otherElement.intervals.containsKey((Object)variableName) && ((Interval)otherElement.intervals.get((Object)variableName)).equals(this.intervals.get((Object)variableName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Map.Entry entry : this.intervals.entrySet()) {
            String key = (String)entry.getKey();
            sb.append(" <");
            sb.append(key);
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append(" :: ");
            sb.append(this.getReferenceCount(key));
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.intervals.size()).toString();
    }

    @Override
    public String getCPAName() {
        return "IntervalAnalysis";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        List parts = propertySplitter.splitToList((CharSequence)pProperty);
        if (parts.size() == 2) {
            if (CheckTypesOfStringsUtil.isLong((String)parts.get(0))) {
                Interval iv;
                long value = Long.parseLong((String)parts.get(0));
                return value <= (iv = this.getInterval((String)parts.get(1))).getLow();
            }
            if (CheckTypesOfStringsUtil.isLong((String)parts.get(1))) {
                long value = Long.parseLong((String)parts.get(1));
                Interval iv = this.getInterval((String)parts.get(0));
                return iv.getHigh() <= value;
            }
            Interval iv1 = this.getInterval((String)parts.get(0));
            Interval iv2 = this.getInterval((String)parts.get(1));
            return iv1.contains(iv2);
        }
        if (parts.size() == 3 && CheckTypesOfStringsUtil.isLong((String)parts.get(0)) && CheckTypesOfStringsUtil.isLong((String)parts.get(2))) {
            long value1 = Long.parseLong((String)parts.get(0));
            long value2 = Long.parseLong((String)parts.get(2));
            Interval iv = this.getInterval((String)parts.get(1));
            return value1 <= iv.getLow() && iv.getHigh() <= value2;
        }
        return false;
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The modifying query " + pModification + " is an unsupported operation in " + this.getCPAName() + "!");
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry entry : this.intervals.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append(" (");
            sb.append(this.referenceCounts.get(entry.getKey()));
            sb.append("), ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }
}

