/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

@Options(prefix="cpa.interval")
public class IntervalAnalysisTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, description="decides whether one (false) or two (true) successors should be created when an inequality-check is encountered")
    private boolean splitIntervals = false;
    private static final String RETURN_VARIABLE_BASE_NAME = "___cpa_temp_result_var_";
    private final Set<String> globalFieldVars = new HashSet<String>();
    @Option(secure=true, description="at most that many intervals will be tracked per variable, -1 if number not restricted")
    private int threshold = -1;

    public IntervalAnalysisTransferRelation(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        Collection<? extends AbstractState> successors = null;
        IntervalAnalysisState successor = null;
        IntervalAnalysisState intervalElement = (IntervalAnalysisState)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)cfaEdge;
                successor = this.handleStatement(intervalElement, statementEdge.getStatement(), cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)cfaEdge;
                successor = this.handleExitFromFunction(intervalElement, returnEdge.getExpression(), returnEdge, cfaEdge);
                break;
            }
            case DeclarationEdge: {
                successor = this.handleDeclaration(intervalElement, (CDeclarationEdge)cfaEdge);
                break;
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)cfaEdge;
                successors = this.handleAssumption(intervalElement, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption());
                break;
            }
            case BlankEdge: {
                successor = IntervalAnalysisState.copyOf(intervalElement);
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(intervalElement, functionCallEdge, cfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                successor = this.handleFunctionReturn(intervalElement, (CFunctionReturnEdge)cfaEdge);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        if (successors != null) {
            return successors;
        }
        if (successor == null) {
            return this.noSuccessors();
        }
        return this.soleSuccessor(successor);
    }

    /*
     * Enabled aggressive block sorting
     */
    private IntervalAnalysisState handleFunctionReturn(IntervalAnalysisState element, CFunctionReturnEdge functionReturnEdge) throws UnrecognizedCCodeException {
        CFunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        CFunctionCall expression = summaryEdge.getExpression();
        IntervalAnalysisState newElement = IntervalAnalysisState.copyOf(element);
        String callerFunctionName = functionReturnEdge.getSuccessor().getFunctionName();
        String calledFunctionName = functionReturnEdge.getPredecessor().getFunctionName();
        newElement.dropFrame(calledFunctionName);
        if (!(expression instanceof CFunctionCallAssignmentStatement)) {
            if (!(expression instanceof CFunctionCallStatement)) throw new UnrecognizedCCodeException("on function return", (CFAEdge)summaryEdge, expression);
            return newElement;
        }
        CFunctionCallAssignmentStatement funcExp = (CFunctionCallAssignmentStatement)expression;
        CLeftHandSide operand1 = funcExp.getLeftHandSide();
        if (!(operand1 instanceof CIdExpression) && !(operand1 instanceof CFieldReference)) {
            if (!(operand1 instanceof CPointerExpression)) throw new UnrecognizedCCodeException("on function return", (CFAEdge)summaryEdge, operand1);
            return IntervalAnalysisState.copyOf(element);
        }
        String returnedVariableName = calledFunctionName + "::" + RETURN_VARIABLE_BASE_NAME;
        Interval interval = element.contains(returnedVariableName) ? element.getInterval(returnedVariableName) : Interval.createUnboundInterval();
        newElement.addInterval(this.constructVariableName(operand1, callerFunctionName), interval, this.threshold);
        return newElement;
    }

    private IntervalAnalysisState handleFunctionCall(IntervalAnalysisState previousElement, CFunctionCallEdge callEdge, CFAEdge edge) throws UnrecognizedCCodeException {
        CFunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        String calledFunctionName = functionEntryNode.getFunctionName();
        String callerFunctionName = callEdge.getPredecessor().getFunctionName();
        List<String> parameterNames = functionEntryNode.getFunctionParameterNames();
        List<CExpression> arguments = callEdge.getArguments();
        assert (parameterNames.size() == arguments.size());
        IntervalAnalysisState newElement = IntervalAnalysisState.copyOf(previousElement);
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(previousElement, callerFunctionName, edge);
        for (int i = 0; i < arguments.size(); ++i) {
            Interval interval = arguments.get(i).accept(visitor);
            String formalParameterName = this.constructLocalVariableName(parameterNames.get(i), calledFunctionName);
            newElement.addInterval(formalParameterName, interval, this.threshold);
        }
        return newElement;
    }

    private IntervalAnalysisState handleExitFromFunction(IntervalAnalysisState element, Optional<CExpression> expression, CReturnStatementEdge returnEdge, CFAEdge edge) throws UnrecognizedCCodeException {
        CExpression exp = (CExpression)expression.or((Object)CIntegerLiteralExpression.ZERO);
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, returnEdge.getPredecessor().getFunctionName(), edge);
        return this.handleAssignmentToVariable(RETURN_VARIABLE_BASE_NAME, exp, visitor);
    }

    private Collection<? extends AbstractState> handleAssumption(IntervalAnalysisState element, CExpression expression, CFAEdge cfaEdge, boolean truthValue) throws UnrecognizedCCodeException {
        if (expression instanceof CUnaryExpression) {
            throw new UnrecognizedCCodeException("unexpected operator in assumption", cfaEdge, expression);
        }
        if (expression instanceof CPointerExpression) {
            return this.soleSuccessor(IntervalAnalysisState.copyOf(element));
        }
        if (expression instanceof CIdExpression) {
            throw new UnrecognizedCCodeException("unexpected expression in assumption", cfaEdge, expression);
        }
        if (expression instanceof CBinaryExpression) {
            IntervalAnalysisState newElement = IntervalAnalysisState.copyOf(element);
            CBinaryExpression.BinaryOperator operator = ((CBinaryExpression)expression).getOperator();
            CExpression operand1 = ((CBinaryExpression)expression).getOperand1();
            CExpression operand2 = ((CBinaryExpression)expression).getOperand2();
            ExpressionValueVisitor visitor = new ExpressionValueVisitor(newElement, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
            Interval interval1 = operand1.accept(visitor);
            Interval interval2 = operand2.accept(visitor);
            switch (operator) {
                case MINUS: 
                case PLUS: {
                    Interval result = null;
                    if (operator == CBinaryExpression.BinaryOperator.MINUS) {
                        result = interval1.minus(interval2);
                    } else if (operator == CBinaryExpression.BinaryOperator.PLUS) {
                        result = interval1.plus(interval2);
                    }
                    if (truthValue && !result.isFalse() || !truthValue && !result.isTrue()) {
                        return this.soleSuccessor(newElement);
                    }
                    return this.noSuccessors();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    return this.processAssumption(newElement, operator, operand1, operand2, truthValue, cfaEdge);
                }
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    return this.soleSuccessor(newElement);
                }
            }
            throw new UnrecognizedCCodeException("unexpected operator in assumption", cfaEdge, expression);
        }
        return this.noSuccessors();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<? extends AbstractState> processAssumption(IntervalAnalysisState element, CBinaryExpression.BinaryOperator operator, CExpression operand1, CExpression operand2, boolean truthValue, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (!truthValue) {
            return this.processAssumption(element, this.negateOperator(operator), operand1, operand2, !truthValue, cfaEdge);
        }
        ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
        Interval orgInterval1 = operand1.accept(visitor);
        Interval orgInterval2 = operand2.accept(visitor);
        Interval tmpInterval1 = orgInterval1;
        Interval tmpInterval2 = orgInterval2;
        String variableName1 = this.constructVariableName(operand1, cfaEdge.getPredecessor().getFunctionName());
        String variableName2 = this.constructVariableName(operand2, cfaEdge.getPredecessor().getFunctionName());
        boolean isIdOp1 = operand1 instanceof CIdExpression;
        boolean isIdOp2 = operand2 instanceof CIdExpression;
        if (operator == CBinaryExpression.BinaryOperator.LESS_THAN) {
            if (!tmpInterval1.mayBeLessThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitUpperBoundBy(tmpInterval2.minus(1L)), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitLowerBoundBy(tmpInterval1.plus(1L)), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == CBinaryExpression.BinaryOperator.LESS_EQUAL) {
            if (!tmpInterval1.mayBeLessOrEqualThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitUpperBoundBy(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitLowerBoundBy(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == CBinaryExpression.BinaryOperator.GREATER_THAN) {
            if (!tmpInterval1.mayBeGreaterThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitLowerBoundBy(tmpInterval2.plus(1L)), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitUpperBoundBy(tmpInterval1.minus(1L)), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == CBinaryExpression.BinaryOperator.GREATER_EQUAL) {
            if (!tmpInterval1.mayBeGreaterOrEqualThan(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.limitLowerBoundBy(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.limitUpperBoundBy(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else if (operator == CBinaryExpression.BinaryOperator.EQUALS) {
            if (!tmpInterval1.intersects(tmpInterval2)) return this.noSuccessors();
            if (isIdOp1) {
                element.addInterval(variableName1, orgInterval1.intersect(tmpInterval2), this.threshold);
            }
            if (!isIdOp2) return this.soleSuccessor(element);
            element.addInterval(variableName2, orgInterval2.intersect(tmpInterval1), this.threshold);
            return this.soleSuccessor(element);
        } else {
            if (operator != CBinaryExpression.BinaryOperator.NOT_EQUALS) throw new UnrecognizedCCodeException("unknown operator", cfaEdge);
            if (tmpInterval1.isSingular() && tmpInterval1.equals(tmpInterval2)) {
                return this.noSuccessors();
            }
            if (!this.splitIntervals || !isIdOp1 || isIdOp2) return this.soleSuccessor(element);
            IntervalAnalysisState newElement = null;
            LinkedList<IntervalAnalysisState> successors = new LinkedList<IntervalAnalysisState>();
            Interval result = null;
            result = orgInterval1.intersect(Interval.createUpperBoundedInterval(orgInterval2.getLow() - 1L));
            if (!result.isEmpty()) {
                newElement = IntervalAnalysisState.copyOf(element);
                newElement.addInterval(variableName1, result, this.threshold);
                successors.add(newElement);
            }
            if ((result = orgInterval1.intersect(Interval.createLowerBoundedInterval(orgInterval2.getLow() + 1L))).isEmpty()) return successors;
            newElement = IntervalAnalysisState.copyOf(element);
            newElement.addInterval(variableName1, result, this.threshold);
            successors.add(newElement);
            return successors;
        }
    }

    private CBinaryExpression.BinaryOperator negateOperator(CBinaryExpression.BinaryOperator operator) {
        switch (operator) {
            case EQUALS: {
                return CBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return CBinaryExpression.BinaryOperator.EQUALS;
            }
            case LESS_THAN: {
                return CBinaryExpression.BinaryOperator.GREATER_EQUAL;
            }
            case LESS_EQUAL: {
                return CBinaryExpression.BinaryOperator.GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return CBinaryExpression.BinaryOperator.LESS_THAN;
            }
            case GREATER_THAN: {
                return CBinaryExpression.BinaryOperator.LESS_EQUAL;
            }
        }
        return operator;
    }

    private IntervalAnalysisState handleDeclaration(IntervalAnalysisState element, CDeclarationEdge declarationEdge) throws UnrecognizedCCodeException {
        IntervalAnalysisState newElement = IntervalAnalysisState.copyOf(element);
        if (declarationEdge.getDeclaration() instanceof CVariableDeclaration) {
            Interval interval;
            String varName;
            CVariableDeclaration decl = (CVariableDeclaration)declarationEdge.getDeclaration();
            if (decl.getType() instanceof CPointerType) {
                return newElement;
            }
            if (decl.isGlobal()) {
                varName = decl.getName();
                this.globalFieldVars.add(varName);
            } else {
                varName = this.constructLocalVariableName(decl.getName(), declarationEdge.getPredecessor().getFunctionName());
            }
            CInitializer init = decl.getInitializer();
            if (init instanceof CInitializerExpression) {
                CExpression exp = ((CInitializerExpression)init).getExpression();
                interval = this.evaluateInterval(element, exp, declarationEdge.getPredecessor().getFunctionName(), declarationEdge);
            } else {
                interval = decl.isGlobal() ? new Interval(0L) : Interval.createUnboundInterval();
            }
            newElement.addInterval(varName, interval, this.threshold);
        }
        return newElement;
    }

    private IntervalAnalysisState handleStatement(IntervalAnalysisState element, CStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof CAssignment) {
            return this.handleAssignment(element, (CAssignment)expression, cfaEdge);
        }
        if (expression instanceof CFunctionCallStatement) {
            return IntervalAnalysisState.copyOf(element);
        }
        if (expression instanceof CExpressionStatement) {
            return IntervalAnalysisState.copyOf(element);
        }
        throw new UnrecognizedCCodeException("unknown statement", cfaEdge, expression);
    }

    private IntervalAnalysisState handleAssignment(IntervalAnalysisState element, CAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        CLeftHandSide op1 = assignExpression.getLeftHandSide();
        CRightHandSide op2 = assignExpression.getRightHandSide();
        if (op1 instanceof CIdExpression) {
            ExpressionValueVisitor visitor = new ExpressionValueVisitor(element, cfaEdge.getPredecessor().getFunctionName(), cfaEdge);
            return this.handleAssignmentToVariable(this.constructVariableName(op1, visitor.functionName), op2, visitor);
        }
        if (op1 instanceof CPointerExpression) {
            return IntervalAnalysisState.copyOf(element);
        }
        if (op1 instanceof CFieldReference) {
            return IntervalAnalysisState.copyOf(element);
        }
        if (op1 instanceof CArraySubscriptExpression) {
            return IntervalAnalysisState.copyOf(element);
        }
        throw new UnrecognizedCCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
    }

    private IntervalAnalysisState handleAssignmentToVariable(String pFullVariableName, CRightHandSide expression, ExpressionValueVisitor v) throws UnrecognizedCCodeException {
        Interval value = expression.accept(v);
        IntervalAnalysisState newElement = IntervalAnalysisState.copyOf(v.state);
        newElement.addInterval(pFullVariableName, value, this.threshold);
        return newElement;
    }

    private Interval evaluateInterval(IntervalAnalysisState element, CRightHandSide expression, String functionName, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof CLiteralExpression) {
            Long value = IntervalAnalysisTransferRelation.parseLiteral((CLiteralExpression)expression, cfaEdge);
            return value == null ? Interval.createUnboundInterval() : new Interval(value, value);
        }
        if (expression instanceof CIdExpression) {
            String varName = this.constructVariableName((CIdExpression)expression, functionName);
            return element.contains(varName) ? element.getInterval(varName) : Interval.createUnboundInterval();
        }
        if (expression instanceof CCastExpression) {
            return this.evaluateInterval(element, ((CCastExpression)expression).getOperand(), functionName, cfaEdge);
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)expression;
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case MINUS: {
                    Interval interval = this.evaluateInterval(element, unaryOperand, functionName, cfaEdge);
                    return interval == null ? Interval.createUnboundInterval() : interval.negate();
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", cfaEdge, unaryExpression);
        }
        if (expression instanceof CPointerExpression) {
            throw new UnrecognizedCCodeException("PointerExpressions are not allowed at this place", cfaEdge, expression);
        }
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)expression;
            Interval interval1 = this.evaluateInterval(element, binaryExpression.getOperand1(), functionName, cfaEdge);
            Interval interval2 = this.evaluateInterval(element, binaryExpression.getOperand2(), functionName, cfaEdge);
            switch (binaryExpression.getOperator()) {
                case PLUS: {
                    return interval1.plus(interval2);
                }
            }
            throw new UnrecognizedCCodeException("unknown binary operator", cfaEdge, binaryExpression);
        }
        return Interval.createUnboundInterval();
    }

    private static Long parseLiteral(CLiteralExpression expression, CFAEdge edge) throws UnrecognizedCCodeException {
        if (expression instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)expression).asLong();
        }
        if (expression instanceof CFloatLiteralExpression) {
            return null;
        }
        if (expression instanceof CCharLiteralExpression) {
            return ((CCharLiteralExpression)expression).getCharacter();
        }
        if (expression instanceof CStringLiteralExpression) {
            return null;
        }
        throw new UnrecognizedCCodeException("unknown literal", edge, expression);
    }

    private String constructLocalVariableName(String pVariableName, String pCalledFunctionName) {
        return pCalledFunctionName + "::" + pVariableName;
    }

    private String constructVariableName(AExpression pVariableName, String pCalledFunctionName) {
        CSimpleDeclaration decl;
        if (pVariableName instanceof CIdExpression && (decl = ((CIdExpression)pVariableName).getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal()) {
            return pVariableName.toASTString();
        }
        if (pVariableName instanceof CFieldReference && this.globalFieldVars.contains(pVariableName.toASTString())) {
            return pVariableName.toASTString();
        }
        return pCalledFunctionName + "::" + pVariableName.toASTString();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision precision) throws UnrecognizedCCodeException {
        return null;
    }

    private Collection<? extends AbstractState> soleSuccessor(AbstractState successor) {
        return Collections.singleton(successor);
    }

    private Collection<? extends AbstractState> noSuccessors() {
        return Collections.emptySet();
    }

    private class ExpressionValueVisitor
    extends DefaultCExpressionVisitor<Interval, UnrecognizedCCodeException>
    implements CRightHandSideVisitor<Interval, UnrecognizedCCodeException> {
        protected final IntervalAnalysisState state;
        protected final String functionName;
        protected final CFAEdge cfaEdge;

        public ExpressionValueVisitor(IntervalAnalysisState pElement, String pFunctionName, CFAEdge edge) {
            this.state = pElement;
            this.functionName = pFunctionName;
            this.cfaEdge = edge;
        }

        @Override
        protected Interval visitDefault(CExpression expression) {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CBinaryExpression binaryExpression) throws UnrecognizedCCodeException {
            Interval interval1 = binaryExpression.getOperand1().accept(this);
            Interval interval2 = binaryExpression.getOperand2().accept(this);
            if (interval1 == null || interval2 == null) {
                return Interval.createUnboundInterval();
            }
            switch (binaryExpression.getOperator()) {
                case PLUS: {
                    return interval1.plus(interval2);
                }
                case MINUS: {
                    return interval1.minus(interval2);
                }
                case MULTIPLY: {
                    return interval1.times(interval2);
                }
                case DIVIDE: {
                    return interval1.divide(interval2);
                }
                case SHIFT_LEFT: {
                    return interval1.shiftLeft(interval2);
                }
                case SHIFT_RIGHT: {
                    return interval1.shiftRight(interval2);
                }
                case EQUALS: {
                    return new Interval(interval1.intersects(interval2) ? 1L : 0L);
                }
                case NOT_EQUALS: {
                    return new Interval(!interval1.intersects(interval2) ? 1L : 0L);
                }
                case GREATER_THAN: {
                    return new Interval(interval1.mayBeGreaterThan(interval2) ? 1L : 0L);
                }
                case GREATER_EQUAL: {
                    return new Interval(interval1.mayBeGreaterOrEqualThan(interval2) ? 1L : 0L);
                }
                case LESS_THAN: {
                    return new Interval(interval1.mayBeLessThan(interval2) ? 1L : 0L);
                }
                case LESS_EQUAL: {
                    return new Interval(interval1.mayBeLessOrEqualThan(interval2) ? 1L : 0L);
                }
                case MODULO: {
                    return interval1.modulo(interval2);
                }
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    return Interval.createUnboundInterval();
                }
            }
            throw new UnrecognizedCCodeException("unkown binary operator", this.cfaEdge, binaryExpression);
        }

        @Override
        public Interval visit(CCastExpression cast) throws UnrecognizedCCodeException {
            return cast.getOperand().accept(this);
        }

        @Override
        public Interval visit(CComplexCastExpression cast) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CFunctionCallExpression functionCall) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CCharLiteralExpression charLiteral) throws UnrecognizedCCodeException {
            Long l = IntervalAnalysisTransferRelation.parseLiteral(charLiteral, this.cfaEdge);
            return l == null ? Interval.createUnboundInterval() : new Interval(l);
        }

        @Override
        public Interval visit(CFloatLiteralExpression floatLiteral) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CImaginaryLiteralExpression exp) throws UnrecognizedCCodeException {
            return exp.getValue().accept(this);
        }

        @Override
        public Interval visit(CIntegerLiteralExpression integerLiteral) throws UnrecognizedCCodeException {
            return new Interval(IntervalAnalysisTransferRelation.parseLiteral(integerLiteral, this.cfaEdge));
        }

        @Override
        public Interval visit(CStringLiteralExpression stringLiteral) throws UnrecognizedCCodeException {
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CIdExpression identifier) throws UnrecognizedCCodeException {
            if (identifier.getDeclaration() instanceof CEnumType.CEnumerator) {
                return new Interval(((CEnumType.CEnumerator)identifier.getDeclaration()).getValue());
            }
            String variableName = IntervalAnalysisTransferRelation.this.constructVariableName(identifier, this.functionName);
            if (this.state.contains(variableName)) {
                return this.state.getInterval(variableName);
            }
            return Interval.createUnboundInterval();
        }

        @Override
        public Interval visit(CUnaryExpression unaryExpression) throws UnrecognizedCCodeException {
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            Interval interval = unaryOperand.accept(this);
            switch (unaryOperator) {
                case MINUS: {
                    return interval != null ? interval.negate() : Interval.createUnboundInterval();
                }
                case AMPER: {
                    return Interval.createUnboundInterval();
                }
            }
            throw new UnrecognizedCCodeException("unknown unary operator", this.cfaEdge, unaryExpression);
        }

        @Override
        public Interval visit(CPointerExpression pointerExpression) throws UnrecognizedCCodeException {
            CExpression operand = pointerExpression.getOperand();
            operand.accept(this);
            return Interval.createUnboundInterval();
        }
    }
}

