/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ICCOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IICOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ISCOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public class CompoundInterval {
    private static final CompoundInterval ZERO = new CompoundInterval(SimpleInterval.singleton(BigInteger.ZERO));
    private static final CompoundInterval ONE = new CompoundInterval(SimpleInterval.singleton(BigInteger.ONE));
    private static final CompoundInterval MINUS_ONE = new CompoundInterval(SimpleInterval.singleton(BigInteger.valueOf(-1L)));
    private static final CompoundInterval BOTTOM = new CompoundInterval();
    private static final CompoundInterval TOP = new CompoundInterval(SimpleInterval.infinite());
    private static final CompoundInterval FALSE = ZERO;
    private static final CompoundInterval TRUE = CompoundInterval.logicalFalse().invert();
    private final SimpleInterval[] intervals;

    private CompoundInterval() {
        this.intervals = new SimpleInterval[0];
    }

    private CompoundInterval(SimpleInterval pInterval) {
        this.intervals = new SimpleInterval[]{pInterval};
    }

    private CompoundInterval(SimpleInterval[] pIntervals) {
        this.intervals = pIntervals;
    }

    private static CompoundInterval getInternal(SimpleInterval pInterval) {
        CompoundInterval cached = CompoundInterval.getCached(pInterval);
        if (cached != null) {
            return cached;
        }
        return new CompoundInterval(pInterval);
    }

    private static CompoundInterval getCached(SimpleInterval pInterval) {
        if (pInterval.isSingleton()) {
            BigInteger value = pInterval.getLowerBound();
            if (value.equals(BigInteger.ONE)) {
                return ONE;
            }
            if (value.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (value.equals(CompoundInterval.MINUS_ONE.intervals[0].getLowerBound())) {
                return MINUS_ONE;
            }
        }
        return null;
    }

    private static CompoundInterval getInternal(SimpleInterval[] pIntervals) {
        CompoundInterval cached;
        if (pIntervals.length == 0) {
            return CompoundInterval.bottom();
        }
        if (pIntervals.length == 1 && (cached = CompoundInterval.getCached(pIntervals[0])) != null) {
            return cached;
        }
        return new CompoundInterval(pIntervals);
    }

    public int getNumberOfIntervals() {
        return this.intervals.length;
    }

    public List<SimpleInterval> getIntervals() {
        return Collections.unmodifiableList(Arrays.asList(this.intervals));
    }

    public CompoundInterval unionWith(CompoundInterval pOther) {
        if (pOther == this || this.isTop() || pOther.isBottom()) {
            return this;
        }
        if (pOther.isTop() || this.isBottom()) {
            return pOther;
        }
        CompoundInterval current = this;
        for (SimpleInterval interval : pOther.intervals) {
            current = current.unionWith(interval);
        }
        return current;
    }

    public CompoundInterval unionWith(SimpleInterval pOther) {
        if (this.contains(pOther)) {
            return this;
        }
        if (this.isBottom() || pOther.isTop()) {
            return CompoundInterval.getInternal(pOther);
        }
        ArrayList<SimpleInterval> resultIntervals = new ArrayList<SimpleInterval>();
        int start = 0;
        SimpleInterval lastInterval = null;
        if (pOther.hasLowerBound() && this.hasUpperBound()) {
            BigInteger pOtherLB = pOther.getLowerBound();
            SimpleInterval currentLocal = this.intervals[start];
            while (currentLocal != null && pOtherLB.compareTo(currentLocal.getUpperBound()) > 0) {
                resultIntervals.add(currentLocal);
                lastInterval = currentLocal;
                SimpleInterval simpleInterval = currentLocal = ++start < this.intervals.length ? this.intervals[start] : null;
                assert (currentLocal == null || currentLocal.hasUpperBound()) : this.toString();
            }
        }
        boolean inserted = false;
        for (int index = start; index < this.intervals.length; ++index) {
            SimpleInterval interval = this.intervals[index];
            boolean currentInserted = false;
            if (interval.touches(lastInterval)) {
                lastInterval = CompoundInterval.union(interval, lastInterval);
                resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                currentInserted = true;
            }
            if (!inserted) {
                if (pOther.touches(lastInterval)) {
                    if ((lastInterval = CompoundInterval.union(pOther, lastInterval)).touches(interval)) {
                        lastInterval = CompoundInterval.union(lastInterval, interval);
                        currentInserted = true;
                    }
                    resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                    inserted = true;
                } else if (pOther.touches(interval)) {
                    lastInterval = CompoundInterval.union(pOther, interval);
                    resultIntervals.add(lastInterval);
                    inserted = true;
                    currentInserted = true;
                } else if (!pOther.hasLowerBound() || interval.hasLowerBound() && CompoundInterval.less(pOther.getLowerBound(), interval.getLowerBound())) {
                    resultIntervals.add(pOther);
                    inserted = true;
                }
                if (currentInserted) continue;
                lastInterval = interval;
                resultIntervals.add(lastInterval);
                continue;
            }
            if (currentInserted) continue;
            lastInterval = interval;
            resultIntervals.add(lastInterval);
        }
        if (!inserted) {
            if (pOther.touches(lastInterval)) {
                resultIntervals.remove(resultIntervals.size() - 1);
                lastInterval = CompoundInterval.union(pOther, lastInterval);
                resultIntervals.add(lastInterval);
            } else {
                resultIntervals.add(pOther);
            }
        }
        SimpleInterval[] resultArray = new SimpleInterval[resultIntervals.size()];
        return CompoundInterval.getInternal(resultIntervals.toArray(resultArray));
    }

    public CompoundInterval intersectWith(CompoundInterval pOther) {
        if (this.isBottom() || pOther.isTop() || this == pOther) {
            return this;
        }
        if (this.isTop() || pOther.isBottom()) {
            return pOther;
        }
        if (pOther.contains(this)) {
            return this;
        }
        CompoundInterval result = CompoundInterval.bottom();
        for (SimpleInterval otherInterval : pOther.intervals) {
            result = result.unionWith(this.intersectWith(otherInterval));
        }
        return result;
    }

    public CompoundInterval intersectWith(SimpleInterval pOther) {
        int intervalIndex;
        int intervalIndex2;
        if (this.isBottom() || pOther.isTop()) {
            return this;
        }
        if (this.contains(pOther)) {
            return CompoundInterval.of(pOther);
        }
        if (this.intervals.length == 1 && pOther.contains(this.intervals[0])) {
            return this;
        }
        CompoundInterval result = CompoundInterval.bottom();
        int lbIndex = pOther.hasLowerBound() ? ((intervalIndex2 = this.intervalIndexOf(pOther.getLowerBound())) >= 0 ? intervalIndex2 : -intervalIndex2 - 1) : 0;
        int ubIndex = pOther.hasUpperBound() ? ((intervalIndex = this.intervalIndexOf(pOther.getUpperBound())) >= 0 ? intervalIndex : -intervalIndex - 1) : this.intervals.length - 1;
        for (int i = lbIndex; i <= ubIndex; ++i) {
            SimpleInterval interval = this.intervals[i];
            if (!interval.intersectsWith(pOther)) continue;
            result = result.unionWith(interval.intersectWith(pOther));
        }
        return result;
    }

    public boolean intersectsWith(CompoundInterval pOther) {
        if (this.contains(pOther)) {
            return !pOther.isBottom();
        }
        if (pOther.contains(this)) {
            return !this.isBottom();
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean intersectsWith(SimpleInterval pOther) {
        if (this.contains(pOther)) {
            return true;
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean contains(CompoundInterval pState) {
        if (this == pState || this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : pState.intervals) {
            if (this.contains(interval)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(SimpleInterval pInterval) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom() || pInterval.isTop()) {
            return false;
        }
        if (!pInterval.hasLowerBound() && this.hasLowerBound()) {
            return false;
        }
        if (!pInterval.hasUpperBound() && this.hasUpperBound()) {
            return false;
        }
        boolean hasLowerBound = pInterval.hasLowerBound();
        boolean hasUpperBound = pInterval.hasUpperBound();
        BigInteger lb = hasLowerBound ? pInterval.getLowerBound() : null;
        BigInteger ub = hasUpperBound ? pInterval.getUpperBound() : null;
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqUb;
            int index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
            SimpleInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqLb = !intervalAtIndex.hasLowerBound() || hasLowerBound && intervalAtIndex.getLowerBound().compareTo(lb) <= 0;
            boolean bl = ubIndexGeqUb = !intervalAtIndex.hasUpperBound() || hasUpperBound && intervalAtIndex.getUpperBound().compareTo(ub) >= 0;
            if (lbIndexLeqLb) {
                if (ubIndexGeqUb) {
                    return true;
                }
                leftInclusive = index + 1;
                continue;
            }
            rightExclusive = index;
        }
        return false;
    }

    private int intervalIndexOf(BigInteger value) {
        if (this.isBottom()) {
            return -1;
        }
        if (this.isTop()) {
            return 0;
        }
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        int index = rightExclusive / 2;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqValue;
            SimpleInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqValue = !intervalAtIndex.hasLowerBound() || intervalAtIndex.getLowerBound().compareTo(value) <= 0;
            boolean bl = ubIndexGeqValue = !intervalAtIndex.hasUpperBound() || intervalAtIndex.getUpperBound().compareTo(value) >= 0;
            if (lbIndexLeqValue) {
                if (ubIndexGeqValue) {
                    return index;
                }
                leftInclusive = index + 1;
            } else {
                rightExclusive = index;
            }
            index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
        }
        return index == 0 ? -1 : -index;
    }

    public boolean contains(BigInteger pValue) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return false;
        }
        return this.contains(SimpleInterval.singleton(pValue));
    }

    public boolean contains(long pValue) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return false;
        }
        BigInteger value = BigInteger.valueOf(pValue);
        return this.intervalIndexOf(value) >= 0;
    }

    public boolean isBottom() {
        return this.intervals.length == 0;
    }

    public boolean isTop() {
        return !this.isBottom() && this.intervals[0].isTop();
    }

    public String toString() {
        if (this.isBottom()) {
            return Character.toString('\u22a5');
        }
        if (this.isTop()) {
            return Character.toString('\u22a4');
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (!this.isBottom()) {
            Iterator<SimpleInterval> intervalIterator = Arrays.asList(this.intervals).iterator();
            sb.append(intervalIterator.next());
            while (intervalIterator.hasNext()) {
                sb.append(", ");
                sb.append(intervalIterator.next());
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean hasLowerBound() {
        if (this.isTop() || this.isBottom()) {
            return false;
        }
        return this.intervals[0].hasLowerBound();
    }

    public boolean hasUpperBound() {
        if (this.isTop() || this.isBottom()) {
            return false;
        }
        return this.intervals[this.intervals.length - 1].hasUpperBound();
    }

    public BigInteger getLowerBound() {
        return this.intervals[0].getLowerBound();
    }

    public BigInteger getUpperBound() {
        return this.intervals[this.intervals.length - 1].getUpperBound();
    }

    public boolean isSingleton() {
        return !this.isBottom() && this.intervals.length == 1 && this.intervals[0].isSingleton();
    }

    @Nullable
    public BigInteger getValue() {
        if (this.isBottom()) {
            return null;
        }
        if (this.isTop()) {
            return BigInteger.ZERO;
        }
        for (SimpleInterval interval : this.intervals) {
            if (interval.hasLowerBound()) {
                return interval.getLowerBound();
            }
            if (!interval.hasUpperBound()) continue;
            return interval.getUpperBound();
        }
        return null;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther instanceof CompoundInterval) {
            return Arrays.equals(this.intervals, ((CompoundInterval)pOther).intervals);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.intervals);
    }

    public CompoundInterval signum() {
        CompoundInterval result = CompoundInterval.bottom();
        if (this.containsNegative()) {
            result = result.unionWith(CompoundInterval.singleton(-1L));
        }
        if (this.containsZero()) {
            result = result.unionWith(CompoundInterval.singleton(0L));
        }
        if (this.containsPositive()) {
            result = result.unionWith(CompoundInterval.singleton(1L));
        }
        return result;
    }

    public CompoundInterval span() {
        BigInteger lowerBound = null;
        BigInteger upperBound = null;
        if (this.hasLowerBound()) {
            lowerBound = this.getLowerBound();
        }
        if (this.hasUpperBound()) {
            upperBound = this.getUpperBound();
        }
        return CompoundInterval.of(CompoundInterval.createSimpleInterval(lowerBound, upperBound));
    }

    public CompoundInterval invert() {
        if (this.isTop()) {
            return CompoundInterval.bottom();
        }
        if (this.isBottom()) {
            return CompoundInterval.top();
        }
        CompoundInterval result = CompoundInterval.bottom();
        int index = 0;
        BigInteger currentLowerBound = null;
        if (!this.hasLowerBound()) {
            currentLowerBound = this.intervals[index++].getUpperBound().add(BigInteger.ONE);
        }
        while (index < this.intervals.length) {
            SimpleInterval current = this.intervals[index++];
            result = result.unionWith(CompoundInterval.createSimpleInterval(currentLowerBound, current.getLowerBound().subtract(BigInteger.ONE)));
            if (current.hasUpperBound()) {
                currentLowerBound = current.getUpperBound().add(BigInteger.ONE);
                continue;
            }
            currentLowerBound = null;
        }
        if (currentLowerBound != null) {
            SimpleInterval[] resultIntervals = new SimpleInterval[result.intervals.length + 1];
            System.arraycopy(result.intervals, 0, resultIntervals, 0, result.intervals.length);
            resultIntervals[result.intervals.length] = CompoundInterval.createSimpleInterval(currentLowerBound, null);
            result = CompoundInterval.getInternal(resultIntervals);
        }
        return result;
    }

    public CompoundInterval negate() {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        CompoundInterval result = CompoundInterval.bottom();
        for (SimpleInterval simpleInterval : this.intervals) {
            result = result.unionWith(simpleInterval.negate());
        }
        return result;
    }

    public boolean containsPositive() {
        if (this.isBottom()) {
            return false;
        }
        if (this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : this.intervals) {
            if (!interval.containsPositive()) continue;
            return true;
        }
        return false;
    }

    public boolean containsNegative() {
        if (this.isBottom()) {
            return false;
        }
        if (this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : this.intervals) {
            if (!interval.containsNegative()) continue;
            return true;
        }
        return false;
    }

    public boolean containsZero() {
        return this.contains(0L);
    }

    public CompoundInterval extendToNegativeInfinity() {
        if (!this.hasLowerBound()) {
            return this;
        }
        SimpleInterval[] resultIntervals = new SimpleInterval[this.intervals.length];
        resultIntervals[0] = this.intervals[0].extendToNegativeInfinity();
        System.arraycopy(this.intervals, 1, resultIntervals, 1, this.intervals.length - 1);
        return CompoundInterval.getInternal(resultIntervals);
    }

    public CompoundInterval extendToPositiveInfinity() {
        if (!this.hasUpperBound()) {
            return this;
        }
        SimpleInterval[] resultIntervals = new SimpleInterval[this.intervals.length];
        int index = this.intervals.length - 1;
        System.arraycopy(this.intervals, 0, resultIntervals, 0, index);
        resultIntervals[index] = this.intervals[index].extendToPositiveInfinity();
        return CompoundInterval.getInternal(resultIntervals);
    }

    public CompoundInterval add(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.ADD, pValue);
    }

    public CompoundInterval add(long pValue) {
        return this.add(BigInteger.valueOf(pValue));
    }

    public CompoundInterval add(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.ADD, pInterval);
    }

    public CompoundInterval add(CompoundInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.ADD, pState);
    }

    public CompoundInterval multiply(BigInteger pValue) {
        if (pValue.equals(BigInteger.ZERO)) {
            return CompoundInterval.singleton(pValue);
        }
        if (pValue.equals(BigInteger.ONE)) {
            return this;
        }
        CompoundInterval result = this.applyOperationToAllAndUnite(ISCOperator.MULTIPLY, pValue);
        if (result.isTop()) {
            SimpleInterval[] resultIntervals = new SimpleInterval[7];
            if (pValue.signum() >= 0) {
                for (int i = -3; i <= 3; ++i) {
                    resultIntervals[i + 3] = SimpleInterval.singleton(pValue.multiply(BigInteger.valueOf(i)));
                }
            } else {
                for (int i = -3; i <= 3; ++i) {
                    resultIntervals[3 - i] = SimpleInterval.singleton(pValue.multiply(BigInteger.valueOf(i)));
                }
            }
            resultIntervals[0] = resultIntervals[0].extendToNegativeInfinity();
            resultIntervals[6] = resultIntervals[6].extendToPositiveInfinity();
            result = CompoundInterval.getInternal(resultIntervals);
        }
        return result;
    }

    public CompoundInterval multiply(SimpleInterval pInterval) {
        if (pInterval.isSingleton()) {
            return this.multiply(pInterval.getLowerBound());
        }
        return this.applyOperationToAllAndUnite(IICOperator.MULTIPLY, pInterval);
    }

    public CompoundInterval multiply(CompoundInterval pState) {
        if (pState.intervals.length == 1) {
            return this.multiply(pState.intervals[0]);
        }
        return this.applyOperationToAllAndUnite(ICCOperator.MULTIPLY, pState);
    }

    public CompoundInterval divide(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.DIVIDE, pValue);
    }

    public CompoundInterval divide(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.DIVIDE, pInterval);
    }

    public CompoundInterval divide(CompoundInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.DIVIDE, pState);
    }

    public CompoundInterval modulo(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.MODULO, pValue);
    }

    public CompoundInterval modulo(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.MODULO, pInterval);
    }

    public CompoundInterval modulo(CompoundInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.MODULO, pState);
    }

    public CompoundInterval shiftLeft(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.SHIFT_LEFT, pValue);
    }

    public CompoundInterval shiftLeft(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.SHIFT_LEFT, pInterval);
    }

    public CompoundInterval shiftLeft(CompoundInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.SHIFT_LEFT, pState);
    }

    public CompoundInterval shiftRight(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.SHIFT_RIGHT, pValue);
    }

    public CompoundInterval shiftRight(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.SHIFT_RIGHT, pInterval);
    }

    public CompoundInterval shiftRight(CompoundInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.SHIFT_RIGHT, pState);
    }

    public CompoundInterval logicalEquals(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.isSingleton() && this.equals(pState)) {
            return CompoundInterval.logicalTrue();
        }
        if (!this.intersectsWith(pState)) {
            return CompoundInterval.logicalFalse();
        }
        return CompoundInterval.top();
    }

    public boolean isDefinitelyFalse() {
        return this.equals(CompoundInterval.logicalFalse());
    }

    public boolean isDefinitelyTrue() {
        return !this.isBottom() && !this.containsZero();
    }

    public CompoundInterval greaterThan(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) > 0) {
            return TRUE;
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) <= 0) {
            return FALSE;
        }
        return CompoundInterval.top();
    }

    public CompoundInterval greaterEqual(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) >= 0) {
            return TRUE;
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) < 0) {
            return FALSE;
        }
        return CompoundInterval.top();
    }

    public CompoundInterval lessThan(CompoundInterval pState) {
        return this.greaterEqual(pState).logicalNot();
    }

    public CompoundInterval lessEqual(CompoundInterval pState) {
        return this.greaterThan(pState).logicalNot();
    }

    public CompoundInterval logicalAnd(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero() || pState.isSingleton() && pState.containsZero()) {
            return CompoundInterval.logicalFalse();
        }
        if (!this.containsZero() && !pState.containsZero()) {
            return CompoundInterval.logicalTrue();
        }
        return CompoundInterval.top();
    }

    public CompoundInterval logicalOr(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero() && pState.isSingleton() && pState.containsZero()) {
            return CompoundInterval.logicalFalse();
        }
        if (!this.containsZero() || !pState.containsZero()) {
            return CompoundInterval.logicalTrue();
        }
        return CompoundInterval.top();
    }

    public CompoundInterval logicalNot() {
        if (this.isBottom()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return TRUE;
        }
        if (!this.containsZero()) {
            return FALSE;
        }
        return CompoundInterval.top();
    }

    public CompoundInterval binaryAnd(CompoundInterval pState) {
        CompoundInterval result;
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return pState;
        }
        if (this.isSingleton() && this.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            result = CompoundInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return pState.contains(1L) ? CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE)) : CompoundInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().and(pState.getValue())));
            }
        } else {
            if (this.isSingleton()) {
                return pState.binaryAnd(this);
            }
            result = CompoundInterval.top();
        }
        if (!result.isSingleton()) {
            CompoundInterval absThis = this.absolute();
            CompoundInterval absOther = pState.absolute();
            BigInteger smallestUpperBound = null;
            if (absThis.hasUpperBound()) {
                smallestUpperBound = absThis.getUpperBound();
            }
            if (absOther.hasUpperBound()) {
                BigInteger bigInteger = smallestUpperBound = smallestUpperBound == null ? absOther.getUpperBound() : smallestUpperBound.min(absOther.getUpperBound());
            }
            assert (smallestUpperBound == null || smallestUpperBound.signum() >= 0);
            CompoundInterval range = smallestUpperBound == null ? CompoundInterval.zero().extendToPositiveInfinity() : CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, smallestUpperBound));
            if (this.containsNegative() && pState.containsNegative()) {
                range = range.unionWith(range.negate());
            }
            result = result.intersectWith(range);
        }
        return result;
    }

    public CompoundInterval absolute() {
        if (!this.containsNegative()) {
            return this;
        }
        return this.intersectWith(CompoundInterval.one().negate().extendToNegativeInfinity()).negate().unionWith(this.intersectWith(CompoundInterval.zero().extendToPositiveInfinity()));
    }

    public CompoundInterval binaryXor(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.isSingleton() && pState.isSingleton()) {
            return CompoundInterval.singleton(this.getValue().xor(pState.getValue()));
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        CompoundInterval zeroToOne = CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        if (pState.isSingleton() && pState.contains(1L) && this.equals(zeroToOne)) {
            return this;
        }
        if (this.isSingleton() && this.contains(1L) && pState.equals(zeroToOne)) {
            return zeroToOne;
        }
        if (pState.isSingleton()) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().xor(pState.getValue())));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryXor(this);
        }
        return CompoundInterval.top();
    }

    public CompoundInterval binaryNot() {
        if (this.isBottom()) {
            return CompoundInterval.bottom();
        }
        CompoundInterval result = CompoundInterval.bottom();
        for (SimpleInterval interval : this.intervals) {
            if (!interval.isSingleton()) {
                if (!this.containsNegative()) {
                    return CompoundInterval.singleton(0L).extendToNegativeInfinity();
                }
                if (!this.containsPositive()) {
                    return CompoundInterval.singleton(0L).extendToPositiveInfinity();
                }
                return CompoundInterval.top();
            }
            result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().not()));
        }
        return result;
    }

    public CompoundInterval binaryOr(CompoundInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().or(pState.getValue())));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryOr(this);
        }
        return CompoundInterval.top();
    }

    public CompoundInterval logicalXor(CompoundInterval pState) {
        return CompoundInterval.logicalAnd(CompoundInterval.logicalOr(this, pState), CompoundInterval.logicalNot(CompoundInterval.logicalAnd(this, pState)));
    }

    public static CompoundInterval logicalAnd(CompoundInterval p1, CompoundInterval p2) {
        return p1.logicalAnd(p2);
    }

    public static CompoundInterval logicalOr(CompoundInterval p1, CompoundInterval p2) {
        return p1.logicalOr(p2);
    }

    public static CompoundInterval logicalXor(CompoundInterval p1, CompoundInterval p2) {
        return p1.logicalXor(p2);
    }

    public static CompoundInterval logicalNot(CompoundInterval pState) {
        return pState.logicalNot();
    }

    private <T> CompoundInterval applyOperationToAllAndUnite(Operator<SimpleInterval, T, CompoundInterval> pOperator, T pOperand) {
        CompoundInterval result = CompoundInterval.bottom();
        for (SimpleInterval interval : this.intervals) {
            CompoundInterval current = pOperator.apply(interval, pOperand);
            if (current == null || !(result = result.unionWith(current)).isTop()) continue;
            return result;
        }
        return result;
    }

    private static SimpleInterval union(SimpleInterval a, SimpleInterval b) {
        Preconditions.checkArgument((boolean)a.touches(b), (Object)"Cannot unite intervals that do not touch.");
        return CompoundInterval.createSimpleInterval(CompoundInterval.lowestBound(a, b), CompoundInterval.highestBound(a, b));
    }

    @Nullable
    private static BigInteger lowestBound(SimpleInterval a, SimpleInterval b) {
        BigInteger bLowerBound;
        if (!a.hasLowerBound() || !b.hasLowerBound()) {
            return null;
        }
        BigInteger aLowerBound = a.getLowerBound();
        return CompoundInterval.lessOrEqual(aLowerBound, bLowerBound = b.getLowerBound()) ? aLowerBound : bLowerBound;
    }

    private static BigInteger highestBound(SimpleInterval a, SimpleInterval b) {
        if (!a.hasUpperBound() || !b.hasUpperBound()) {
            return null;
        }
        BigInteger aUpperBound = a.getUpperBound();
        BigInteger bUpperBound = b.getUpperBound();
        return CompoundInterval.lessOrEqual(bUpperBound, aUpperBound) ? aUpperBound : bUpperBound;
    }

    private static boolean less(BigInteger first, BigInteger second) {
        return first.compareTo(second) < 0;
    }

    private static boolean lessOrEqual(BigInteger first, BigInteger second) {
        return first.compareTo(second) <= 0;
    }

    public static CompoundInterval of(@Nullable SimpleInterval interval) {
        if (interval == null) {
            return CompoundInterval.bottom();
        }
        return CompoundInterval.getInternal(interval);
    }

    public static CompoundInterval singleton(BigInteger pValue) {
        Preconditions.checkNotNull((Object)pValue);
        return CompoundInterval.of(SimpleInterval.singleton(pValue));
    }

    public static CompoundInterval singleton(long pValue) {
        return CompoundInterval.singleton(BigInteger.valueOf(pValue));
    }

    public static CompoundInterval bottom() {
        return BOTTOM;
    }

    public static CompoundInterval top() {
        return TOP;
    }

    public static CompoundInterval logicalFalse() {
        return FALSE;
    }

    public static CompoundInterval logicalTrue() {
        return TRUE;
    }

    public static CompoundInterval zero() {
        return ZERO;
    }

    public static CompoundInterval one() {
        return ONE;
    }

    public static CompoundInterval minusOne() {
        return MINUS_ONE;
    }

    private static SimpleInterval createSimpleInterval(@Nullable BigInteger lowerBound, @Nullable BigInteger upperBound) {
        if (lowerBound == null) {
            if (upperBound == null) {
                return SimpleInterval.infinite();
            }
            return SimpleInterval.singleton(upperBound).extendToNegativeInfinity();
        }
        if (upperBound == null) {
            return SimpleInterval.singleton(lowerBound).extendToPositiveInfinity();
        }
        return SimpleInterval.of(lowerBound, upperBound);
    }

    public static CompoundInterval span(CompoundInterval pLeftValue, CompoundInterval pRightValue) {
        return pLeftValue.span().unionWith(pRightValue.span()).span();
    }

    public static CompoundInterval union(CompoundInterval pLeftValue, CompoundInterval pRightValue) {
        return pLeftValue.unionWith(pRightValue);
    }

    public static CompoundInterval fromBoolean(boolean value) {
        return value ? CompoundInterval.logicalTrue() : CompoundInterval.logicalFalse();
    }
}

