/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.math.BigInteger;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

public class CompoundIntervalTest {
    private final SimpleInterval oneToFiveInterval = SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(5L));
    private final SimpleInterval sixToTenInterval = SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.valueOf(10L));
    private final SimpleInterval oneToTenInterval = SimpleInterval.of(BigInteger.ONE, BigInteger.TEN);
    private final SimpleInterval negInfToZeroInterval = SimpleInterval.singleton(BigInteger.ZERO).extendToNegativeInfinity();
    private final SimpleInterval zeroToPosInfInterval = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();

    @Test
    public void testIsTop() {
        Assert.assertFalse((boolean)CompoundInterval.of(this.oneToTenInterval).isTop());
        Assert.assertFalse((boolean)CompoundInterval.of(this.negInfToZeroInterval).isTop());
        Assert.assertFalse((boolean)CompoundInterval.of(this.zeroToPosInfInterval).isTop());
        Assert.assertFalse((boolean)CompoundInterval.bottom().isTop());
        Assert.assertTrue((boolean)CompoundInterval.top().isTop());
    }

    @Test
    public void testIsBottom() {
        Assert.assertFalse((boolean)CompoundInterval.of(this.oneToTenInterval).isBottom());
        Assert.assertFalse((boolean)CompoundInterval.of(this.negInfToZeroInterval).isBottom());
        Assert.assertFalse((boolean)CompoundInterval.of(this.zeroToPosInfInterval).isBottom());
        Assert.assertFalse((boolean)CompoundInterval.top().isBottom());
        Assert.assertTrue((boolean)CompoundInterval.bottom().isBottom());
    }

    @Test
    public void testUnionWith() {
        int i;
        Assert.assertTrue((boolean)CompoundInterval.of(this.negInfToZeroInterval).unionWith(this.zeroToPosInfInterval).isTop());
        Assert.assertTrue((boolean)CompoundInterval.of(this.negInfToZeroInterval).unionWith(CompoundInterval.of(this.zeroToPosInfInterval)).isTop());
        Assert.assertTrue((boolean)CompoundInterval.bottom().unionWith(CompoundInterval.top()).isTop());
        Assert.assertFalse((boolean)CompoundInterval.of(this.negInfToZeroInterval).unionWith(CompoundInterval.of(this.oneToTenInterval)).isTop());
        Assert.assertEquals((Object)CompoundInterval.of(this.oneToFiveInterval).unionWith(this.sixToTenInterval), (Object)CompoundInterval.of(this.oneToTenInterval));
        Assert.assertEquals((Object)CompoundInterval.of(this.oneToTenInterval).unionWith(this.sixToTenInterval), (Object)CompoundInterval.of(this.oneToTenInterval));
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        Assert.assertEquals((long)1L, (long)CompoundInterval.of(zero.extendToNegativeInfinity()).unionWith(zero.extendToPositiveInfinity()).getIntervals().size());
        SimpleInterval zeroToThreeInterval = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(3L));
        CompoundInterval zeroToThree = CompoundInterval.of(zeroToThreeInterval);
        CompoundInterval six = CompoundInterval.singleton(6L);
        Assert.assertEquals((long)2L, (long)zeroToThree.unionWith(six).getIntervals().size());
        Assert.assertEquals((Object)zeroToThree.unionWith(six), (Object)six.unionWith(zeroToThree));
        Assert.assertEquals((Object)zeroToThree, (Object)zeroToThree.unionWith(CompoundInterval.singleton(0L)));
        Assert.assertEquals((Object)zeroToThree, (Object)zeroToThree.unionWith(CompoundInterval.singleton(1L)));
        Assert.assertEquals((Object)zeroToThree, (Object)zeroToThree.unionWith(CompoundInterval.singleton(2L)));
        Assert.assertEquals((Object)zeroToThree, (Object)zeroToThree.unionWith(CompoundInterval.singleton(3L)));
        Assert.assertEquals((Object)zeroToThree, (Object)zeroToThree.unionWith(zeroToThree));
        CompoundInterval steps = CompoundInterval.bottom();
        for (i = -6; i <= 6; i += 2) {
            steps = steps.unionWith(CompoundInterval.singleton(i));
        }
        steps = steps.extendToNegativeInfinity().extendToPositiveInfinity();
        for (i = -6; i <= 6; i += 2) {
            Assert.assertTrue((boolean)steps.contains(i));
        }
        CompoundInterval stepsNegInf = steps.unionWith(CompoundInterval.singleton(BigInteger.valueOf(-4L)).extendToNegativeInfinity());
        for (int i2 = -6; i2 <= 6; i2 += 2) {
            Assert.assertTrue((boolean)stepsNegInf.contains(i2));
        }
        CompoundInterval zeroOrTenToInf = CompoundInterval.singleton(0L).unionWith(CompoundInterval.singleton(10L).extendToPositiveInfinity());
        CompoundInterval negOne = CompoundInterval.singleton(-1L);
        CompoundInterval negOneOrZeroOrTenToInf = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-1L), BigInteger.ZERO)).unionWith(CompoundInterval.singleton(10L).extendToPositiveInfinity());
        Assert.assertEquals((Object)negOneOrZeroOrTenToInf, (Object)zeroOrTenToInf.unionWith(negOne));
        Assert.assertEquals((Object)CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-1L), BigInteger.valueOf(1L))), (Object)negOne.unionWith(CompoundInterval.one()).unionWith(zero));
        Assert.assertEquals((long)1L, (long)negOne.unionWith(CompoundInterval.one()).unionWith(zero).getIntervals().size());
    }

    @Test
    public void testIntersectWith() {
        Assert.assertEquals((Object)CompoundInterval.of(SimpleInterval.singleton(BigInteger.ZERO)), (Object)CompoundInterval.of(this.negInfToZeroInterval).intersectWith(this.zeroToPosInfInterval));
        Assert.assertEquals((Object)CompoundInterval.of(SimpleInterval.singleton(BigInteger.ZERO)), (Object)CompoundInterval.of(this.negInfToZeroInterval).intersectWith(CompoundInterval.of(this.zeroToPosInfInterval)));
        Assert.assertTrue((boolean)CompoundInterval.bottom().intersectWith(CompoundInterval.top()).isBottom());
        Assert.assertEquals((Object)CompoundInterval.of(this.oneToTenInterval), (Object)CompoundInterval.top().intersectWith(CompoundInterval.of(this.oneToTenInterval)));
        SimpleInterval oneToTwo = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        CompoundInterval notTwo = CompoundInterval.singleton(2L).invert();
        Assert.assertEquals((Object)CompoundInterval.singleton(1L), (Object)notTwo.intersectWith(CompoundInterval.of(oneToTwo)));
    }

    @Test
    public void testInvert() {
        Assert.assertEquals((Object)CompoundInterval.bottom(), (Object)CompoundInterval.top().invert());
        Assert.assertEquals((Object)CompoundInterval.top(), (Object)CompoundInterval.bottom().invert());
        CompoundInterval negInfToTen = CompoundInterval.singleton(10L).extendToNegativeInfinity();
        CompoundInterval elevenToInf = CompoundInterval.singleton(11L).extendToPositiveInfinity();
        Assert.assertEquals((Object)elevenToInf, (Object)negInfToTen.invert());
        Assert.assertEquals((Object)negInfToTen, (Object)elevenToInf.invert());
        Assert.assertEquals((Object)negInfToTen, (Object)negInfToTen.invert().invert());
        for (int i = -1; i < 2; ++i) {
            CompoundInterval invertedState = CompoundInterval.singleton(i).invert();
            Assert.assertFalse((boolean)invertedState.contains(i));
            Assert.assertFalse((boolean)invertedState.hasLowerBound());
            Assert.assertFalse((boolean)invertedState.hasUpperBound());
            Assert.assertFalse((boolean)invertedState.isTop());
            Assert.assertFalse((boolean)invertedState.isBottom());
            Assert.assertTrue((boolean)invertedState.contains(i - 1));
            Assert.assertTrue((boolean)invertedState.contains(i + 1));
        }
        Assert.assertEquals((Object)CompoundInterval.singleton(0L).extendToNegativeInfinity().unionWith(CompoundInterval.singleton(6L)), (Object)CompoundInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(5L))).unionWith(CompoundInterval.singleton(7L).extendToPositiveInfinity()).invert());
    }

    @Test
    public void moduloTest() {
        SimpleInterval zeroToThreeInterval = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(3L));
        CompoundInterval zeroToThree = CompoundInterval.of(zeroToThreeInterval);
        CompoundInterval six = CompoundInterval.singleton(6L);
        SimpleInterval sixToTenInterval = SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.valueOf(10L));
        CompoundInterval sixToTen = CompoundInterval.of(sixToTenInterval);
        Assert.assertEquals((Object)zeroToThree.unionWith(six), (Object)sixToTen.modulo(BigInteger.valueOf(7L)));
        Assert.assertEquals((Object)zeroToThree.unionWith(six).negate(), (Object)sixToTen.negate().modulo(BigInteger.valueOf(7L)));
        Assert.assertEquals((Object)zeroToThree.unionWith(six), (Object)sixToTen.modulo(BigInteger.valueOf(7L).negate()));
        Assert.assertEquals((Object)zeroToThree.unionWith(six).negate(), (Object)sixToTen.negate().modulo(BigInteger.valueOf(7L).negate()));
    }

    @Test
    public void testNegate() {
        Assert.assertEquals((Object)CompoundInterval.singleton(-1L), (Object)CompoundInterval.one().negate());
        CompoundInterval twoToFour = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L)));
        CompoundInterval negTwoToNegOne = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L)));
        CompoundInterval negFourToNegTwo = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L)));
        CompoundInterval oneToTwo = CompoundInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(2L)));
        Assert.assertEquals((Object)oneToTwo.unionWith(negFourToNegTwo), (Object)negTwoToNegOne.unionWith(twoToFour).negate());
    }

    @Test
    public void testIsSingleton() {
        CompoundInterval negOne = CompoundInterval.singleton(-1L);
        CompoundInterval zero = CompoundInterval.singleton(0L);
        CompoundInterval ten = CompoundInterval.singleton(10L);
        Assert.assertTrue((boolean)negOne.isSingleton());
        Assert.assertTrue((boolean)zero.isSingleton());
        Assert.assertTrue((boolean)CompoundInterval.one().isSingleton());
        Assert.assertTrue((boolean)ten.isSingleton());
        Assert.assertFalse((boolean)CompoundInterval.span(CompoundInterval.one(), ten).isSingleton());
        Assert.assertFalse((boolean)zero.unionWith(ten).isSingleton());
        Assert.assertFalse((boolean)negOne.unionWith(CompoundInterval.span(CompoundInterval.one(), ten)).isSingleton());
    }

    @Test
    public void containsTest() {
        Assert.assertTrue((boolean)CompoundInterval.singleton(-1L).contains(-1L));
        Assert.assertTrue((boolean)CompoundInterval.singleton(0L).contains(0L));
        Assert.assertTrue((boolean)CompoundInterval.one().contains(1L));
        Assert.assertTrue((boolean)CompoundInterval.singleton(-1L).contains(CompoundInterval.singleton(-1L)));
        Assert.assertTrue((boolean)CompoundInterval.singleton(0L).contains(CompoundInterval.singleton(0L)));
        Assert.assertTrue((boolean)CompoundInterval.singleton(1L).contains(CompoundInterval.singleton(1L)));
        Assert.assertTrue((boolean)CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(CompoundInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.TEN))));
        Assert.assertFalse((boolean)CompoundInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.TEN)).contains(CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN))));
        Assert.assertTrue((boolean)CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(5L));
        Assert.assertFalse((boolean)CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(-1L));
        Assert.assertFalse((boolean)CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(4L))).unionWith(SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.TEN)).contains(5L));
    }

    @Test
    public void binaryNotTest() {
        CompoundInterval.singleton(1L).extendToNegativeInfinity().binaryNot();
    }

    @Test
    public void testMultiply() {
        CompoundInterval topMultNeg2 = CompoundInterval.top().multiply(BigInteger.valueOf(-2L));
        List<SimpleInterval> intervals = topMultNeg2.getIntervals();
        int i = 0;
        BigInteger lastUpperBound = null;
        for (SimpleInterval interval : intervals) {
            if (i == 0) {
                Assert.assertFalse((boolean)interval.hasLowerBound());
            } else {
                Assert.assertTrue((boolean)interval.hasLowerBound());
                Assert.assertTrue((interval.getLowerBound().subtract(lastUpperBound).compareTo(BigInteger.ONE) > 0 ? 1 : 0) != 0);
            }
            if (i == intervals.size() - 1) {
                Assert.assertFalse((boolean)interval.hasUpperBound());
            }
            if (interval.hasUpperBound()) {
                lastUpperBound = interval.getUpperBound();
            }
            ++i;
        }
        Assert.assertEquals((Object)topMultNeg2, (Object)topMultNeg2.unionWith(topMultNeg2));
    }

    @Test
    public void testBinaryXor() {
        CompoundInterval zeroToOne = CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        CompoundInterval one = CompoundInterval.one();
        Assert.assertEquals((Object)zeroToOne, (Object)zeroToOne.binaryXor(one));
        Assert.assertEquals((Object)zeroToOne, (Object)one.binaryXor(zeroToOne));
    }

    @Test
    public void testBinaryAnd() {
        CompoundInterval zeroToOne = CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        CompoundInterval one = CompoundInterval.one();
        Assert.assertEquals((Object)zeroToOne, (Object)CompoundInterval.top().binaryAnd(one));
        Assert.assertEquals((Object)zeroToOne, (Object)one.binaryAnd(CompoundInterval.top()));
        CompoundInterval.top().binaryAnd(CompoundInterval.singleton(8L));
    }

    @Test
    public void testAbsolute() {
        Assert.assertFalse((boolean)CompoundInterval.top().absolute().containsNegative());
        Assert.assertEquals((Object)CompoundInterval.one(), (Object)CompoundInterval.one().negate().absolute());
        CompoundInterval twoToFour = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L)));
        CompoundInterval negTwoToNegOne = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L)));
        CompoundInterval negFourToNegTwo = CompoundInterval.of(SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L)));
        CompoundInterval oneToTwo = CompoundInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(2L)));
        Assert.assertFalse((boolean)twoToFour.absolute().containsNegative());
        Assert.assertFalse((boolean)negFourToNegTwo.absolute().containsNegative());
        Assert.assertFalse((boolean)negFourToNegTwo.negate().absolute().containsNegative());
        Assert.assertFalse((boolean)oneToTwo.absolute().containsNegative());
        Assert.assertFalse((boolean)oneToTwo.negate().absolute().containsNegative());
        Assert.assertFalse((boolean)negTwoToNegOne.unionWith(twoToFour).negate().absolute().containsNegative());
    }
}

