/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStateFactories;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStateFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsMergeOperator;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsTransferRelation;
import org.sosy_lab.cpachecker.cpa.invariants.VariableNameExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptAllVariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptSpecifiedVariableSelection;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;

public class InvariantsCPA
implements ConfigurableProgramAnalysis,
ReachedSetAdjustingCPA {
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private final InvariantsOptions options;
    private final Configuration config;
    private final LogManager logManager;
    private final ReachedSetFactory reachedSetFactory;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final MachineModel machineModel;
    private final WeakHashMap<CFANode, InvariantsPrecision> initialPrecisionMap = new WeakHashMap();
    private boolean relevantVariableLimitReached = false;
    private final Map<CFANode, InvariantsFormula<CompoundInterval>> invariants = new HashMap<CFANode, InvariantsFormula<CompoundInterval>>();
    private final ConditionAdjuster conditionAdjuster;
    private final Set<String> interestingVariables = new LinkedHashSet<String>();
    private final MergeOperator mergeOperator;
    private final AbstractDomain abstractDomain;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(InvariantsCPA.class).withOptions(InvariantsOptions.class);
    }

    public InvariantsCPA(Configuration pConfig, LogManager pLogManager, InvariantsOptions pOptions, ShutdownNotifier pShutdownNotifier, ReachedSetFactory pReachedSetFactory, CFA pCfa) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logManager = pLogManager;
        this.shutdownNotifier = pShutdownNotifier;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCfa;
        this.options = pOptions;
        this.conditionAdjuster = pOptions.conditionAdjusterFactory.createConditionAdjuster(this);
        this.machineModel = pCfa.getMachineModel();
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        if (pOptions.merge.equalsIgnoreCase("precisiondependent")) {
            this.mergeOperator = new InvariantsMergeOperator();
        } else if (pOptions.merge.equalsIgnoreCase("sep")) {
            this.mergeOperator = MergeSepOperator.getInstance();
        } else {
            assert (pOptions.merge.equalsIgnoreCase("join"));
            this.mergeOperator = new MergeJoinOperator(this.abstractDomain);
        }
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return InvariantsTransferRelation.INSTANCE;
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        AcceptAllVariableSelection<CompoundInterval> variableSelection;
        boolean guessInterestingInformation;
        LinkedHashSet<String> interestingVariables;
        boolean determineTargetLocations;
        LinkedHashSet<CFANode> relevantLocations = new LinkedHashSet<CFANode>();
        ImmutableSet<CFANode> targetLocations = new LinkedHashSet();
        int interestingVariableLimit = this.options.interestingVariableLimit;
        boolean bl = determineTargetLocations = this.options.analyzeTargetPathsOnly || this.options.interestingVariableLimit != 0;
        if (determineTargetLocations) {
            TargetLocationProvider tlp = new TargetLocationProvider(this.reachedSetFactory, this.shutdownNotifier, this.logManager, this.config, this.cfa);
            targetLocations = tlp.tryGetAutomatonTargetLocations(pNode);
            boolean bl2 = determineTargetLocations = targetLocations != null;
            if (targetLocations == null) {
                targetLocations = ImmutableSet.of();
            }
        }
        if (this.shutdownNotifier.shouldShutdown()) {
            return new InvariantsState(new AcceptAllVariableSelection<CompoundInterval>(), this.machineModel, this.options.abstractionStateFactory.getAbstractionState());
        }
        if (this.options.analyzeTargetPathsOnly && determineTargetLocations) {
            relevantLocations.addAll((Collection<CFANode>)targetLocations);
        } else {
            relevantLocations.addAll(this.cfa.getAllNodes());
        }
        LinkedHashSet<CFAEdge> relevantEdges = new LinkedHashSet<CFAEdge>();
        LinkedHashSet interestingPredicates = new LinkedHashSet();
        Set<String> set = this.interestingVariables;
        synchronized (set) {
            interestingVariables = new LinkedHashSet<String>(this.interestingVariables);
        }
        boolean bl3 = guessInterestingInformation = interestingVariableLimit != 0;
        if (guessInterestingInformation && !determineTargetLocations) {
            this.logManager.log(Level.WARNING, new Object[]{"Target states were not determined. Guessing interesting information is arbitrary."});
        }
        for (CFANode location : relevantLocations) {
            ArrayDeque<CFANode> nodes = new ArrayDeque<CFANode>();
            nodes.offer(location);
            while (!nodes.isEmpty()) {
                location = (CFANode)nodes.poll();
                for (int i = 0; i < location.getNumEnteringEdges(); ++i) {
                    CFAEdge edge = location.getEnteringEdge(i);
                    if (!relevantEdges.add(edge)) continue;
                    nodes.offer(edge.getPredecessor());
                }
            }
        }
        if (this.shutdownNotifier.shouldShutdown()) {
            return new InvariantsState(new AcceptAllVariableSelection<CompoundInterval>(), this.machineModel, this.options.abstractionStateFactory.getAbstractionState());
        }
        LinkedHashSet<String> relevantVariables = new LinkedHashSet<String>();
        boolean specifyRelevantVariables = this.options.analyzeRelevantVariablesOnly;
        if (specifyRelevantVariables) {
            InvariantsCPA.expandFixpoint(relevantVariables, (Set<CFANode>)targetLocations, -1);
            for (String variable : relevantVariables) {
                if (interestingVariables.size() >= interestingVariableLimit) break;
                interestingVariables.add(variable);
                InvariantsCPA.expandFixpoint(interestingVariables, (Set<CFANode>)targetLocations, interestingVariableLimit);
            }
            variableSelection = new AcceptSpecifiedVariableSelection(relevantVariables);
        } else {
            variableSelection = new AcceptAllVariableSelection();
        }
        Iterator interestingPredicateIterator = interestingPredicates.iterator();
        while (interestingPredicateIterator.hasNext()) {
            InvariantsFormula interestingPredicate = (InvariantsFormula)interestingPredicateIterator.next();
            ArrayList containedUninterestingVariables = new ArrayList((Collection)interestingPredicate.accept(COLLECT_VARS_VISITOR));
            containedUninterestingVariables.removeAll(interestingVariables);
            if (containedUninterestingVariables.size() > 1) continue;
            interestingPredicateIterator.remove();
        }
        this.relevantVariableLimitReached = interestingVariableLimit > interestingVariables.size();
        InvariantsPrecision precision = new InvariantsPrecision(relevantEdges, (Set<String>)ImmutableSet.copyOf(InvariantsCPA.limit(interestingVariables, interestingVariableLimit)), this.options.maximumFormulaDepth, (AbstractionStateFactory)this.options.abstractionStateFactory);
        this.initialPrecisionMap.put(pNode, precision);
        InvariantsFormula<CompoundInterval> invariant = this.invariants.get(pNode);
        if (invariant != null) {
            InvariantsState state = new InvariantsState(variableSelection, this.machineModel, this.options.abstractionStateFactory.getAbstractionState());
            state = state.assume(invariant);
        }
        return new InvariantsState(variableSelection, this.machineModel, this.options.abstractionStateFactory.getAbstractionState());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        InvariantsPrecision precision = this.initialPrecisionMap.get(pNode);
        if (precision != null) {
            return precision;
        }
        this.getInitialState(pNode, pPartition);
        precision = this.initialPrecisionMap.get(pNode);
        if (precision == null) {
            return InvariantsPrecision.getEmptyPrecision();
        }
        return precision;
    }

    public void injectInvariant(CFANode pLocation, AssumeEdge pAssumption) throws UnrecognizedCodeException {
        if (pAssumption instanceof CAssumeEdge) {
            CAssumeEdge assumeEdge = (CAssumeEdge)pAssumption;
            VariableNameExtractor vne = new VariableNameExtractor(pAssumption);
            ExpressionToFormulaVisitor etfv = new ExpressionToFormulaVisitor(vne);
            InvariantsFormula<CompoundInterval> assumption = assumeEdge.getExpression().accept(etfv);
            if (!pAssumption.getTruthAssumption()) {
                assumption = CompoundIntervalFormulaManager.INSTANCE.logicalNot(assumption);
            }
            this.injectInvariant(pLocation, assumption);
        }
    }

    public void injectInvariant(CFANode pLocation, InvariantsFormula<CompoundInterval> pAssumption) {
        this.invariants.put(pLocation, pAssumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestingVariables(Iterable<String> pInterestingVariables) {
        Set<String> set = this.interestingVariables;
        synchronized (set) {
            Iterables.addAll(this.interestingVariables, pInterestingVariables);
        }
    }

    private static <T> Iterable<T> limit(Iterable<T> pIterable, int pLimit) {
        if (pLimit >= 0) {
            return FluentIterable.from(pIterable).limit(pLimit);
        }
        return pIterable;
    }

    @Override
    public boolean adjustPrecision() {
        return this.conditionAdjuster.adjustConditions();
    }

    @Override
    public void adjustReachedSet(ReachedSet pReachedSet) {
        this.conditionAdjuster.adjustReachedSet(pReachedSet);
    }

    private static <T> boolean reachesLimit(Collection<T> pCollection, int pLimit) {
        return pLimit >= 0 && pCollection.size() >= pLimit;
    }

    private static void expandFixpoint(Set<String> pRelevantVariables, Set<CFANode> pRelevantLocations, int pLimit) {
        for (CFANode relevantLocation : pRelevantLocations) {
            InvariantsCPA.expandFixpoint(pRelevantVariables, relevantLocation, pLimit);
        }
    }

    private static void expandFixpoint(Set<String> pRelevantVariables, CFANode pRelevantLocation, int pLimit) {
        int prevSize = -1;
        while (pRelevantVariables.size() > prevSize && !InvariantsCPA.reachesLimit(pRelevantVariables, pLimit)) {
            prevSize = pRelevantVariables.size();
            InvariantsCPA.expandOnce(pRelevantVariables, pRelevantLocation, pLimit);
        }
    }

    private static void expandOnce(Set<String> pRelevantVariables, CFANode pRelevantLocation, int pLimit) {
        HashSet<CFANode> pVisitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> relevantLocations = new ArrayDeque<CFANode>();
        pVisitedNodes.add(pRelevantLocation);
        relevantLocations.offer(pRelevantLocation);
        while (!relevantLocations.isEmpty() && !InvariantsCPA.reachesLimit(pRelevantVariables, pLimit)) {
            CFANode currentRelevantLocation = (CFANode)relevantLocations.poll();
            HashSet<Pair> assumeEdgesAndPaths = new HashSet<Pair>();
            ArrayDeque<Pair> waitlist = new ArrayDeque<Pair>();
            waitlist.offer(Pair.of((Object)currentRelevantLocation, Collections.emptyList()));
            while (!waitlist.isEmpty()) {
                Pair currentPair = (Pair)waitlist.poll();
                CFANode currentNode = (CFANode)currentPair.getFirst();
                List currentPath = (List)currentPair.getSecond();
                for (CFAEdge enteringEdge : CFAUtils.enteringEdges(currentNode)) {
                    if (enteringEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                        assumeEdgesAndPaths.add(Pair.of((Object)((AssumeEdge)enteringEdge), (Object)currentPath));
                        continue;
                    }
                    if (!pVisitedNodes.add(enteringEdge.getPredecessor())) continue;
                    ArrayList<CFAEdge> newPath = new ArrayList<CFAEdge>(currentPath);
                    newPath.add(enteringEdge);
                    waitlist.offer(Pair.of((Object)enteringEdge.getPredecessor(), newPath));
                    InvariantsCPA.addTransitivelyRelevantInvolvedVariables(pRelevantVariables, enteringEdge, pLimit);
                }
            }
            for (Pair assumeEdgeAndPath : assumeEdgesAndPaths) {
                AssumeEdge assumeEdge = (AssumeEdge)assumeEdgeAndPath.getFirst();
                CFANode predecessor = assumeEdge.getPredecessor();
                if (!pVisitedNodes.add(predecessor)) continue;
                InvariantsCPA.addTransitivelyRelevantInvolvedVariables(pRelevantVariables, assumeEdge, pLimit);
                for (CFAEdge sisterEdge : CFAUtils.leavingEdges(predecessor)) {
                    CFANode brotherNode;
                    if (assumeEdge.equals(sisterEdge) || InvariantsCPA.mustReach(brotherNode = sisterEdge.getSuccessor(), currentRelevantLocation, assumeEdge) && !InvariantsCPA.anyOnPath((List)assumeEdgeAndPath.getSecond(), pRelevantVariables)) continue;
                    InvariantsCPA.addInvolvedVariables(pRelevantVariables, assumeEdge, pLimit);
                }
                relevantLocations.add(predecessor);
            }
        }
    }

    private static boolean anyOnPath(List<CFAEdge> pPath, Set<String> pRelevantVariables) {
        for (CFAEdge edge : pPath) {
            if (Collections.disjoint(InvariantsTransferRelation.INSTANCE.getInvolvedVariables(edge).keySet(), pRelevantVariables)) continue;
            return true;
        }
        return false;
    }

    private static boolean mustReach(CFANode pStart, CFANode pTarget, CFAEdge pForbiddenEdge) {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        visited.add(pStart);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(pStart);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            if (current.equals(pTarget)) continue;
            FluentIterable<CFAEdge> leavingEdges = CFAUtils.leavingEdges(current);
            boolean continued = false;
            for (CFAEdge leavingEdge : leavingEdges) {
                CFANode successor;
                if (leavingEdge.equals(pForbiddenEdge) || !(continued |= visited.add(successor = leavingEdge.getSuccessor()))) continue;
                waitlist.offer(successor);
            }
            if (continued) continue;
            return false;
        }
        return true;
    }

    private static void addTransitivelyRelevantInvolvedVariables(Set<String> pRelevantVariables, CFAEdge pEdge, int pLimit) {
        Set<String> involvedVariables = InvariantsTransferRelation.INSTANCE.getInvolvedVariables(pEdge).keySet();
        if (!Collections.disjoint(pRelevantVariables, involvedVariables)) {
            InvariantsCPA.addAll(pRelevantVariables, involvedVariables, pLimit);
        }
    }

    private static void addInvolvedVariables(Set<String> pRelevantVariables, CFAEdge pEdge, int pLimit) {
        InvariantsCPA.addAll(pRelevantVariables, InvariantsTransferRelation.INSTANCE.getInvolvedVariables(pEdge).keySet(), pLimit);
    }

    private static <T> void addAll(Collection<T> pTarget, Collection<T> pSource, int pLimit) {
        Iterator<T> elementIterator = pSource.iterator();
        while (!InvariantsCPA.reachesLimit(pTarget, pLimit) && elementIterator.hasNext()) {
            pTarget.add(elementIterator.next());
        }
    }

    private static class AbstractionStrategyAdjuster
    implements ConditionAdjuster {
        private final InvariantsCPA cpa;

        public AbstractionStrategyAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public boolean adjustConditions() {
            if (this.cpa.options.abstractionStateFactory == AbstractionStateFactories.ALWAYS) {
                this.cpa.options.abstractionStateFactory = AbstractionStateFactories.ENTERING_EDGES;
            } else if (this.cpa.options.abstractionStateFactory == AbstractionStateFactories.ENTERING_EDGES) {
                this.cpa.options.abstractionStateFactory = AbstractionStateFactories.NEVER;
            } else {
                return false;
            }
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting abstraction strategy to", this.cpa.options.abstractionStateFactory});
            return true;
        }

        @Override
        public void adjustReachedSet(ReachedSet pReachedSet) {
            pReachedSet.clear();
        }
    }

    private static class FormulaDepthAdjuster
    implements ValueIncreasingAdjuster {
        private final InvariantsCPA cpa;
        private int inc = 1;

        private FormulaDepthAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public boolean adjustConditions() {
            if (this.cpa.options.maximumFormulaDepth >= 2) {
                return false;
            }
            this.cpa.initialPrecisionMap.clear();
            this.cpa.options.maximumFormulaDepth += this.inc;
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting maximum formula depth to", this.cpa.options.maximumFormulaDepth});
            return true;
        }

        @Override
        public void adjustReachedSet(ReachedSet pReachedSet) {
            pReachedSet.clear();
        }

        @Override
        public int getInc() {
            return this.inc;
        }

        @Override
        public void setInc(int pInc) {
            Preconditions.checkArgument((pInc > 0 ? 1 : 0) != 0);
            this.inc = pInc;
        }
    }

    private static class InterestingVariableLimitAdjuster
    implements ValueIncreasingAdjuster {
        private final InvariantsCPA cpa;
        private int inc = 1;

        private InterestingVariableLimitAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public boolean adjustConditions() {
            if (this.cpa.relevantVariableLimitReached) {
                return false;
            }
            this.cpa.initialPrecisionMap.clear();
            this.cpa.options.interestingVariableLimit += this.inc;
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting interestingVariableLimit to", this.cpa.options.interestingVariableLimit});
            return true;
        }

        @Override
        public void adjustReachedSet(ReachedSet pReachedSet) {
            pReachedSet.clear();
        }

        @Override
        public int getInc() {
            return this.inc;
        }

        @Override
        public void setInc(int pInc) {
            Preconditions.checkArgument((pInc > 0 ? 1 : 0) != 0);
            this.inc = pInc;
        }
    }

    private static class CompoundConditionAdjuster
    implements ConditionAdjuster {
        private Timer timer = new Timer();
        private TimeSpan previousTimeSpan = null;
        private Deque<ValueIncreasingAdjuster> innerAdjusters = new ArrayDeque<ValueIncreasingAdjuster>();
        private ConditionAdjuster defaultInner;

        public CompoundConditionAdjuster(InvariantsCPA pCPA) {
            this.innerAdjusters.add(new InterestingVariableLimitAdjuster(pCPA));
            this.innerAdjusters.add(new FormulaDepthAdjuster(pCPA));
            this.defaultInner = new AbstractionStrategyAdjuster(pCPA);
        }

        @Override
        public boolean adjustConditions() {
            if (!this.hasInner()) {
                return this.defaultInner.adjustConditions();
            }
            ValueIncreasingAdjuster inner = this.getCurrentInner();
            if (this.previousTimeSpan != null) {
                this.timer.stop();
                TimeSpan sinceLastAdjustment = this.timer.getLengthOfLastInterval();
                int comp = sinceLastAdjustment.compareTo(this.previousTimeSpan);
                int inc = inner.getInc();
                if (comp < 0) {
                    inc *= 2;
                } else if (comp > 0 && inc > 1) {
                    inc /= 2;
                    this.swapInner();
                }
                inner.setInc(inc);
                this.previousTimeSpan = sinceLastAdjustment;
            } else if (this.timer.isRunning()) {
                this.timer.stop();
                this.previousTimeSpan = this.timer.getLengthOfLastInterval();
            }
            this.timer.start();
            boolean result = inner.adjustConditions();
            if (!result) {
                this.innerAdjusters.remove(inner);
                return this.adjustConditions();
            }
            return result;
        }

        @Override
        public void adjustReachedSet(ReachedSet pReachedSet) {
            if (this.hasInner()) {
                this.getCurrentInner().adjustReachedSet(pReachedSet);
            } else {
                this.defaultInner.adjustReachedSet(pReachedSet);
            }
        }

        private boolean hasInner() {
            return !this.innerAdjusters.isEmpty();
        }

        private ValueIncreasingAdjuster getCurrentInner() {
            Preconditions.checkArgument((boolean)this.hasInner());
            return this.innerAdjusters.getFirst();
        }

        private void swapInner() {
            if (this.hasInner()) {
                this.innerAdjusters.addLast(this.innerAdjusters.removeFirst());
            }
        }
    }

    public static enum ConditionAdjusterFactories implements ConditionAdjusterFactory
    {
        STATIC{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new ConditionAdjuster(){

                    @Override
                    public boolean adjustConditions() {
                        return false;
                    }

                    @Override
                    public void adjustReachedSet(ReachedSet pReachedSet) {
                    }
                };
            }
        }
        ,
        INTERESTING_VARIABLES{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new InterestingVariableLimitAdjuster(pCPA);
            }
        }
        ,
        MAXIMUM_FORMULA_DEPTH{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new FormulaDepthAdjuster(pCPA);
            }
        }
        ,
        ABSTRACTION_STRATEGY{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new AbstractionStrategyAdjuster(pCPA);
            }
        }
        ,
        COMPOUND{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new CompoundConditionAdjuster(pCPA);
            }
        };

    }

    public static interface ConditionAdjusterFactory {
        public ConditionAdjuster createConditionAdjuster(InvariantsCPA var1);
    }

    private static interface ValueIncreasingAdjuster
    extends ConditionAdjuster {
        public int getInc();

        public void setInc(int var1);
    }

    public static interface ConditionAdjuster {
        public boolean adjustConditions();

        public void adjustReachedSet(ReachedSet var1);
    }

    @Options(prefix="cpa.invariants")
    public static class InvariantsOptions {
        @Option(secure=true, values={"JOIN", "SEP", "PRECISIONDEPENDENT"}, toUppercase=true, description="which merge operator to use for InvariantCPA")
        private String merge = "PRECISIONDEPENDENT";
        @Option(secure=true, description="determine target locations in advance and analyse paths to the target locations only.")
        private boolean analyzeTargetPathsOnly = true;
        @Option(secure=true, description="determine variables relevant to the decision whether or not a target path assume edge is taken and limit the analyis to those variables.")
        private boolean analyzeRelevantVariablesOnly = true;
        @Option(secure=true, description="the maximum number of variables to consider as interesting. -1 one disables the limit, but this is not recommended. 0 means that guessing interesting variables is disabled.")
        private volatile int interestingVariableLimit = 2;
        @Option(secure=true, description="the maximum tree depth of a formula recorded in the environment.")
        private int maximumFormulaDepth = 4;
        @Option(secure=true, description="controls whether to use abstract evaluation always, never, or depending on entering edges.")
        private AbstractionStateFactories abstractionStateFactory = AbstractionStateFactories.ENTERING_EDGES;
        @Option(secure=true, description="controls the condition adjustment logic: STATIC means that condition adjustment is a no-op, INTERESTING_VARIABLES increases the interesting variable limit, MAXIMUM_FORMULA_DEPTH increases the maximum formula depth, ABSTRACTION_STRATEGY tries to choose a more precise abstraction strategy and COMPOUND combines the other strategies (minus STATIC).")
        private ConditionAdjusterFactories conditionAdjusterFactory = ConditionAdjusterFactories.COMPOUND;
    }
}

