/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class InvariantsMergeOperator
implements MergeOperator {
    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        Sets.SetView wideningHints;
        AbstractionState abstractionState2;
        InvariantsState state1 = (InvariantsState)pState1;
        InvariantsState state2 = (InvariantsState)pState2;
        InvariantsPrecision precision = (InvariantsPrecision)pPrecision;
        boolean isMergeAllowed = InvariantsMergeOperator.isMergeAllowed(state1, state2, precision);
        AbstractionState abstractionState1 = state1.determineAbstractionState(precision);
        Set<String> wideningTargets = abstractionState1.determineWideningTargets(abstractionState2 = state2.determineAbstractionState(precision));
        if ((state1 = state1.widen(state2, precision, wideningTargets, (Set<InvariantsFormula<CompoundInterval>>)(wideningHints = Sets.union(abstractionState1.getWideningHints(), abstractionState2.getWideningHints())))) != pState1 && InvariantsMergeOperator.definitelyImplies(state2, InvariantsMergeOperator.reduceToGivenVariables(InvariantsMergeOperator.reduceToInterestingVariables(state1, precision), (Iterable<? extends String>)Sets.difference(state1.getEnvironment().keySet(), wideningTargets)))) {
            isMergeAllowed = true;
        }
        InvariantsState result = state2;
        if (isMergeAllowed) {
            result = state1.join(state2, precision);
        }
        return result;
    }

    private static boolean isMergeAllowed(InvariantsState pState1, InvariantsState pState2, InvariantsPrecision pPrecision) {
        return InvariantsMergeOperator.environmentsEqualWithRespectToInterestingVariables(pState1, pState2, pPrecision) || InvariantsMergeOperator.definitelyImplies(pState2, InvariantsMergeOperator.reduceToInterestingVariables(pState1, pPrecision));
    }

    private static boolean definitelyImplies(InvariantsState pState1, InvariantsState pState2) {
        for (InvariantsFormula<CompoundInterval> assumption : pState2.getEnvironmentAsAssumptions()) {
            if (pState1.definitelyImplies(assumption)) continue;
            return false;
        }
        return true;
    }

    private static InvariantsState reduceToInterestingVariables(InvariantsState pState, InvariantsPrecision pPrecision) {
        return InvariantsMergeOperator.reduceToGivenVariables(pState, pPrecision.getInterestingVariables());
    }

    private static InvariantsState reduceToGivenVariables(InvariantsState pState, Iterable<? extends String> pVariables) {
        InvariantsState result = pState;
        for (String variableName : pState.getEnvironment().keySet()) {
            if (Iterables.contains(pVariables, (Object)variableName)) continue;
            result = result.clear(variableName);
        }
        return result;
    }

    private static boolean environmentsEqualWithRespectToInterestingVariables(InvariantsState pState1, InvariantsState pState2, InvariantsPrecision pPrecision) {
        HashSet<String> checkedVariables = new HashSet<String>();
        ArrayDeque<String> waitlist = new ArrayDeque<String>(pPrecision.getInterestingVariables());
        Map<String, InvariantsFormula<CompoundInterval>> environment1 = pState1.getEnvironment();
        Map<String, InvariantsFormula<CompoundInterval>> environment2 = pState2.getEnvironment();
        CollectVarsVisitor collectVarsVisitor = new CollectVarsVisitor();
        while (!waitlist.isEmpty()) {
            InvariantsFormula<CompoundInterval> right;
            String variableName = (String)waitlist.poll();
            if (!checkedVariables.add(variableName)) continue;
            InvariantsFormula<CompoundInterval> left = environment1.get(variableName);
            if (!(left == (right = environment2.get(variableName)) || left != null && left.equals(right))) {
                return false;
            }
            if (left == null) continue;
            waitlist.addAll((Collection)left.accept(collectVarsVisitor));
        }
        return true;
    }
}

