/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStateFactories;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStateFactory;

public class InvariantsPrecision
implements Precision {
    private final ImmutableSet<CFAEdge> relevantEdges;
    private final ImmutableSet<String> interestingVariables;
    private final int maximumFormulaDepth;
    private final AbstractionStateFactory abstractionStateFactory;

    public static InvariantsPrecision getEmptyPrecision() {
        return new InvariantsPrecision(Collections.emptySet(), Collections.emptySet(), 0, (AbstractionStateFactory)AbstractionStateFactories.ALWAYS){

            @Override
            public boolean isRelevant(CFAEdge pEdge) {
                return true;
            }

            @Override
            public String toString() {
                return "no precision";
            }
        };
    }

    public InvariantsPrecision(Set<CFAEdge> pRelevantEdges, Set<String> pInterestingVariables, int pMaximumFormulaDepth, AbstractionStateFactory pAbstractionStateFactory) {
        this(InvariantsPrecision.asImmutableRelevantEdges(pRelevantEdges), (ImmutableSet<String>)ImmutableSet.copyOf(pInterestingVariables), pMaximumFormulaDepth, pAbstractionStateFactory);
    }

    public InvariantsPrecision(ImmutableSet<CFAEdge> pRelevantEdges, ImmutableSet<String> pInterestingVariables, int pMaximumFormulaDepth, AbstractionStateFactory pAbstractionStateFactory) {
        this.relevantEdges = pRelevantEdges;
        this.interestingVariables = pInterestingVariables;
        this.maximumFormulaDepth = pMaximumFormulaDepth;
        this.abstractionStateFactory = pAbstractionStateFactory;
    }

    public boolean isRelevant(CFAEdge pEdge) {
        if (pEdge instanceof MultiEdge) {
            MultiEdge multiEdge = (MultiEdge)pEdge;
            return FluentIterable.from((Iterable)multiEdge).anyMatch((Predicate)new Predicate<CFAEdge>(){

                public boolean apply(@Nullable CFAEdge pArg0) {
                    return InvariantsPrecision.this.isRelevant(pArg0);
                }
            });
        }
        return pEdge != null && (this.relevantEdges == null || this.relevantEdges.contains((Object)pEdge));
    }

    public Set<String> getInterestingVariables() {
        return this.interestingVariables;
    }

    public String toString() {
        return String.format("Number of relevant edges: %d; Interesting variables: %s;", this.relevantEdges.size(), this.interestingVariables);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof InvariantsPrecision) {
            InvariantsPrecision other = (InvariantsPrecision)pOther;
            return this.relevantEdges.equals(other.relevantEdges) && this.interestingVariables.equals(other.interestingVariables) && this.maximumFormulaDepth == other.maximumFormulaDepth;
        }
        return false;
    }

    public int hashCode() {
        return this.interestingVariables.hashCode();
    }

    public int getMaximumFormulaDepth() {
        return this.maximumFormulaDepth;
    }

    public AbstractionStateFactory getAbstractionStateFactory() {
        return this.abstractionStateFactory;
    }

    private static ImmutableSet<CFAEdge> asImmutableRelevantEdges(Set<CFAEdge> pRelevantEdges) {
        if (pRelevantEdges == null) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayDeque<CFAEdge> waitlist = new ArrayDeque<CFAEdge>(pRelevantEdges);
        while (!waitlist.isEmpty()) {
            CFAEdge relevantEdge = (CFAEdge)waitlist.poll();
            builder.add((Object)relevantEdge);
            if (relevantEdge.getEdgeType() != CFAEdgeType.MultiEdge) continue;
            builder.addAll((Iterable)((MultiEdge)relevantEdge));
        }
        return builder.build();
    }
}

