/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsVarVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaAbstractionVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaDepthCountVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushAssumptionToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ReplaceVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitConjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.StateEqualsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelection;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class InvariantsState
implements AbstractState,
FormulaReportingState,
LatticeAbstractState<InvariantsState> {
    private static final FormulaDepthCountVisitor<CompoundInterval> FORMULA_DEPTH_COUNT_VISITOR = new FormulaDepthCountVisitor();
    private static final SplitConjunctionsVisitor<CompoundInterval> SPLIT_CONJUNCTIONS_VISITOR = new SplitConjunctionsVisitor();
    public static final FormulaEvaluationVisitor<CompoundInterval> EVALUATION_VISITOR = new FormulaCompoundStateEvaluationVisitor();
    public static final FormulaEvaluationVisitor<CompoundInterval> ABSTRACTION_VISITOR = new FormulaAbstractionVisitor();
    private static final InvariantsFormula<CompoundInterval> TOP = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
    private static final InvariantsFormula<CompoundInterval> BOTTOM = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.bottom());
    private static final Predicate<? super String> IS_UNSUPPORTED_VARIABLE = new Predicate<String>(){

        public boolean apply(String pArg0) {
            return pArg0 == null || pArg0.contains("[");
        }
    };
    private final Predicate<InvariantsFormula<CompoundInterval>> implies = new Predicate<InvariantsFormula<CompoundInterval>>(){

        public boolean apply(InvariantsFormula<CompoundInterval> pArg0) {
            return InvariantsState.this.definitelyImplies(pArg0);
        }
    };
    private final NonRecursiveEnvironment environment;
    private final VariableSelection<CompoundInterval> variableSelection;
    private final PersistentSortedMap<String, CType> variableTypes;
    private final PartialEvaluator partialEvaluator;
    private final MachineModel machineModel;
    private final AbstractionState abstractionState;
    private Iterable<InvariantsFormula<CompoundInterval>> environmentAsAssumptions;
    private volatile int hash = 0;

    public InvariantsState(VariableSelection<CompoundInterval> pVariableSelection, MachineModel pMachineModel, InvariantsState pInvariant, AbstractionState pAbstractionState) {
        this.environment = pInvariant.environment;
        this.partialEvaluator = pInvariant.partialEvaluator;
        this.variableSelection = pVariableSelection;
        this.variableTypes = pInvariant.variableTypes;
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
    }

    public InvariantsState(VariableSelection<CompoundInterval> pVariableSelection, MachineModel pMachineModel, AbstractionState pAbstractionState) {
        this.environment = NonRecursiveEnvironment.of();
        this.partialEvaluator = new PartialEvaluator(this.environment);
        this.variableSelection = pVariableSelection;
        this.variableTypes = PathCopyingPersistentTreeMap.of();
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
    }

    private InvariantsState(VariableSelection<CompoundInterval> pVariableSelection, MachineModel pMachineModel, AbstractionState pAbstractionState, NonRecursiveEnvironment pEnvironment, PersistentSortedMap<String, CType> pVariableTypes) {
        this.environment = pEnvironment;
        this.partialEvaluator = new PartialEvaluator(this.environment);
        this.variableSelection = pVariableSelection;
        this.variableTypes = pVariableTypes;
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
    }

    private InvariantsState(Map<String, InvariantsFormula<CompoundInterval>> pEnvironment, VariableSelection<CompoundInterval> pVariableSelection, MachineModel pMachineModel, PersistentSortedMap<String, CType> pVariableTypes, AbstractionState pAbstractionState) {
        this.environment = NonRecursiveEnvironment.copyOf(pEnvironment);
        this.partialEvaluator = new PartialEvaluator(pEnvironment);
        this.variableSelection = pVariableSelection;
        this.variableTypes = pVariableTypes;
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
    }

    private AbstractionState determineAbstractionState(AbstractionState pMasterState) {
        AbstractionState state = pMasterState;
        if (state.getClass() == this.abstractionState.getClass()) {
            state = this.abstractionState.join(state);
        }
        return state;
    }

    public AbstractionState determineAbstractionState(InvariantsPrecision pPrecision) {
        return this.determineAbstractionState(pPrecision.getAbstractionStateFactory().from(this.abstractionState));
    }

    public InvariantsState updateAbstractionState(InvariantsPrecision pPrecision, CFAEdge pEdge) {
        AbstractionState state = pPrecision.getAbstractionStateFactory().getSuccessorState(this.abstractionState);
        if ((state = state.addEnteringEdge(pEdge)).equals(this.abstractionState)) {
            return this;
        }
        return new InvariantsState(this.environment, this.variableSelection, this.machineModel, this.variableTypes, state);
    }

    public InvariantsState setType(String pVarName, CType pType) {
        if (pType.equals(this.variableTypes.get((Object)pVarName))) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.machineModel, this.abstractionState, this.environment, (PersistentSortedMap<String, CType>)this.variableTypes.putAndCopy((Object)pVarName, (Object)pType));
    }

    public InvariantsState setTypes(Map<String, CType> pVarTypes) {
        boolean allContained = true;
        for (Map.Entry<String, CType> entry : pVarTypes.entrySet()) {
            if (entry.getValue().equals(this.variableTypes.get((Object)entry.getKey()))) continue;
            allContained = false;
            break;
        }
        if (allContained) {
            return this;
        }
        PersistentSortedMap variableTypes = this.variableTypes;
        for (Map.Entry<String, CType> entry : pVarTypes.entrySet()) {
            String variableName = entry.getKey();
            if (variableTypes.containsKey((Object)variableName)) continue;
            variableTypes = variableTypes.putAndCopy((Object)variableName, (Object)entry.getValue());
        }
        return new InvariantsState(this.variableSelection, this.machineModel, this.abstractionState, this.environment, variableTypes);
    }

    public InvariantsState assignArray(String pArray, InvariantsFormula<CompoundInterval> pSubscript, InvariantsFormula<CompoundInterval> pValue) {
        FormulaEvaluationVisitor<CompoundInterval> fev = this.getFormulaResolver();
        CompoundInterval value = (CompoundInterval)pSubscript.accept(fev, this.environment);
        if (value.isSingleton()) {
            return this.assignInternal(pArray + "[" + value.getValue() + "]", pValue);
        }
        InvariantsState result = this;
        for (String varName : this.environment.keySet()) {
            String subscriptValueStr;
            String prefix;
            if (!varName.startsWith(prefix = pArray + "[") || !(subscriptValueStr = varName.replace(prefix, "").replaceAll("].*", "")).equals("*") && !value.contains(new BigInteger(subscriptValueStr))) continue;
            result = result.assignInternal(varName, TOP);
        }
        return result;
    }

    public InvariantsState assign(String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        InvariantsState result = this;
        for (Map.Entry entry : this.environment.entrySet()) {
            String varName = (String)entry.getKey();
            if (!varName.startsWith(pVarName + "->") && !varName.startsWith(pVarName + ".")) continue;
            result = result.assign(varName, TOP);
        }
        if (pValue instanceof Variable) {
            String valueVarName = ((Variable)pValue).getName();
            if (valueVarName.startsWith(pVarName + "->") || valueVarName.startsWith(pVarName + ".")) {
                return this.assign(pVarName, TOP);
            }
            String pointerDerefPrefix = valueVarName + "->";
            String nonPointerDerefPrefix = valueVarName + ".";
            for (Map.Entry entry : this.environment.entrySet()) {
                String suffix;
                if (((String)entry.getKey()).startsWith(pointerDerefPrefix)) {
                    suffix = ((String)entry.getKey()).substring(pointerDerefPrefix.length());
                    result = result.assign(pVarName + "->" + suffix, CompoundIntervalFormulaManager.INSTANCE.asVariable((String)entry.getKey()));
                    continue;
                }
                if (!((String)entry.getKey()).startsWith(nonPointerDerefPrefix)) continue;
                suffix = ((String)entry.getKey()).substring(nonPointerDerefPrefix.length());
                result = result.assign(pVarName + "." + suffix, CompoundIntervalFormulaManager.INSTANCE.asVariable((String)entry.getKey()));
            }
            return result.assignInternal(pVarName, pValue);
        }
        return result.assignInternal(pVarName, pValue);
    }

    private InvariantsState assignInternal(String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        InvariantsFormula<CompoundInterval> previousValue;
        ReplaceVisitor<CompoundInterval> replaceVisitor;
        InvariantsState result;
        Preconditions.checkNotNull(pValue);
        if (IS_UNSUPPORTED_VARIABLE.apply((Object)pVarName)) {
            return this;
        }
        if (FluentIterable.from((Iterable)((Iterable)pValue.accept(new CollectVarsVisitor()))).anyMatch(IS_UNSUPPORTED_VARIABLE)) {
            return this;
        }
        VariableSelection<CompoundInterval> newVariableSelection = this.variableSelection.acceptAssignment(pVarName, pValue);
        if (newVariableSelection == null) {
            NonRecursiveEnvironment newEnvironment = this.environment;
            if (this.environment.containsKey(pVarName)) {
                newEnvironment = newEnvironment.removeAndCopy(pVarName);
            }
            if (this.environment == newEnvironment) {
                return this;
            }
            return new InvariantsState(newEnvironment, this.variableSelection, this.machineModel, this.variableTypes, this.abstractionState);
        }
        CompoundIntervalFormulaManager ifm = CompoundIntervalFormulaManager.INSTANCE;
        Variable<CompoundInterval> variable = ifm.asVariable(pVarName);
        ContainsVarVisitor containsVarVisitor = new ContainsVarVisitor();
        if (this.getEnvironmentValue(pVarName).equals(pValue) && (pValue instanceof Variable || pValue instanceof Constant && ((CompoundInterval)((Constant)((Object)pValue)).getValue()).isSingleton()) || variable.accept(new StateEqualsVisitor(this.getFormulaResolver(), this.environment), pValue).booleanValue()) {
            return this;
        }
        if (((Boolean)pValue.accept(containsVarVisitor, pVarName)).booleanValue()) {
            CompoundInterval value;
            Variable<CompoundInterval> varValue = this.environment.get(pVarName);
            boolean isVarValueConstant = varValue instanceof Constant && ((CompoundInterval)((Constant)((Object)varValue)).getValue()).isSingleton();
            Variable<CompoundInterval> alternative = varValue;
            if (!(alternative instanceof Variable)) {
                alternative = null;
                for (Map.Entry entry : this.environment.entrySet()) {
                    InvariantsFormula value2 = (InvariantsFormula)entry.getValue();
                    if (((String)entry.getKey()).equals(pVarName) || !value2.equals(variable) && (!isVarValueConstant || !value2.equals(varValue))) continue;
                    alternative = CompoundIntervalFormulaManager.INSTANCE.asVariable((String)entry.getKey());
                    break;
                }
            }
            if (alternative != null) {
                pValue = (Variable<CompoundInterval>)pValue.accept(new ReplaceVisitor<CompoundInterval>(variable, alternative));
            }
            if ((value = (CompoundInterval)pValue.accept(EVALUATION_VISITOR, this.environment)).isSingleton()) {
                for (Map.Entry entry : this.environment.entrySet()) {
                    InvariantsFormula v = (InvariantsFormula)entry.getValue();
                    if (!(v instanceof Constant) || !value.equals(((Constant)v).getValue())) continue;
                    pValue = CompoundIntervalFormulaManager.INSTANCE.asVariable((String)entry.getKey());
                    break;
                }
            }
        }
        if (this.equals(result = this.assignInternal(pVarName, pValue, newVariableSelection, EVALUATION_VISITOR, replaceVisitor = new ReplaceVisitor<CompoundInterval>(variable, previousValue = this.getEnvironmentValue(pVarName))))) {
            return this;
        }
        return result;
    }

    private InvariantsState assignInternal(String pVarName, InvariantsFormula<CompoundInterval> pValue, VariableSelection<CompoundInterval> newVariableSelection, FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor, ReplaceVisitor<CompoundInterval> replaceVisitor) {
        NonRecursiveEnvironment resultEnvironment = this.environment;
        for (Map.Entry environmentEntry : this.environment.entrySet()) {
            if (((String)environmentEntry.getKey()).equals(pVarName)) continue;
            InvariantsFormula<CompoundInterval> newEnvValue = ((InvariantsFormula)((InvariantsFormula)environmentEntry.getValue()).accept(replaceVisitor)).accept(this.partialEvaluator, EVALUATION_VISITOR);
            resultEnvironment = resultEnvironment.putAndCopy((String)environmentEntry.getKey(), newEnvValue);
        }
        resultEnvironment = resultEnvironment.putAndCopy(pVarName, ((InvariantsFormula)pValue.accept(replaceVisitor)).accept(this.partialEvaluator, EVALUATION_VISITOR));
        return new InvariantsState(newVariableSelection, this.machineModel, this.abstractionState, resultEnvironment, this.variableTypes);
    }

    public InvariantsState clear() {
        if (this.environment.isEmpty()) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.machineModel, this.abstractionState);
    }

    public InvariantsState clear(String pVariableName) {
        if (this.environment.get(pVariableName) == null) {
            return this;
        }
        return new InvariantsState(this.environment.removeAndCopy(pVariableName), this.variableSelection, this.machineModel, this.variableTypes, this.abstractionState);
    }

    public Iterable<InvariantsFormula<CompoundInterval>> getEnvironmentAsAssumptions() {
        if (this.environmentAsAssumptions == null) {
            this.environmentAsAssumptions = InvariantsState.getEnvironmentAsAssumptions(this.environment);
        }
        return this.environmentAsAssumptions;
    }

    private static Iterable<InvariantsFormula<CompoundInterval>> getEnvironmentAsAssumptions(Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        HashSet<InvariantsFormula<CompoundInterval>> environmentalAssumptions = new HashSet<InvariantsFormula<CompoundInterval>>();
        CompoundIntervalFormulaManager ifm = CompoundIntervalFormulaManager.INSTANCE;
        ArrayList<InvariantsFormula> atomic = new ArrayList<InvariantsFormula>(1);
        ArrayDeque toCheck = new ArrayDeque(1);
        for (Map.Entry<? extends String, ? extends InvariantsFormula<CompoundInterval>> entry : pEnvironment.entrySet()) {
            Variable<CompoundInterval> variable = ifm.asVariable(entry.getKey());
            InvariantsFormula<CompoundInterval> value = entry.getValue();
            boolean isExclusion = false;
            if (value instanceof Exclusion) {
                isExclusion = true;
                value = ((Exclusion)value).getExcluded();
            }
            atomic.clear();
            toCheck.clear();
            toCheck.add(value);
            while (!toCheck.isEmpty()) {
                InvariantsFormula current = (InvariantsFormula)toCheck.poll();
                if (current instanceof Union) {
                    Union union = (Union)current;
                    toCheck.add(union.getOperand1());
                    toCheck.add(union.getOperand2());
                    continue;
                }
                atomic.add(current);
            }
            assert (!atomic.isEmpty());
            Iterator iterator = atomic.iterator();
            InvariantsFormula<CompoundInterval> assumption = ifm.asConstant(CompoundInterval.logicalFalse());
            while (iterator.hasNext()) {
                InvariantsFormula<CompoundInterval> equation = ifm.equal(variable, (InvariantsFormula)iterator.next());
                if (isExclusion) {
                    equation = ifm.logicalNot(equation);
                }
                assumption = ifm.logicalOr(assumption, equation);
            }
            environmentalAssumptions.add(assumption);
        }
        return environmentalAssumptions;
    }

    private InvariantsFormula<CompoundInterval> getEnvironmentValue(String pVarName) {
        Object environmentValue = this.environment.get(pVarName);
        if (environmentValue == null) {
            return TOP;
        }
        return environmentValue;
    }

    public FormulaEvaluationVisitor<CompoundInterval> getFormulaResolver() {
        return EVALUATION_VISITOR;
    }

    private InvariantsState assumeInternal(Collection<? extends InvariantsFormula<CompoundInterval>> pAssumptions, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, VariableSelection<CompoundInterval> pNewVariableSelection) {
        InvariantsState result = this;
        for (InvariantsFormula<CompoundInterval> invariantsFormula : pAssumptions) {
            result = this.assumeInternal(invariantsFormula, pEvaluationVisitor, pNewVariableSelection);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    private InvariantsState assumeInternal(InvariantsFormula<CompoundInterval> pAssumption, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, VariableSelection<CompoundInterval> pNewVariableSelection) {
        InvariantsFormula<CompoundInterval> assumption = pAssumption.accept(this.partialEvaluator, pEvaluationVisitor);
        List assumptionParts = (List)assumption.accept(SPLIT_CONJUNCTIONS_VISITOR);
        if (assumptionParts.size() > 1) {
            return this.assumeInternal(assumptionParts, pEvaluationVisitor, pNewVariableSelection);
        }
        if (assumption.equals(TOP)) {
            return this;
        }
        if (FluentIterable.from((Iterable)((Iterable)assumption.accept(new CollectVarsVisitor()))).anyMatch(IS_UNSUPPORTED_VARIABLE)) {
            return this;
        }
        if (assumption instanceof Constant) {
            return !((CompoundInterval)((Constant)assumption).getValue()).isDefinitelyFalse() ? this : null;
        }
        if (assumption.equals(BOTTOM)) {
            return null;
        }
        CompoundInterval assumptionEvaluation = (CompoundInterval)assumption.accept(pEvaluationVisitor, this.getEnvironment());
        if (assumptionEvaluation.isDefinitelyFalse() || assumptionEvaluation.isBottom()) {
            return null;
        }
        if (assumptionEvaluation.isDefinitelyTrue()) {
            return this;
        }
        NonRecursiveEnvironment.Builder environmentBuilder = new NonRecursiveEnvironment.Builder(this.environment);
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(pEvaluationVisitor, environmentBuilder);
        if (!assumption.accept(patev, CompoundInterval.logicalTrue()).booleanValue()) {
            assert (!assumptionEvaluation.isDefinitelyTrue());
            return null;
        }
        if (this.isDefinitelyFalse(assumption, pEvaluationVisitor)) {
            return null;
        }
        return new InvariantsState(environmentBuilder.build(), pNewVariableSelection, this.machineModel, this.variableTypes, this.abstractionState);
    }

    private boolean isDefinitelyFalse(InvariantsFormula<CompoundInterval> pAssumption, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return ((CompoundInterval)pAssumption.accept(pEvaluationVisitor, this.getEnvironment())).isDefinitelyFalse();
    }

    public InvariantsState assume(InvariantsFormula<CompoundInterval> pAssumption) {
        VariableSelection<CompoundInterval> newVariableSelection = this.variableSelection.acceptAssumption(pAssumption);
        if (newVariableSelection == null) {
            return this;
        }
        FormulaEvaluationVisitor<CompoundInterval> evaluator = this.getFormulaResolver();
        InvariantsFormula<CompoundInterval> assumption = pAssumption.accept(this.partialEvaluator, evaluator);
        if (assumption instanceof Constant) {
            CompoundInterval value = (CompoundInterval)((Constant)assumption).getValue();
            if (value.isDefinitelyFalse()) {
                return null;
            }
            return this;
        }
        InvariantsState result = this.assumeInternal(assumption, evaluator, newVariableSelection);
        if (this.equalsState(result)) {
            return this;
        }
        return result;
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
        FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor = this.getFormulaResolver();
        BooleanFormulaManagerView bfmgr = pManager.getBooleanFormulaManager();
        BooleanFormula result = bfmgr.makeBoolean(true);
        ToFormulaVisitor<CompoundInterval, BooleanFormula> toBooleanFormulaVisitor = ToBooleanFormulaVisitor.getVisitor(pManager, evaluationVisitor, true, this.machineModel, this.variableTypes);
        Predicate<String> acceptVariable = new Predicate<String>(){

            public boolean apply(@Nullable String pInput) {
                return pInput != null && !pInput.contains("*");
            }
        };
        Predicate<InvariantsFormula<CompoundInterval>> acceptFormula = new Predicate<InvariantsFormula<CompoundInterval>>((Predicate)acceptVariable){
            final /* synthetic */ Predicate val$acceptVariable;
            {
                this.val$acceptVariable = predicate;
            }

            public boolean apply(@Nullable InvariantsFormula<CompoundInterval> pInput) {
                return pInput != null && !pInput.equals(TOP) && FluentIterable.from(CompoundIntervalFormulaManager.collectVariableNames(pInput)).allMatch(this.val$acceptVariable);
            }
        };
        for (InvariantsFormula<CompoundInterval> assumption : this.getEnvironmentAsAssumptions()) {
            BooleanFormula assumptionFormula;
            if (!acceptFormula.apply(assumption) || (assumptionFormula = (BooleanFormula)assumption.accept(toBooleanFormulaVisitor, this.getEnvironment())) == null) continue;
            result = bfmgr.and(result, assumptionFormula);
        }
        return result;
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof InvariantsState)) {
            return false;
        }
        return this.equalsState((InvariantsState)pObj);
    }

    private boolean equalsState(InvariantsState pOther) {
        return pOther != null && this.environment.equals(pOther.environment) && this.abstractionState.equals(pOther.abstractionState);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = 17;
            result = 31 * result + this.environment.hashCode();
            this.hash = result = 31 * result + this.abstractionState.hashCode();
        }
        return result;
    }

    public String toString() {
        return FluentIterable.from((Iterable)this.environment.entrySet()).transform((Function)new Function<Map.Entry<String, InvariantsFormula<CompoundInterval>>, String>(){

            public String apply(Map.Entry<String, InvariantsFormula<CompoundInterval>> pInput) {
                String variableName = pInput.getKey();
                InvariantsFormula<CompoundInterval> value = pInput.getValue();
                if (value instanceof Exclusion) {
                    return String.format("%s\u2260%s", variableName, ((Exclusion)value).getExcluded());
                }
                return String.format("%s=%s", variableName, value);
            }
        }).join(Joiner.on((String)", "));
    }

    public AbstractionState getAbstractionState() {
        return this.abstractionState;
    }

    public Map<String, InvariantsFormula<CompoundInterval>> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isLessOrEqual(InvariantsState pState2) {
        if (this.equals(pState2)) {
            return true;
        }
        if (pState2 == null) {
            return false;
        }
        if (!this.abstractionState.isLessThanOrEqualTo(pState2.abstractionState)) {
            return false;
        }
        for (InvariantsFormula<CompoundInterval> rightAssumption : pState2.getEnvironmentAsAssumptions()) {
            if (this.definitelyImplies(rightAssumption)) continue;
            return false;
        }
        return true;
    }

    public boolean definitelyImplies(InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.definitelyImplies(this.environment, pFormula);
    }

    public InvariantsState widen(InvariantsState pOlderState, @Nullable InvariantsPrecision pPrecision, Set<String> pWideningTargets, Set<InvariantsFormula<CompoundInterval>> pWideningHints) {
        Set wideningTargets;
        Set set = wideningTargets = pWideningTargets == null ? this.environment.keySet() : pWideningTargets;
        if (wideningTargets.isEmpty()) {
            return this;
        }
        NonRecursiveEnvironment resultEnvironment = this.environment;
        HashMap<String, InvariantsFormula<CompoundInterval>> toDo = new HashMap<String, InvariantsFormula<CompoundInterval>>();
        for (String string : wideningTargets) {
            InvariantsFormula<CompoundInterval> currentFormula = this.getEnvironmentValue(string);
            InvariantsFormula<CompoundInterval> oldFormula = pOlderState.getEnvironmentValue(string);
            if (oldFormula == null || currentFormula.equals(oldFormula) && (Integer)currentFormula.accept(FORMULA_DEPTH_COUNT_VISITOR) <= pPrecision.getMaximumFormulaDepth()) continue;
            InvariantsFormula<CompoundInterval> newValueFormula = CompoundIntervalFormulaManager.INSTANCE.union(currentFormula.accept(this.partialEvaluator, EVALUATION_VISITOR), oldFormula.accept(pOlderState.partialEvaluator, EVALUATION_VISITOR)).accept(new PartialEvaluator(), EVALUATION_VISITOR);
            if (pPrecision.getMaximumFormulaDepth() == 0) {
                CompoundInterval value = ((CompoundInterval)currentFormula.accept(EVALUATION_VISITOR, this.environment)).unionWith((CompoundInterval)oldFormula.accept(EVALUATION_VISITOR, pOlderState.getEnvironment()));
                if (!value.isSingleton()) {
                    value = CompoundInterval.top();
                }
                newValueFormula = CompoundIntervalFormulaManager.INSTANCE.asConstant(value);
            }
            resultEnvironment = resultEnvironment.putAndCopy(string, newValueFormula);
            toDo.put(string, newValueFormula);
        }
        if (toDo.isEmpty()) {
            return this;
        }
        for (Map.Entry entry : toDo.entrySet()) {
            CompoundInterval newValue;
            CompoundInterval currentExactValue;
            String varName = (String)entry.getKey();
            InvariantsFormula newValueFormula = (InvariantsFormula)entry.getValue();
            CompoundInterval simpleExactValue = (CompoundInterval)newValueFormula.accept(EVALUATION_VISITOR, resultEnvironment);
            if (simpleExactValue.isSingleton()) {
                resultEnvironment = resultEnvironment.putAndCopy(varName, CompoundIntervalFormulaManager.INSTANCE.asConstant(simpleExactValue));
                continue;
            }
            InvariantsFormula<CompoundInterval> oldFormula = pOlderState.getEnvironmentValue(varName);
            InvariantsFormula<CompoundInterval> currentFormula = this.getEnvironmentValue(varName);
            CompoundInterval oldExactValue = (CompoundInterval)oldFormula.accept(EVALUATION_VISITOR, pOlderState.environment);
            if (oldExactValue.contains(currentExactValue = (CompoundInterval)currentFormula.accept(EVALUATION_VISITOR, this.environment))) {
                newValue = oldExactValue;
            } else if (oldExactValue.lessEqual(currentExactValue).isDefinitelyTrue() || oldExactValue.hasUpperBound() && (!currentExactValue.hasUpperBound() || oldExactValue.getUpperBound().compareTo(currentExactValue.getUpperBound()) < 0)) {
                newValue = oldExactValue.unionWith(currentExactValue).extendToPositiveInfinity();
            } else if (oldExactValue.greaterEqual(currentExactValue).isDefinitelyTrue() || oldExactValue.hasLowerBound() && (!currentExactValue.hasLowerBound() || oldExactValue.getLowerBound().compareTo(currentExactValue.getLowerBound()) > 0)) {
                newValue = oldExactValue.unionWith(currentExactValue).extendToNegativeInfinity();
            } else {
                InvariantsFormula<CompoundInterval> newFormula = resultEnvironment.get(varName);
                if (newFormula == null) {
                    newFormula = TOP;
                }
                newValue = (CompoundInterval)newFormula.accept(ABSTRACTION_VISITOR, resultEnvironment);
            }
            resultEnvironment = resultEnvironment.putAndCopy(varName, CompoundIntervalFormulaManager.INSTANCE.asConstant(newValue));
        }
        InvariantsState result = new InvariantsState(resultEnvironment, this.variableSelection, this.machineModel, this.variableTypes, this.abstractionState);
        for (InvariantsFormula hint : FluentIterable.from(pWideningHints).filter(this.implies)) {
            result = result.assume(hint);
        }
        if (this.equals(result)) {
            return this;
        }
        return result;
    }

    @Override
    public InvariantsState join(InvariantsState state2) {
        return this.join(state2, InvariantsPrecision.getEmptyPrecision());
    }

    public InvariantsState join(InvariantsState pState2, InvariantsPrecision pPrecision) {
        InvariantsState result;
        InvariantsState state1 = this;
        InvariantsState state2 = pState2;
        if (state1.isLessOrEqual(state2)) {
            result = state2;
        } else if (state2.isLessOrEqual(state1)) {
            result = state1;
        } else {
            AbstractionState abstractionState2;
            InvariantsFormula<CompoundInterval> leftFormula;
            NonRecursiveEnvironment resultEnvironment = NonRecursiveEnvironment.of();
            HashSet<String> todo = new HashSet<String>();
            for (Map.Entry entry : state1.environment.entrySet()) {
                String varName = (String)entry.getKey();
                Object rightFormula = state2.environment.get(varName);
                if (rightFormula == null) continue;
                leftFormula = this.getEnvironmentValue(varName);
                if (leftFormula.equals(rightFormula)) {
                    resultEnvironment = resultEnvironment.putAndCopy(varName, leftFormula);
                    continue;
                }
                todo.add(varName);
            }
            boolean cont = !todo.isEmpty();
            HashSet<String> done = new HashSet<String>();
            while (cont) {
                cont = false;
                Iterable<InvariantsFormula<CompoundInterval>> assumptions = InvariantsState.getEnvironmentAsAssumptions(resultEnvironment);
                for (String varName : todo) {
                    InvariantsFormula<CompoundInterval> leftFormula2 = this.getEnvironmentValue(varName);
                    InvariantsFormula<CompoundInterval> rightFormula = state2.getEnvironmentValue(varName);
                    assert (leftFormula2 != null && rightFormula != null);
                    InvariantsFormula<CompoundInterval> union = CompoundIntervalFormulaManager.INSTANCE.union(leftFormula2.accept(state1.partialEvaluator, EVALUATION_VISITOR), rightFormula.accept(state2.partialEvaluator, EVALUATION_VISITOR)).accept(new PartialEvaluator(), EVALUATION_VISITOR);
                    CompoundIntervalFormulaManager cifm = CompoundIntervalFormulaManager.INSTANCE;
                    Variable<CompoundInterval> variable = cifm.asVariable(varName);
                    InvariantsFormula<CompoundInterval> leftEquation = cifm.equal(variable, leftFormula2);
                    InvariantsFormula<CompoundInterval> rightEquation = cifm.equal(variable, rightFormula);
                    InvariantsFormula<CompoundInterval> unionEquation = cifm.equal(variable, union);
                    Iterable candidateAssumptions = Iterables.concat(Collections.singleton(unionEquation), assumptions);
                    if (CompoundIntervalFormulaManager.definitelyImplies(candidateAssumptions, leftEquation)) {
                        resultEnvironment = resultEnvironment.putAndCopy(varName, leftFormula2);
                        done.add(varName);
                        continue;
                    }
                    if (!CompoundIntervalFormulaManager.definitelyImplies(candidateAssumptions, rightEquation)) continue;
                    resultEnvironment = resultEnvironment.putAndCopy(varName, rightFormula);
                    done.add(varName);
                }
                if (done.isEmpty()) continue;
                cont = !todo.isEmpty();
                todo.removeAll(done);
                done.clear();
            }
            for (String varName : todo) {
                leftFormula = this.getEnvironmentValue(varName);
                InvariantsFormula<CompoundInterval> rightFormula = state2.getEnvironmentValue(varName);
                assert (leftFormula != null && rightFormula != null);
                InvariantsFormula<CompoundInterval> union = CompoundIntervalFormulaManager.INSTANCE.union(leftFormula.accept(state1.partialEvaluator, EVALUATION_VISITOR), rightFormula.accept(state2.partialEvaluator, EVALUATION_VISITOR)).accept(new PartialEvaluator(), EVALUATION_VISITOR);
                InvariantsFormula<CompoundInterval> evaluated = CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)union.accept(EVALUATION_VISITOR, resultEnvironment));
                resultEnvironment = resultEnvironment.putAndCopy(varName, evaluated);
            }
            VariableSelection<CompoundInterval> resultVariableSelection = state1.variableSelection.join(state2.variableSelection);
            PersistentSortedMap variableTypes = state1.variableTypes;
            for (Map.Entry entry : state2.variableTypes.entrySet()) {
                if (variableTypes.containsKey(entry.getKey())) continue;
                variableTypes = variableTypes.putAndCopy(entry.getKey(), entry.getValue());
            }
            AbstractionState abstractionState1 = this.determineAbstractionState(pPrecision);
            AbstractionState abstractionState = abstractionState1.join(abstractionState2 = pState2.determineAbstractionState(pPrecision));
            result = new InvariantsState(resultVariableSelection, this.machineModel, abstractionState, resultEnvironment, (PersistentSortedMap<String, CType>)variableTypes);
            if (result.equalsState(state1)) {
                result = state1;
            }
        }
        return result;
    }

    public InvariantsFormula<CompoundInterval> asFormula() {
        InvariantsFormula<CompoundInterval> result = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.logicalTrue());
        for (InvariantsFormula<CompoundInterval> assumption : this.getEnvironmentAsAssumptions()) {
            result = CompoundIntervalFormulaManager.INSTANCE.logicalAnd(result, assumption);
        }
        return result;
    }
}

