/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.VariableNameExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerTransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;

class InvariantsTransferRelation
extends SingleEdgeTransferRelation {
    private static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads");
    static final InvariantsTransferRelation INSTANCE = new InvariantsTransferRelation();
    static final String RETURN_VARIABLE_BASE_NAME = "___cpa_temp_result_var_";
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();

    InvariantsTransferRelation() {
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        InvariantsState state = (InvariantsState)pState;
        InvariantsPrecision precision = (InvariantsPrecision)pPrecision;
        if ((state = this.getSuccessor(pEdge, precision, state)) == null) {
            return Collections.emptySet();
        }
        state = state.updateAbstractionState(precision, pEdge);
        return Collections.singleton(state);
    }

    private InvariantsState getSuccessor(CFAEdge pEdge, InvariantsPrecision pPrecision, InvariantsState pState) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException {
        InvariantsState state = pState.setTypes(this.getInvolvedVariables(pEdge));
        switch (pEdge.getEdgeType()) {
            case BlankEdge: {
                break;
            }
            case FunctionReturnEdge: {
                state = this.handleFunctionReturn(state, (CFunctionReturnEdge)pEdge, pPrecision);
                break;
            }
            case ReturnStatementEdge: {
                state = this.handleReturnStatement(state, (CReturnStatementEdge)pEdge, pPrecision);
                break;
            }
            case AssumeEdge: {
                state = this.handleAssume(state, (CAssumeEdge)pEdge, pPrecision);
                break;
            }
            case DeclarationEdge: {
                state = this.handleDeclaration(state, (CDeclarationEdge)pEdge, pPrecision);
                break;
            }
            case FunctionCallEdge: {
                state = this.handleFunctionCall(state, (CFunctionCallEdge)pEdge, pPrecision);
                break;
            }
            case StatementEdge: {
                state = this.handleStatement(state, (CStatementEdge)pEdge, pPrecision);
                break;
            }
            case MultiEdge: {
                Iterator<CFAEdge> edgeIterator = ((MultiEdge)pEdge).iterator();
                while (state != null && edgeIterator.hasNext()) {
                    state = this.getSuccessor(edgeIterator.next(), pPrecision, state);
                }
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(pEdge);
            }
        }
        if (state != null && pPrecision != null && !pPrecision.isRelevant(pEdge)) {
            state = state.clear();
        }
        return state;
    }

    private InvariantsState handleAssume(InvariantsState pElement, CAssumeEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        CExpression expression = pEdge.getExpression();
        InvariantsFormula<CompoundInterval> expressionFormula = expression.accept(InvariantsTransferRelation.getExpressionToFormulaVisitor(pEdge, pElement));
        if (!pEdge.getTruthAssumption()) {
            expressionFormula = CompoundIntervalFormulaManager.INSTANCE.logicalNot(expressionFormula);
        }
        return this.handleAssumption(pElement, pEdge, expressionFormula, pPrecision);
    }

    private InvariantsState handleAssumption(InvariantsState pState, CFAEdge pEdge, InvariantsFormula<CompoundInterval> pAssumption, InvariantsPrecision pPrecision) {
        if (pState.definitelyImplies(CompoundIntervalFormulaManager.INSTANCE.logicalNot(pAssumption))) {
            return null;
        }
        InvariantsState result = pState.assume(pAssumption);
        return result;
    }

    private InvariantsState handleDeclaration(InvariantsState pElement, CDeclarationEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        InvariantsFormula<CompoundInterval> value;
        if (!(pEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return pElement;
        }
        CVariableDeclaration decl = (CVariableDeclaration)pEdge.getDeclaration();
        String varName = decl.getName();
        if (!decl.isGlobal()) {
            varName = VariableNameExtractor.scope(varName, pEdge.getSuccessor().getFunctionName());
        }
        if (decl.getInitializer() != null && decl.getInitializer() instanceof CInitializerExpression) {
            CExpression init = ((CInitializerExpression)decl.getInitializer()).getExpression();
            value = init.accept(InvariantsTransferRelation.getExpressionToFormulaVisitor(pEdge, pElement));
            if (InvariantsTransferRelation.containsArrayWildcard(value)) {
                value = InvariantsTransferRelation.toConstant(value, pElement.getEnvironment());
            }
        } else {
            value = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
        }
        value = this.handlePotentialOverflow(pElement, value, decl.getType());
        return pElement.assign(varName, value);
    }

    private InvariantsState handleFunctionCall(InvariantsState pElement, CFunctionCallEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        InvariantsState newElement = pElement;
        ImmutableList formalParams = pEdge.getSuccessor().getFunctionParameterNames();
        List<CParameterDeclaration> declarations = pEdge.getSuccessor().getFunctionParameters();
        ImmutableList actualParams = pEdge.getArguments();
        int limit = Math.min(formalParams.size(), actualParams.size());
        ExpressionToFormulaVisitor actualParamExpressionToFormulaVisitor = InvariantsTransferRelation.getExpressionToFormulaVisitor(new VariableNameExtractor(pEdge, true, pElement.getEnvironment()), pElement);
        if (limit == 1 && "__VERIFIER_assume".equals(pEdge.getSuccessor().getFunctionName())) {
            return this.handleAssumption(pElement, pEdge, actualParams.get(0).accept(actualParamExpressionToFormulaVisitor), pPrecision);
        }
        formalParams = FluentIterable.from(formalParams).limit(limit).toList();
        actualParams = FluentIterable.from(actualParams).limit(limit).toList();
        Iterator<CParameterDeclaration> declarationIterator = declarations.iterator();
        for (Pair param : Pair.zipList((Collection)formalParams, (Collection)actualParams)) {
            CExpression actualParam = (CExpression)param.getSecond();
            CParameterDeclaration declaration = declarationIterator.next();
            InvariantsFormula<CompoundInterval> value = actualParam.accept(actualParamExpressionToFormulaVisitor);
            if (InvariantsTransferRelation.containsArrayWildcard(value)) {
                value = InvariantsTransferRelation.toConstant(value, pElement.getEnvironment());
            }
            String formalParam = VariableNameExtractor.scope((String)param.getFirst(), pEdge.getSuccessor().getFunctionName());
            value = this.handlePotentialOverflow(pElement, value, declaration.getType());
            newElement = newElement.assign(formalParam, value);
        }
        return newElement;
    }

    private static CompoundInterval evaluate(InvariantsFormula<CompoundInterval> pFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pFormula.accept(new FormulaCompoundStateEvaluationVisitor(), pEnvironment);
    }

    private static InvariantsFormula<CompoundInterval> toConstant(InvariantsFormula<CompoundInterval> pFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return CompoundIntervalFormulaManager.INSTANCE.asConstant(InvariantsTransferRelation.evaluate(pFormula, pEnvironment));
    }

    private InvariantsState handleStatement(InvariantsState pElement, CStatementEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        String func;
        CExpression fn;
        if (pEdge.getStatement() instanceof CFunctionCall && (fn = ((CFunctionCall)pEdge.getStatement()).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression && UNSUPPORTED_FUNCTIONS.containsKey(func = ((CIdExpression)fn).getName())) {
            throw new UnsupportedCCodeException(UNSUPPORTED_FUNCTIONS.get(func), (CFAEdge)pEdge, fn);
        }
        if (pEdge.getStatement() instanceof CAssignment) {
            CIdExpression idExpression;
            CFunctionCallExpression cFunctionCallExpression;
            CExpression functionNameExpression;
            CAssignment assignment = (CAssignment)pEdge.getStatement();
            ExpressionToFormulaVisitor etfv = InvariantsTransferRelation.getExpressionToFormulaVisitor(pEdge, pElement);
            CLeftHandSide leftHandSide = assignment.getLeftHandSide();
            CRightHandSide rightHandSide = assignment.getRightHandSide();
            InvariantsFormula<CompoundInterval> value = assignment.getRightHandSide().accept(etfv);
            if (CompoundIntervalFormulaManager.isDefinitelyTop(value) && rightHandSide instanceof CFunctionCallExpression && (functionNameExpression = (cFunctionCallExpression = (CFunctionCallExpression)rightHandSide).getFunctionNameExpression()) instanceof CIdExpression && (idExpression = (CIdExpression)functionNameExpression).getName().equals("__VERIFIER_nondet_uint")) {
                value = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.zero().extendToPositiveInfinity());
            }
            value = this.handlePotentialOverflow(pElement, value, leftHandSide.getExpressionType());
            return this.handleAssignment(pElement, pEdge.getPredecessor().getFunctionName(), pEdge, leftHandSide, value, pPrecision);
        }
        return pElement;
    }

    private InvariantsState handleAssignment(InvariantsState pElement, String pFunctionName, CFAEdge pEdge, CExpression pLeftHandSide, InvariantsFormula<CompoundInterval> pValue, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        InvariantsFormula<CompoundInterval> value = pValue;
        if (pPrecision.getMaximumFormulaDepth() == 0) {
            CompoundInterval v = InvariantsTransferRelation.evaluate(pValue, pElement.getEnvironment());
            value = v.isSingleton() ? CompoundIntervalFormulaManager.INSTANCE.asConstant(v) : CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
        }
        ExpressionToFormulaVisitor etfv = InvariantsTransferRelation.getExpressionToFormulaVisitor(pEdge, pElement);
        VariableNameExtractor variableNameExtractor = new VariableNameExtractor(pEdge, pElement.getEnvironment());
        if (pLeftHandSide instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression arraySubscriptExpression = (CArraySubscriptExpression)pLeftHandSide;
            String array = variableNameExtractor.getVarName(arraySubscriptExpression.getArrayExpression());
            InvariantsFormula<CompoundInterval> subscript = arraySubscriptExpression.getSubscriptExpression().accept(etfv);
            return pElement.assignArray(array, subscript, value);
        }
        String varName = variableNameExtractor.getVarName(pLeftHandSide);
        return pElement.assign(varName, value);
    }

    private InvariantsFormula<CompoundInterval> handlePotentialOverflow(InvariantsState pState, InvariantsFormula<CompoundInterval> pFormula, CType pType) {
        return ExpressionToFormulaVisitor.handlePotentialOverflow(pFormula, pState.getMachineModel(), pType, pState.getEnvironment());
    }

    private InvariantsState handleReturnStatement(InvariantsState pElement, CReturnStatementEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        String calledFunctionName = pEdge.getPredecessor().getFunctionName();
        if (!pEdge.getExpression().isPresent()) {
            return pElement;
        }
        ExpressionToFormulaVisitor etfv = InvariantsTransferRelation.getExpressionToFormulaVisitor(pEdge, pElement);
        InvariantsFormula<CompoundInterval> returnedState = ((CExpression)pEdge.getExpression().get()).accept(etfv);
        String returnValueName = VariableNameExtractor.scope(RETURN_VARIABLE_BASE_NAME, calledFunctionName);
        return pElement.assign(returnValueName, returnedState);
    }

    private InvariantsState handleFunctionReturn(InvariantsState pElement, CFunctionReturnEdge pFunctionReturnEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        CFunctionSummaryEdge summaryEdge = pFunctionReturnEdge.getSummaryEdge();
        CFunctionCall expression = summaryEdge.getExpression();
        String calledFunctionName = pFunctionReturnEdge.getPredecessor().getFunctionName();
        String returnValueName = VariableNameExtractor.scope(RETURN_VARIABLE_BASE_NAME, calledFunctionName);
        Variable<CompoundInterval> value = CompoundIntervalFormulaManager.INSTANCE.asVariable(returnValueName);
        InvariantsState result = pElement;
        if (expression instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement funcExp = (CFunctionCallAssignmentStatement)expression;
            result = this.handleAssignment(pElement, pFunctionReturnEdge.getSuccessor().getFunctionName(), pFunctionReturnEdge, funcExp.getLeftHandSide(), value, pPrecision);
        } else {
            Iterator<CExpression> actualParamIterator = summaryEdge.getExpression().getFunctionCallExpression().getParameterExpressions().iterator();
            for (String formalParamName : pFunctionReturnEdge.getPredecessor().getEntryNode().getFunctionParameterNames()) {
                if (!actualParamIterator.hasNext()) break;
                CExpression actualParam = actualParamIterator.next();
                InvariantsFormula<CompoundInterval> actualParamFormula = actualParam.accept(InvariantsTransferRelation.getExpressionToFormulaVisitor(summaryEdge, pElement));
                if (!(actualParamFormula instanceof Variable)) continue;
                String actualParamName = ((Variable)actualParamFormula).getName();
                String formalParamPrefixDeref = calledFunctionName + "::" + formalParamName + "->";
                String formalParamPrefixAccess = calledFunctionName + "::" + formalParamName + ".";
                for (Map.Entry<String, InvariantsFormula<CompoundInterval>> entry : pElement.getEnvironment().entrySet()) {
                    String formalParamSuffix;
                    String varName = entry.getKey();
                    if (varName.startsWith(formalParamPrefixDeref)) {
                        formalParamSuffix = varName.substring(formalParamPrefixDeref.length());
                        result = result.assign(actualParamName + "->" + formalParamSuffix, entry.getValue());
                        continue;
                    }
                    if (!varName.startsWith(formalParamPrefixAccess)) continue;
                    formalParamSuffix = varName.substring(formalParamPrefixAccess.length());
                    result = result.assign(actualParamName + "." + formalParamSuffix, entry.getValue());
                }
            }
        }
        for (String variableName : result.getEnvironment().keySet()) {
            if (!VariableNameExtractor.isFunctionScoped(variableName, calledFunctionName)) continue;
            result = result.clear(variableName);
        }
        return result;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws UnrecognizedCCodeException {
        InvariantsState state = (InvariantsState)pElement;
        CFAEdge edge = pCfaEdge;
        if (edge instanceof MultiEdge) {
            for (CFAEdge subEdge : (MultiEdge)edge) {
                InvariantsState current = state;
                Collection<? extends AbstractState> next = this.strengthen(state, pOtherElements, subEdge, pPrecision);
                if (next == null) {
                    state = current;
                    continue;
                }
                if (next.isEmpty()) {
                    return next;
                }
                state = (InvariantsState)Iterables.getOnlyElement(next);
            }
            return Collections.singleton(state);
        }
        CLeftHandSide leftHandSide = InvariantsTransferRelation.getLeftHandSide(edge);
        if (leftHandSide instanceof CPointerExpression || leftHandSide instanceof CFieldReference && ((CFieldReference)leftHandSide).isPointerDereference()) {
            FluentIterable pointerStates = FluentIterable.from(pOtherElements).filter(PointerState.class);
            if (pointerStates.isEmpty()) {
                return Collections.singleton(state.clear());
            }
            InvariantsState result = state;
            for (PointerState pointerState : pointerStates) {
                LocationSet locationSet = PointerTransferRelation.asLocations(leftHandSide, pointerState);
                if (locationSet.isTop()) {
                    return Collections.singleton(state.clear());
                }
                InvariantsFormula<CompoundInterval> top = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
                Iterable<String> locations = PointerTransferRelation.toNormalSet(pointerState, locationSet);
                boolean moreThanOneLocation = InvariantsTransferRelation.hasMoreThanNElements(locations, 1);
                for (String location : locations) {
                    boolean hasArrow;
                    int lastIndexOfDot = location.lastIndexOf(46);
                    int lastIndexOfArrow = location.lastIndexOf("->");
                    boolean hasDot = lastIndexOfDot >= 0;
                    boolean bl = hasArrow = lastIndexOfArrow >= 0;
                    if (hasArrow || hasDot) {
                        if (hasArrow) {
                            ++lastIndexOfArrow;
                        }
                        int lastIndexOfSep = Math.max(lastIndexOfDot, lastIndexOfArrow);
                        final String end = location.substring(lastIndexOfSep + 1);
                        FluentIterable targets = FluentIterable.from(result.getEnvironment().keySet()).filter((Predicate)new Predicate<String>(){

                            public boolean apply(String pVar) {
                                return pVar != null && (pVar.endsWith("." + end) || pVar.endsWith("->" + end));
                            }
                        });
                        if (!moreThanOneLocation && !InvariantsTransferRelation.hasMoreThanNElements(targets, 1)) continue;
                        for (String variableName : targets) {
                            result = result.assign(variableName, top);
                        }
                        continue;
                    }
                    if (!moreThanOneLocation) continue;
                    result = result.assign(location, top);
                }
            }
            return Collections.singleton(result);
        }
        return null;
    }

    private static ExpressionToFormulaVisitor getExpressionToFormulaVisitor(CFAEdge pEdge, InvariantsState pState) {
        return InvariantsTransferRelation.getExpressionToFormulaVisitor(new VariableNameExtractor(pEdge, pState.getEnvironment()), pState);
    }

    private static ExpressionToFormulaVisitor getExpressionToFormulaVisitor(VariableNameExtractor pVariableNameExtractor, InvariantsState pState) {
        return new ExpressionToFormulaVisitor(pVariableNameExtractor, pState.getEnvironment());
    }

    private static boolean containsArrayWildcard(InvariantsFormula<CompoundInterval> pFormula) {
        for (String pVarName : (Set)pFormula.accept(COLLECT_VARS_VISITOR)) {
            if (!pVarName.contains("[*]")) continue;
            return true;
        }
        return false;
    }

    private static CLeftHandSide getLeftHandSide(CFAEdge pEdge) {
        CFunctionCallEdge functionCallEdge;
        CFunctionCall functionCall;
        if (pEdge instanceof CStatementEdge) {
            CStatementEdge statementEdge = (CStatementEdge)pEdge;
            if (statementEdge.getStatement() instanceof CAssignment) {
                CAssignment assignment = (CAssignment)statementEdge.getStatement();
                return assignment.getLeftHandSide();
            }
        } else if (pEdge instanceof CFunctionCallEdge && (functionCall = (functionCallEdge = (CFunctionCallEdge)pEdge).getSummaryEdge().getExpression()) instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignment = (CFunctionCallAssignmentStatement)functionCall;
            return assignment.getLeftHandSide();
        }
        return null;
    }

    private static boolean hasMoreThanNElements(Iterable<?> pIterable, int pN) {
        return !Iterables.isEmpty((Iterable)Iterables.skip(pIterable, (int)pN));
    }

    public Map<String, CType> getInvolvedVariables(CFAEdge pCfaEdge) {
        switch (pCfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)pCfaEdge;
                AExpression expression = assumeEdge.getExpression();
                return InvariantsTransferRelation.getInvolvedVariables(expression, pCfaEdge);
            }
            case MultiEdge: {
                MultiEdge multiEdge = (MultiEdge)pCfaEdge;
                HashMap<String, CType> result = new HashMap<String, CType>();
                for (CFAEdge cFAEdge : multiEdge) {
                    result.putAll(this.getInvolvedVariables(cFAEdge));
                }
                return result;
            }
            case DeclarationEdge: {
                ADeclarationEdge declarationEdge = (ADeclarationEdge)pCfaEdge;
                ADeclaration declaration = declarationEdge.getDeclaration();
                if (declaration instanceof CVariableDeclaration) {
                    CVariableDeclaration variableDeclaration = (CVariableDeclaration)declaration;
                    String string = variableDeclaration.getQualifiedName();
                    CType type = variableDeclaration.getType();
                    CInitializer cInitializer = variableDeclaration.getInitializer();
                    if (cInitializer == null) {
                        return Collections.singletonMap(string, type);
                    }
                    HashMap<String, CType> hashMap = new HashMap<String, CType>();
                    hashMap.put(string, type);
                    hashMap.putAll(this.getInvolvedVariables(cInitializer, pCfaEdge));
                    return hashMap;
                }
                if (declaration instanceof AVariableDeclaration) {
                    throw new UnsupportedOperationException("Only C expressions are supported");
                }
                return Collections.emptyMap();
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)pCfaEdge;
                HashMap<String, CType> result = new HashMap<String, CType>();
                for (AExpression aExpression : functionCallEdge.getArguments()) {
                    result.putAll(InvariantsTransferRelation.getInvolvedVariables(aExpression, pCfaEdge));
                }
                for (AExpression aExpression : functionCallEdge.getSummaryEdge().getExpression().getFunctionCallExpression().getParameterExpressions()) {
                    result.putAll(InvariantsTransferRelation.getInvolvedVariables(aExpression, pCfaEdge));
                }
                return result;
            }
            case ReturnStatementEdge: {
                AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)pCfaEdge;
                if (returnStatementEdge.getExpression().isPresent()) {
                    AExpression returnExpression = (AExpression)returnStatementEdge.getExpression().get();
                    HashMap<String, CType> result = new HashMap<String, CType>();
                    result.put(VariableNameExtractor.scope(RETURN_VARIABLE_BASE_NAME, pCfaEdge.getSuccessor().getFunctionName()), (CType)returnExpression.getExpressionType());
                    result.putAll(InvariantsTransferRelation.getInvolvedVariables(returnExpression, pCfaEdge));
                    return result;
                }
                return Collections.emptyMap();
            }
            case StatementEdge: {
                AStatementEdge statementEdge = (AStatementEdge)pCfaEdge;
                AStatement statement = statementEdge.getStatement();
                if (statement instanceof AExpressionAssignmentStatement) {
                    AExpressionAssignmentStatement expressionAssignmentStatement = (AExpressionAssignmentStatement)statement;
                    HashMap<String, CType> hashMap = new HashMap<String, CType>();
                    hashMap.putAll(InvariantsTransferRelation.getInvolvedVariables(expressionAssignmentStatement.getLeftHandSide(), pCfaEdge));
                    hashMap.putAll(InvariantsTransferRelation.getInvolvedVariables(expressionAssignmentStatement.getRightHandSide(), pCfaEdge));
                    return hashMap;
                }
                if (statement instanceof AExpressionStatement) {
                    return InvariantsTransferRelation.getInvolvedVariables(((AExpressionStatement)statement).getExpression(), pCfaEdge);
                }
                if (statement instanceof AFunctionCallAssignmentStatement) {
                    AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)statement;
                    HashMap<String, CType> hashMap = new HashMap<String, CType>();
                    hashMap.putAll(InvariantsTransferRelation.getInvolvedVariables(functionCallAssignmentStatement.getLeftHandSide(), pCfaEdge));
                    AFunctionCallExpression functionCallExpression = functionCallAssignmentStatement.getFunctionCallExpression();
                    for (AExpression aExpression : functionCallExpression.getParameterExpressions()) {
                        hashMap.putAll(InvariantsTransferRelation.getInvolvedVariables(aExpression, pCfaEdge));
                    }
                    return hashMap;
                }
                if (statement instanceof AFunctionCallStatement) {
                    AFunctionCallStatement functionCallStatement = (AFunctionCallStatement)statement;
                    HashMap<String, CType> hashMap = new HashMap<String, CType>();
                    for (AExpression aExpression : functionCallStatement.getFunctionCallExpression().getParameterExpressions()) {
                        hashMap.putAll(InvariantsTransferRelation.getInvolvedVariables(aExpression, pCfaEdge));
                    }
                    return hashMap;
                }
                return Collections.emptyMap();
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)pCfaEdge;
                AFunctionCall functionCall = functionReturnEdge.getSummaryEdge().getExpression();
                if (functionCall instanceof AFunctionCallAssignmentStatement) {
                    AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)functionCall;
                    AFunctionCallExpression aFunctionCallExpression = functionCall.getFunctionCallExpression();
                    if (aFunctionCallExpression != null) {
                        HashMap<String, CType> result = new HashMap<String, CType>();
                        result.put(VariableNameExtractor.scope(RETURN_VARIABLE_BASE_NAME, pCfaEdge.getPredecessor().getFunctionName()), (CType)aFunctionCallExpression.getExpressionType());
                        result.putAll(InvariantsTransferRelation.getInvolvedVariables(functionCallAssignmentStatement.getLeftHandSide(), pCfaEdge));
                        return result;
                    }
                }
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, CType> getInvolvedVariables(CInitializer pCInitializer, CFAEdge pCfaEdge) {
        if (pCInitializer instanceof CDesignatedInitializer) {
            return this.getInvolvedVariables(((CDesignatedInitializer)pCInitializer).getRightHandSide(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerExpression) {
            return InvariantsTransferRelation.getInvolvedVariables(((CInitializerExpression)pCInitializer).getExpression(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerList) {
            CInitializerList initializerList = (CInitializerList)pCInitializer;
            HashMap<String, CType> result = new HashMap<String, CType>();
            for (CInitializer initializer : initializerList.getInitializers()) {
                result.putAll(this.getInvolvedVariables(initializer, pCfaEdge));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public static Map<String, CType> getInvolvedVariables(AExpression pExpression, CFAEdge pCfaEdge) {
        if (pExpression == null) {
            return Collections.emptyMap();
        }
        if (pExpression instanceof CExpression) {
            HashMap<String, CType> result = new HashMap<String, CType>();
            for (ALeftHandSide leftHandSide : ((CExpression)pExpression).accept(new DefaultCExpressionVisitor<Iterable<ALeftHandSide>, RuntimeException>(){

                @Override
                protected Iterable<ALeftHandSide> visitDefault(CExpression pExp) {
                    return Collections.emptySet();
                }

                @Override
                public Iterable<ALeftHandSide> visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
                    return Collections.singleton(pIastArraySubscriptExpression);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CFieldReference pIastFieldReference) {
                    return Collections.singleton(pIastFieldReference);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CIdExpression pIastIdExpression) {
                    return Collections.singleton(pIastIdExpression);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CPointerExpression pPointerExpression) {
                    return Collections.singleton(pPointerExpression);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CComplexCastExpression pComplexCastExpression) {
                    return pComplexCastExpression.getOperand().accept(this);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CBinaryExpression pIastBinaryExpression) {
                    return Iterables.concat(pIastBinaryExpression.getOperand1().accept(this), pIastBinaryExpression.getOperand2().accept(this));
                }

                @Override
                public Iterable<ALeftHandSide> visit(CCastExpression pIastCastExpression) {
                    return pIastCastExpression.getOperand().accept(this);
                }

                @Override
                public Iterable<ALeftHandSide> visit(CUnaryExpression pIastUnaryExpression) {
                    return pIastUnaryExpression.getOperand().accept(this);
                }
            })) {
                try {
                    InvariantsFormula<CompoundInterval> formula = ((CExpression)((Object)leftHandSide)).accept(new ExpressionToFormulaVisitor(new VariableNameExtractor(pCfaEdge, Collections.emptyMap())));
                    for (String variableName : (Set)formula.accept(COLLECT_VARS_VISITOR)) {
                        result.put(variableName, (CType)leftHandSide.getExpressionType());
                    }
                }
                catch (UnrecognizedCodeException e) {
                }
            }
            return result;
        }
        throw new UnsupportedOperationException("Only C expressions are supported");
    }
}

