/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class InvariantsWriter {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();
    private static final Joiner LINE_JOINER = Joiner.on((char)'\n');
    private final FormulaManagerView fmgr;

    public InvariantsWriter(PredicateCPA pCpa) {
        this(pCpa.getSolver().getFormulaManager());
    }

    public InvariantsWriter(FormulaManagerView pFmgr) {
        this.fmgr = pFmgr;
    }

    public void write(UnmodifiableReachedSet pReachedSet, Appendable pAppendable) throws IOException {
        HashMultimap locationPredicates = HashMultimap.create();
        for (AbstractState state : pReachedSet) {
            CFANode location = AbstractStates.extractLocation(state);
            if (location == null) continue;
            InvariantsState invariantsState = AbstractStates.extractStateByType(state, InvariantsState.class);
            locationPredicates.put((Object)location, (Object)invariantsState);
        }
        this.write((SetMultimap<CFANode, InvariantsState>)locationPredicates, pAppendable);
    }

    public void write(final CFANode pCfaNode, UnmodifiableReachedSet pReachedSet, Appendable pAppendable) throws IOException {
        FluentIterable states = FluentIterable.from((Iterable)pReachedSet).filter((Predicate)new Predicate<AbstractState>(){

            public boolean apply(@Nullable AbstractState pArg0) {
                return pArg0 != null && AbstractStates.extractLocation(pArg0).equals(pCfaNode);
            }
        }).transform((Function)new Function<AbstractState, InvariantsState>(){

            @Nullable
            public InvariantsState apply(@Nullable AbstractState pArg0) {
                if (pArg0 == null) {
                    return null;
                }
                return AbstractStates.extractStateByType(pArg0, InvariantsState.class);
            }
        });
        HashMultimap statesToNode = HashMultimap.create();
        statesToNode.putAll((Object)pCfaNode, (Iterable)states);
        this.write((SetMultimap<CFANode, InvariantsState>)statesToNode, pAppendable);
    }

    private void write(SetMultimap<CFANode, InvariantsState> pStates, Appendable pAppendable) throws IOException {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        LinkedHashSet definitions = Sets.newLinkedHashSet();
        HashMap predToString = Maps.newHashMap();
        Iterator iterator = pStates.asMap().values().iterator();
        while (iterator.hasNext()) {
            Collection invariantDisjunctiveParts = (Collection)iterator.next();
            BooleanFormula formula = bfmgr.makeBoolean(false);
            for (InvariantsState state : invariantDisjunctiveParts) {
                if (state == null) continue;
                formula = bfmgr.or(formula, state.getFormulaApproximation(this.fmgr));
            }
            if (bfmgr.isTrue(formula)) {
                iterator.remove();
                continue;
            }
            String s = this.fmgr.dumpFormula(formula).toString();
            ArrayList lines = Lists.newArrayList((Iterable)LINE_SPLITTER.split((CharSequence)s));
            assert (!lines.isEmpty());
            String predString = (String)lines.get(lines.size() - 1);
            lines.remove(lines.size() - 1);
            if (!predString.startsWith("(assert ") || !predString.endsWith(")")) {
                pAppendable.append("Writing invariants is only supported for solvers which support the Smtlib2 format, please try using Mathsat5.\n");
                return;
            }
            definitions.addAll(lines);
            predToString.put(invariantDisjunctiveParts, predString);
        }
        LINE_JOINER.appendTo(pAppendable, (Iterable)definitions);
        pAppendable.append("\n\n");
        for (Map.Entry entry : pStates.asMap().entrySet()) {
            this.writeInvariant(pAppendable, InvariantsWriter.toKey((CFANode)entry.getKey()), (Collection)entry.getValue(), predToString);
        }
    }

    private void writeInvariant(Appendable pAppendable, String pKey, Collection<InvariantsState> pDisjunctiveParts, Map<Collection<InvariantsState>, String> predToString) throws IOException {
        pAppendable.append(pKey);
        pAppendable.append(":\n");
        pAppendable.append((CharSequence)Preconditions.checkNotNull((Object)predToString.get(pDisjunctiveParts)));
        pAppendable.append('\n');
    }

    private static String toKey(CFANode pCfaNode) {
        return pCfaNode.getFunctionName() + " " + pCfaNode.toString();
    }
}

