/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsVarVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class NonRecursiveEnvironment
implements Map<String, InvariantsFormula<CompoundInterval>> {
    private static final FormulaEvaluationVisitor<CompoundInterval> FORMULA_EVALUATION_VISITOR = new FormulaCompoundStateEvaluationVisitor();
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private static final InvariantsFormula<CompoundInterval> TOP = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
    private final ContainsVarVisitor<CompoundInterval> containsVarVisitor = new ContainsVarVisitor();
    private final PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> inner;
    private static final NonRecursiveEnvironment EMPTY_ENVIRONMENT = new NonRecursiveEnvironment((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)PathCopyingPersistentTreeMap.of());

    public static NonRecursiveEnvironment of() {
        return EMPTY_ENVIRONMENT;
    }

    private NonRecursiveEnvironment(Map<String, InvariantsFormula<CompoundInterval>> pInner) {
        this.inner = PathCopyingPersistentTreeMap.copyOf(pInner);
    }

    private NonRecursiveEnvironment(PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> pInner) {
        this.inner = pInner;
    }

    public static NonRecursiveEnvironment copyOf(Map<String, InvariantsFormula<CompoundInterval>> pInner) {
        if (pInner instanceof NonRecursiveEnvironment) {
            return (NonRecursiveEnvironment)pInner;
        }
        if (pInner instanceof PersistentSortedMap) {
            return new NonRecursiveEnvironment((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)((PersistentSortedMap)pInner));
        }
        return new NonRecursiveEnvironment(pInner);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object pVarName) {
        return this.inner.containsKey(pVarName);
    }

    @Override
    public boolean containsValue(Object pValue) {
        return this.inner.containsValue(pValue);
    }

    @Override
    public InvariantsFormula<CompoundInterval> get(Object pVarName) {
        return (InvariantsFormula)this.inner.get(pVarName);
    }

    @Override
    @Deprecated
    public InvariantsFormula<CompoundInterval> put(String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public InvariantsFormula<CompoundInterval> remove(Object pKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pM) {
        throw new UnsupportedOperationException();
    }

    private PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> sanitizedInnerPutAndCopy(PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> pTarget, ContainsVarVisitor<CompoundInterval> pContainsVarVisitor, String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        if (pValue == null || pValue.equals(TOP)) {
            if (pTarget.containsKey((Object)pVarName)) {
                return pTarget.removeAndCopy((Object)pVarName);
            }
            return pTarget;
        }
        InvariantsFormula previous = (InvariantsFormula)pTarget.get((Object)pVarName);
        if (pValue.equals(previous)) {
            return pTarget;
        }
        ContainsVarVisitor containsVarVisitor = new ContainsVarVisitor(pTarget = pTarget.removeAndCopy((Object)pVarName));
        if (((Boolean)pValue.accept(containsVarVisitor, pVarName)).booleanValue()) {
            return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)pTarget, pVarName, CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pValue.accept(FORMULA_EVALUATION_VISITOR, this)));
        }
        Variable<CompoundInterval> variable = CompoundIntervalFormulaManager.INSTANCE.asVariable(pVarName);
        for (String containedVarName : (Set)pValue.accept(COLLECT_VARS_VISITOR)) {
            if (!((Boolean)variable.accept(containsVarVisitor, containedVarName)).booleanValue()) continue;
            return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)pTarget, pVarName, CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pValue.accept(FORMULA_EVALUATION_VISITOR, this)));
        }
        return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)pTarget, pVarName, pValue);
    }

    private PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> sanitizedInnerPutAndCopyInternal(PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> pTarget, String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        if (pValue.equals(TOP)) {
            return pTarget;
        }
        Preconditions.checkArgument((!pTarget.containsKey((Object)pVarName) ? 1 : 0) != 0, (Object)"Variable must be TOP in previous environment");
        InvariantsFormula previous = (InvariantsFormula)pTarget.get((Object)pVarName);
        if (pValue.equals(previous)) {
            return pTarget;
        }
        return pTarget.putAndCopy((Object)pVarName, pValue);
    }

    public NonRecursiveEnvironment putAndCopy(String pVarName, InvariantsFormula<CompoundInterval> pValue) {
        InvariantsFormula<CompoundInterval> previous = this.get(pVarName);
        if (previous == null) {
            previous = TOP;
        }
        if (pValue == null) {
            pValue = TOP;
        }
        if (previous.equals(pValue)) {
            return this;
        }
        PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> resultInner = this.sanitizedInnerPutAndCopy(this.inner, this.containsVarVisitor, pVarName, pValue);
        if (this.inner == resultInner) {
            return this;
        }
        return new NonRecursiveEnvironment(resultInner);
    }

    public NonRecursiveEnvironment putAndCopyAll(Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pM) {
        PersistentSortedMap<String, InvariantsFormula<CompoundInterval>> resultInner = this.inner;
        for (Map.Entry<? extends String, ? extends InvariantsFormula<CompoundInterval>> entry : pM.entrySet()) {
            resultInner = this.sanitizedInnerPutAndCopy(resultInner, new ContainsVarVisitor<CompoundInterval>((Map<String, InvariantsFormula<CompoundInterval>>)resultInner), entry.getKey(), entry.getValue());
        }
        return new NonRecursiveEnvironment(resultInner);
    }

    public NonRecursiveEnvironment removeAndCopy(Object pKey) {
        if (!this.containsKey(pKey)) {
            return this;
        }
        return new NonRecursiveEnvironment((PersistentSortedMap<String, InvariantsFormula<CompoundInterval>>)this.inner.removeAndCopy(pKey));
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<String> keySet() {
        return this.inner.keySet();
    }

    @Override
    public Collection<InvariantsFormula<CompoundInterval>> values() {
        return Collections.unmodifiableCollection(this.inner.values());
    }

    @Override
    public SortedSet<Map.Entry<String, InvariantsFormula<CompoundInterval>>> entrySet() {
        return this.inner.entrySet();
    }

    public String toString() {
        return this.inner.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.inner.equals(o);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }

    public static class Builder
    implements Map<String, InvariantsFormula<CompoundInterval>> {
        private NonRecursiveEnvironment current;

        public Builder() {
            this(NonRecursiveEnvironment.of());
        }

        public Builder(Map<String, InvariantsFormula<CompoundInterval>> pInitialEnvironment) {
            this(NonRecursiveEnvironment.copyOf(pInitialEnvironment));
        }

        public Builder(NonRecursiveEnvironment pInitialEnvironment) {
            this.current = pInitialEnvironment;
        }

        @Override
        public void clear() {
            this.current = NonRecursiveEnvironment.of();
        }

        @Override
        public boolean containsKey(Object pKey) {
            return this.current.containsKey(pKey);
        }

        @Override
        public boolean containsValue(Object pValue) {
            return this.current.containsValue(pValue);
        }

        @Override
        public Set<Map.Entry<String, InvariantsFormula<CompoundInterval>>> entrySet() {
            return this.current.entrySet();
        }

        @Override
        public InvariantsFormula<CompoundInterval> get(Object pKey) {
            return this.current.get(pKey);
        }

        @Override
        public boolean isEmpty() {
            return this.current.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.current.keySet();
        }

        @Override
        public InvariantsFormula<CompoundInterval> put(String pKey, InvariantsFormula<CompoundInterval> pValue) {
            Object result = this.current.get(pKey);
            this.current = this.current.putAndCopy(pKey, pValue);
            return result;
        }

        @Override
        public void putAll(Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pM) {
            this.current = this.current.putAndCopyAll(pM);
        }

        @Override
        public InvariantsFormula<CompoundInterval> remove(Object pKey) {
            Object result = this.current.get(pKey);
            this.current = this.current.removeAndCopy(pKey);
            return result;
        }

        @Override
        public int size() {
            return this.current.size();
        }

        @Override
        public Collection<InvariantsFormula<CompoundInterval>> values() {
            return this.current.values();
        }

        public NonRecursiveEnvironment build() {
            return this.current;
        }

        public static Builder of(Map<String, InvariantsFormula<CompoundInterval>> pTmpEnvironment) {
            if (pTmpEnvironment instanceof Builder) {
                return (Builder)pTmpEnvironment;
            }
            return new Builder(pTmpEnvironment);
        }
    }
}

