/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

public class SimpleIntervalTest {
    @Test
    public void testConstruction() {
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        Assert.assertNotNull((Object)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction1() {
        SimpleInterval.of(BigInteger.ONE, BigInteger.ZERO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction2() {
        SimpleInterval.of(BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MIN_VALUE));
    }

    public void testContains() {
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.ZERO).contains(BigInteger.ZERO));
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.TEN).contains(BigInteger.TEN));
        Assert.assertFalse((boolean)SimpleInterval.singleton(BigInteger.ZERO).contains(BigInteger.TEN));
        Assert.assertFalse((boolean)SimpleInterval.singleton(BigInteger.TEN).contains(BigInteger.ZERO));
        Assert.assertTrue((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.ONE));
        Assert.assertTrue((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.TEN));
        Assert.assertTrue((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(5L)));
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.ZERO));
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(-5L)));
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(-10L)));
    }

    @Test
    public void testIsSingleton() {
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.ZERO).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton());
        Assert.assertTrue((boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).isSingleton());
        Assert.assertFalse((boolean)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).isSingleton());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.ZERO).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.ZERO).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.ZERO).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size());
        Assert.assertNull((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).size());
        Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).size());
        Assert.assertEquals((Object)BigInteger.TEN, (Object)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).size());
        Assert.assertEquals((Object)BigInteger.valueOf(201L), (Object)SimpleInterval.of(BigInteger.valueOf(-100L), BigInteger.valueOf(100L)).size());
        Assert.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE)).add(BigInteger.ONE), (Object)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).size());
    }

    @Test
    public void testIntersectsWith() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval two = SimpleInterval.singleton(BigInteger.valueOf(2L));
        SimpleInterval negFiveToTen = SimpleInterval.of(BigInteger.valueOf(-5L), BigInteger.TEN);
        SimpleInterval fiveToFifteen = SimpleInterval.of(BigInteger.valueOf(5L), BigInteger.valueOf(15L));
        SimpleInterval twentyToFifty = SimpleInterval.of(BigInteger.valueOf(20L), BigInteger.valueOf(50L));
        SimpleInterval oneToThousand = SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(1000L));
        Assert.assertFalse((boolean)zero.intersectsWith(one));
        Assert.assertFalse((boolean)one.intersectsWith(zero));
        Assert.assertTrue((boolean)zero.intersectsWith(zero));
        Assert.assertTrue((boolean)one.intersectsWith(one));
        Assert.assertTrue((boolean)zero.extendToNegativeInfinity().intersectsWith(zero.extendToPositiveInfinity()));
        Assert.assertTrue((boolean)one.extendToNegativeInfinity().intersectsWith(one.extendToPositiveInfinity()));
        Assert.assertFalse((boolean)zero.extendToNegativeInfinity().intersectsWith(one.extendToPositiveInfinity()));
        Assert.assertFalse((boolean)one.extendToPositiveInfinity().intersectsWith(zero.extendToNegativeInfinity()));
        Assert.assertTrue((boolean)one.extendToNegativeInfinity().intersectsWith(zero.extendToPositiveInfinity()));
        Assert.assertTrue((boolean)zero.extendToPositiveInfinity().intersectsWith(one.extendToNegativeInfinity()));
        Assert.assertTrue((boolean)negFiveToTen.intersectsWith(fiveToFifteen));
        Assert.assertFalse((boolean)negFiveToTen.intersectsWith(twentyToFifty));
        Assert.assertFalse((boolean)fiveToFifteen.intersectsWith(twentyToFifty));
        Assert.assertTrue((boolean)oneToThousand.intersectsWith(two));
    }
}

