/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class VariableNameExtractor {
    private final String functionName;
    private final Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> environment;

    public VariableNameExtractor(CFAEdge pEdge) {
        this(pEdge, false, Collections.emptyMap());
    }

    public VariableNameExtractor(CFAEdge pEdge, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this(pEdge, false, pEnvironment);
    }

    public VariableNameExtractor(CFAEdge pEdge, boolean pUsePredecessorFunctionName, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this(pUsePredecessorFunctionName ? pEdge.getPredecessor() : pEdge.getSuccessor(), pEnvironment);
    }

    private VariableNameExtractor(CFANode pFunctionNode, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this(pFunctionNode.getFunctionName(), pEnvironment);
    }

    public VariableNameExtractor(String pFunctionName, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this.functionName = pFunctionName;
        this.environment = pEnvironment;
    }

    public String getVarName(AExpression pLhs) throws UnrecognizedCodeException {
        if (pLhs instanceof AIdExpression) {
            return this.getVarName((AIdExpression)pLhs);
        }
        if (pLhs instanceof CFieldReference) {
            CFieldReference fieldRef = (CFieldReference)pLhs;
            String varName = fieldRef.getFieldName();
            CExpression owner = fieldRef.getFieldOwner();
            return this.getFieldReferenceVarName(varName, owner, fieldRef.isPointerDereference());
        }
        if (pLhs instanceof JFieldAccess) {
            JFieldAccess fieldRef = (JFieldAccess)pLhs;
            String varName = fieldRef.getName();
            JIdExpression owner = fieldRef.getReferencedVariable();
            return this.getFieldReferenceVarName(varName, owner, false);
        }
        if (pLhs instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression arraySubscript = (CArraySubscriptExpression)pLhs;
            CExpression subscript = arraySubscript.getSubscriptExpression();
            CExpression owner = arraySubscript.getArrayExpression();
            return this.getArraySubscriptVarName(owner, subscript);
        }
        if (pLhs instanceof JArraySubscriptExpression) {
            JArraySubscriptExpression arraySubscript = (JArraySubscriptExpression)pLhs;
            JExpression subscript = arraySubscript.getSubscriptExpression();
            JExpression owner = arraySubscript.getArrayExpression();
            return this.getArraySubscriptVarName(owner, subscript);
        }
        if (pLhs instanceof CPointerExpression) {
            CPointerExpression pe = (CPointerExpression)pLhs;
            if (pe.getOperand() instanceof CLeftHandSide) {
                return String.format("*(%s)", this.getVarName(pe.getOperand()));
            }
            return pLhs.toString();
        }
        if (pLhs instanceof CCastExpression) {
            CCastExpression cast = (CCastExpression)pLhs;
            return this.getVarName(cast.getOperand());
        }
        if (pLhs instanceof JCastExpression) {
            JCastExpression cast = (JCastExpression)pLhs;
            return this.getVarName(cast.getOperand());
        }
        return pLhs.toString();
    }

    private String getVarName(AIdExpression pIdExpression) {
        CSimpleDeclaration decl;
        CIdExpression var = (CIdExpression)pIdExpression;
        String varName = var.getName();
        if (!(var.getDeclaration() == null || (decl = var.getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal() || decl instanceof CEnumType.CEnumerator)) {
            varName = this.scope(varName);
        }
        return varName;
    }

    private String getFieldReferenceVarName(String pVarName, @Nullable AExpression pOwner, boolean pIsPointerDereference) throws UnrecognizedCodeException {
        String varName = pVarName;
        if (pOwner != null) {
            varName = this.getVarName(pOwner) + (pIsPointerDereference ? "->" : ".") + varName;
        }
        return varName;
    }

    private String getArraySubscriptVarName(AExpression pOwner, AExpression pSubscript) throws UnrecognizedCodeException {
        if (pSubscript instanceof CIntegerLiteralExpression) {
            CIntegerLiteralExpression literal = (CIntegerLiteralExpression)pSubscript;
            return String.format("%s[%d]", this.getVarName(pOwner), literal.asLong()).toString();
        }
        ExpressionToFormulaVisitor expressionToFormulaVisitor = new ExpressionToFormulaVisitor(this, this.environment);
        CompoundInterval subscriptValue = pSubscript instanceof CExpression ? this.evaluate(((CExpression)pSubscript).accept(expressionToFormulaVisitor)) : (pSubscript instanceof JExpression ? this.evaluate(((JExpression)pSubscript).accept(expressionToFormulaVisitor)) : CompoundInterval.top());
        if (subscriptValue.isSingleton()) {
            return String.format("%s[%d]", this.getVarName(pOwner), subscriptValue.getValue()).toString();
        }
        return String.format("%s[*]", this.getVarName(pOwner));
    }

    private CompoundInterval evaluate(InvariantsFormula<CompoundInterval> pFormula) {
        return pFormula.accept(new FormulaCompoundStateEvaluationVisitor(), this.environment);
    }

    private String scope(String pVar) {
        return VariableNameExtractor.scope(pVar, this.functionName);
    }

    public static String scope(String pVar, String pFunction) {
        return pFunction + "::" + pVar;
    }

    public boolean isFunctionScoped(String pScopedVariableName) {
        return VariableNameExtractor.isFunctionScoped(pScopedVariableName, this.functionName);
    }

    public static boolean isFunctionScoped(String pScopedVariableName, String pFunction) {
        return pScopedVariableName.startsWith(pFunction + "::");
    }
}

