/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class CollectVarsVisitor<T>
implements InvariantsFormulaVisitor<T, Set<String>> {
    private static final Set<String> EMPTY_SET = Collections.emptySet();

    @Override
    public Set<String> visit(Add<T> pAdd) {
        return this.concat((Set)pAdd.getSummand1().accept(this), (Set)pAdd.getSummand2().accept(this));
    }

    @Override
    public Set<String> visit(BinaryAnd<T> pAnd) {
        return this.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(BinaryNot<T> pNot) {
        return (Set)pNot.getFlipped().accept(this);
    }

    @Override
    public Set<String> visit(BinaryOr<T> pOr) {
        return this.concat((Set)pOr.getOperand1().accept(this), (Set)pOr.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(BinaryXor<T> pXor) {
        return this.concat((Set)pXor.getOperand1().accept(this), (Set)pXor.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(Constant<T> pConstant) {
        return EMPTY_SET;
    }

    @Override
    public Set<String> visit(Divide<T> pDivide) {
        return this.concat((Set)pDivide.getNumerator().accept(this), (Set)pDivide.getDenominator().accept(this));
    }

    @Override
    public Set<String> visit(Equal<T> pEqual) {
        return this.concat((Set)pEqual.getOperand1().accept(this), (Set)pEqual.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(Exclusion<T> pExclusion) {
        return (Set)pExclusion.getExcluded().accept(this);
    }

    @Override
    public Set<String> visit(LessThan<T> pLessThan) {
        return this.concat((Set)pLessThan.getOperand1().accept(this), (Set)pLessThan.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(LogicalAnd<T> pAnd) {
        return this.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(LogicalNot<T> pNot) {
        return (Set)pNot.getNegated().accept(this);
    }

    @Override
    public Set<String> visit(Modulo<T> pModulo) {
        return this.concat((Set)pModulo.getNumerator().accept(this), (Set)pModulo.getDenominator().accept(this));
    }

    @Override
    public Set<String> visit(Multiply<T> pMultiply) {
        return this.concat((Set)pMultiply.getFactor1().accept(this), (Set)pMultiply.getFactor2().accept(this));
    }

    @Override
    public Set<String> visit(ShiftLeft<T> pShiftLeft) {
        return this.concat((Set)pShiftLeft.getShifted().accept(this), (Set)pShiftLeft.getShiftDistance().accept(this));
    }

    @Override
    public Set<String> visit(ShiftRight<T> pShiftRight) {
        return this.concat((Set)pShiftRight.getShifted().accept(this), (Set)pShiftRight.getShiftDistance().accept(this));
    }

    @Override
    public Set<String> visit(Union<T> pUnion) {
        return this.concat((Set)pUnion.getOperand1().accept(this), (Set)pUnion.getOperand2().accept(this));
    }

    @Override
    public Set<String> visit(Variable<T> pVariable) {
        return Collections.singleton(pVariable.getName());
    }

    private Set<String> concat(Set<String> a, Set<String> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        if (a.size() == 1 && b.size() == 1) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(a);
            result.addAll(b);
            return result;
        }
        if (a.size() == 1) {
            b.addAll(a);
            return b;
        }
        if (b.size() == 1) {
            a.addAll(b);
            return a;
        }
        a.addAll(b);
        return a;
    }
}

