/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.FluentIterable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CachingEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsOnlyEnvInfoVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushAssumptionToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitConjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitDisjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public final class CompoundIntervalFormulaManager
extends Enum<CompoundIntervalFormulaManager> {
    public static final /* enum */ CompoundIntervalFormulaManager INSTANCE = new CompoundIntervalFormulaManager();
    private static final FormulaEvaluationVisitor<CompoundInterval> FORMULA_EVALUATION_VISITOR;
    private static final Map<String, InvariantsFormula<CompoundInterval>> EMPTY_ENVIRONMENT;
    private static final CachingEvaluationVisitor<CompoundInterval> CACHING_EVALUATION_VISITOR;
    private static final InvariantsFormula<CompoundInterval> BOTTOM;
    private static final InvariantsFormula<CompoundInterval> TOP;
    private static final InvariantsFormula<CompoundInterval> FALSE;
    private static final InvariantsFormula<CompoundInterval> TRUE;
    private static final InvariantsFormula<CompoundInterval> MINUS_ONE;
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR;
    private static final ContainsOnlyEnvInfoVisitor<CompoundInterval> CONTAINS_ONLY_ENV_INFO_VISITOR;
    private static final SplitConjunctionsVisitor<CompoundInterval> SPLIT_CONJUNCTIONS_VISITOR;
    private static final SplitDisjunctionsVisitor<CompoundInterval> SPLIT_DISJUNCTIONS_VISITOR;
    private static final /* synthetic */ CompoundIntervalFormulaManager[] $VALUES;

    public static CompoundIntervalFormulaManager[] values() {
        return (CompoundIntervalFormulaManager[])$VALUES.clone();
    }

    public static CompoundIntervalFormulaManager valueOf(String name) {
        return Enum.valueOf(CompoundIntervalFormulaManager.class, name);
    }

    public static Set<String> collectVariableNames(InvariantsFormula<CompoundInterval> pFormula) {
        return (Set)pFormula.accept(COLLECT_VARS_VISITOR);
    }

    public static CompoundInterval evaluate(InvariantsFormula<CompoundInterval> pFormula) {
        return (CompoundInterval)pFormula.accept(CACHING_EVALUATION_VISITOR);
    }

    public static boolean isDefinitelyTrue(InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.evaluate(pFormula).isDefinitelyTrue();
    }

    public static boolean isDefinitelyFalse(InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.evaluate(pFormula).isDefinitelyFalse();
    }

    public static boolean isDefinitelyBottom(InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.evaluate(pFormula).isBottom();
    }

    public static boolean isDefinitelyTop(InvariantsFormula<CompoundInterval> pFormula) {
        return pFormula instanceof Constant && ((CompoundInterval)((Constant)pFormula).getValue()).isTop();
    }

    public static boolean definitelyImplies(Iterable<InvariantsFormula<CompoundInterval>> pFormulas, InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.definitelyImplies(pFormulas, pFormula, new HashMap<String, InvariantsFormula<CompoundInterval>>());
    }

    public static boolean definitelyImplies(Iterable<InvariantsFormula<CompoundInterval>> pFormulas, InvariantsFormula<CompoundInterval> pFormula, Map<String, InvariantsFormula<CompoundInterval>> pBaseEnvironment) {
        HashMap<String, InvariantsFormula<CompoundInterval>> newMap = new HashMap<String, InvariantsFormula<CompoundInterval>>(pBaseEnvironment);
        if (pFormula instanceof Collection) {
            return CompoundIntervalFormulaManager.definitelyImplies((Collection)pFormulas, pFormula, true, newMap, false);
        }
        return CompoundIntervalFormulaManager.definitelyImplies((Collection<InvariantsFormula<CompoundInterval>>)FluentIterable.from(pFormulas).toSet(), pFormula, true, newMap, false);
    }

    private static boolean definitelyImplies(Collection<InvariantsFormula<CompoundInterval>> pInformationBaseFormulas, InvariantsFormula<CompoundInterval> pFormula, boolean pExtend, Map<String, InvariantsFormula<CompoundInterval>> pInformationBaseEnvironment, boolean pEnvironmentComplete) {
        Collection<InvariantsFormula<CompoundInterval>> formulas;
        if (pExtend) {
            formulas = new HashSet<InvariantsFormula<CompoundInterval>>();
            for (InvariantsFormula<CompoundInterval> formula : pInformationBaseFormulas) {
                formulas.addAll((Collection)formula.accept(SPLIT_CONJUNCTIONS_VISITOR));
            }
        } else {
            formulas = pInformationBaseFormulas;
        }
        for (InvariantsFormula<CompoundInterval> formula : formulas) {
            Collection disjunctions = (Collection)formula.accept(SPLIT_DISJUNCTIONS_VISITOR);
            if (disjunctions.size() <= 1) continue;
            ArrayList<InvariantsFormula<CompoundInterval>> newFormulas = new ArrayList<InvariantsFormula<CompoundInterval>>(formulas);
            HashMap<String, InvariantsFormula<CompoundInterval>> newBaseEnvironment = new HashMap<String, InvariantsFormula<CompoundInterval>>(pInformationBaseEnvironment);
            newFormulas.remove(formula);
            for (InvariantsFormula disjunctivePart : disjunctions) {
                Collection conjunctivePartsOfDisjunctivePart = (Collection)disjunctivePart.accept(SPLIT_CONJUNCTIONS_VISITOR);
                newFormulas.addAll(conjunctivePartsOfDisjunctivePart);
                if (!CompoundIntervalFormulaManager.definitelyImplies(newFormulas, pFormula, false, newBaseEnvironment, false)) {
                    return false;
                }
                newFormulas.removeAll(conjunctivePartsOfDisjunctivePart);
            }
            return true;
        }
        NonRecursiveEnvironment.Builder tmpEnvironment = NonRecursiveEnvironment.Builder.of(pInformationBaseEnvironment);
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(FORMULA_EVALUATION_VISITOR, tmpEnvironment);
        if (!pEnvironmentComplete) {
            for (InvariantsFormula<CompoundInterval> leftFormula : formulas) {
                if (leftFormula.accept(patev, CompoundInterval.logicalTrue()).booleanValue()) continue;
                return false;
            }
        }
        return CompoundIntervalFormulaManager.definitelyImplies(formulas, tmpEnvironment, pFormula);
    }

    public static boolean definitelyImplies(Map<String, InvariantsFormula<CompoundInterval>> pCompleteEnvironment, InvariantsFormula<CompoundInterval> pFormula) {
        return CompoundIntervalFormulaManager.definitelyImplies(Collections.emptyList(), pCompleteEnvironment, pFormula);
    }

    private static boolean definitelyImplies(Collection<InvariantsFormula<CompoundInterval>> pExtendedFormulas, Map<String, InvariantsFormula<CompoundInterval>> pCompleteEnvironment, InvariantsFormula<CompoundInterval> pFormula) {
        NonRecursiveEnvironment.Builder tmpEnvironment2 = new NonRecursiveEnvironment.Builder();
        CachingEvaluationVisitor<CompoundInterval> cachingEvaluationVisitor = new CachingEvaluationVisitor<CompoundInterval>(pCompleteEnvironment, FORMULA_EVALUATION_VISITOR);
        block0: for (InvariantsFormula formula2Part : (List)pFormula.accept(SPLIT_CONJUNCTIONS_VISITOR)) {
            if (pExtendedFormulas.contains(formula2Part)) continue;
            Collection disjunctions = (Collection)formula2Part.accept(SPLIT_DISJUNCTIONS_VISITOR);
            if (disjunctions.size() > 1) {
                for (InvariantsFormula disjunctionPart : disjunctions) {
                    if (!CompoundIntervalFormulaManager.definitelyImplies(pExtendedFormulas, disjunctionPart, false, pCompleteEnvironment, true)) continue;
                    continue block0;
                }
            }
            if (((CompoundInterval)pFormula.accept(FORMULA_EVALUATION_VISITOR, pCompleteEnvironment)).isDefinitelyTrue()) continue;
            if (!pCompleteEnvironment.isEmpty() && ((Boolean)formula2Part.accept(CONTAINS_ONLY_ENV_INFO_VISITOR)).booleanValue()) {
                tmpEnvironment2.clear();
                Set varNames = (Set)formula2Part.accept(COLLECT_VARS_VISITOR);
                if (!pCompleteEnvironment.keySet().containsAll(varNames)) {
                    return false;
                }
                PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(FORMULA_EVALUATION_VISITOR, tmpEnvironment2);
                formula2Part.accept(patev, CompoundInterval.logicalTrue());
                for (String varName : varNames) {
                    CompoundInterval rightValue;
                    InvariantsFormula<CompoundInterval> leftFormula = pCompleteEnvironment.get(varName);
                    Object rightFormula = tmpEnvironment2.get(varName);
                    CompoundInterval leftValue = leftFormula == null ? CompoundInterval.top() : (CompoundInterval)leftFormula.accept(cachingEvaluationVisitor);
                    CompoundInterval compoundInterval = rightValue = rightFormula == null ? CompoundInterval.top() : (CompoundInterval)rightFormula.accept(FORMULA_EVALUATION_VISITOR, tmpEnvironment2);
                    if (!rightValue.isTop() && rightValue.contains(leftValue)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean definitelyImplies(InvariantsFormula<CompoundInterval> pFormula1, InvariantsFormula<CompoundInterval> pFormula2) {
        if (CompoundIntervalFormulaManager.isDefinitelyFalse(pFormula1) || pFormula1.equals(pFormula2)) {
            return true;
        }
        if (pFormula1 instanceof Equal && pFormula2 instanceof Equal) {
            Equal p1 = (Equal)pFormula1;
            Equal p2 = (Equal)pFormula2;
            Variable var = null;
            CompoundInterval value = null;
            if (p1.getOperand1() instanceof Variable && p1.getOperand2() instanceof Constant) {
                var = (Variable)p1.getOperand1();
                value = (CompoundInterval)((Constant)p1.getOperand2()).getValue();
            } else if (p1.getOperand2() instanceof Variable && p1.getOperand1() instanceof Constant) {
                var = (Variable)p1.getOperand2();
                value = (CompoundInterval)((Constant)p1.getOperand1()).getValue();
            }
            if (var != null && value != null) {
                CompoundInterval newValue = null;
                if (var.equals(p2.getOperand1()) && p2.getOperand2() instanceof Constant) {
                    newValue = (CompoundInterval)((Constant)p2.getOperand2()).getValue();
                } else if (var.equals(p2.getOperand2()) && p2.getOperand1() instanceof Constant) {
                    newValue = (CompoundInterval)((Constant)p2.getOperand1()).getValue();
                }
                if (newValue != null) {
                    return newValue.contains(value);
                }
            }
        }
        Collection leftFormulas = (Collection)pFormula1.accept(SPLIT_CONJUNCTIONS_VISITOR);
        return CompoundIntervalFormulaManager.definitelyImplies(leftFormulas, pFormula2, false, new HashMap<String, InvariantsFormula<CompoundInterval>>(), false);
    }

    public InvariantsFormula<CompoundInterval> add(InvariantsFormula<CompoundInterval> pSummand1, InvariantsFormula<CompoundInterval> pSummand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pSummand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pSummand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pSummand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pSummand2)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.add(pSummand1, pSummand2);
    }

    public InvariantsFormula<CompoundInterval> binaryAnd(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        HashSet<InvariantsFormula> uniqueOperands = new HashSet<InvariantsFormula>();
        ArrayDeque unprocessedOperands = new ArrayDeque();
        unprocessedOperands.offer(pOperand1);
        unprocessedOperands.offer(pOperand2);
        while (!unprocessedOperands.isEmpty()) {
            InvariantsFormula unprocessedOperand = (InvariantsFormula)unprocessedOperands.poll();
            if (unprocessedOperand instanceof BinaryAnd) {
                BinaryAnd and = (BinaryAnd)unprocessedOperand;
                unprocessedOperands.offer(and.getOperand1());
                unprocessedOperands.offer(and.getOperand2());
                continue;
            }
            uniqueOperands.add(unprocessedOperand);
        }
        assert (!uniqueOperands.isEmpty());
        Iterator operandsIterator = uniqueOperands.iterator();
        InvariantsFormula result = (InvariantsFormula)operandsIterator.next();
        while (operandsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.binaryOr(result, (InvariantsFormula)operandsIterator.next());
        }
        return InvariantsFormulaManager.INSTANCE.binaryAnd(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> binaryNot(InvariantsFormula<CompoundInterval> pToFlip) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pToFlip)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pToFlip)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.binaryNot(pToFlip);
    }

    public InvariantsFormula<CompoundInterval> binaryOr(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        HashSet<InvariantsFormula> uniqueOperands = new HashSet<InvariantsFormula>();
        ArrayDeque unprocessedOperands = new ArrayDeque();
        unprocessedOperands.offer(pOperand1);
        unprocessedOperands.offer(pOperand2);
        while (!unprocessedOperands.isEmpty()) {
            InvariantsFormula unprocessedOperand = (InvariantsFormula)unprocessedOperands.poll();
            if (unprocessedOperand instanceof BinaryOr) {
                BinaryOr or = (BinaryOr)unprocessedOperand;
                unprocessedOperands.offer(or.getOperand1());
                unprocessedOperands.offer(or.getOperand2());
                continue;
            }
            uniqueOperands.add(unprocessedOperand);
        }
        assert (!uniqueOperands.isEmpty());
        Iterator operandsIterator = uniqueOperands.iterator();
        InvariantsFormula result = (InvariantsFormula)operandsIterator.next();
        while (operandsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.binaryOr(result, (InvariantsFormula)operandsIterator.next());
        }
        return result;
    }

    public InvariantsFormula<CompoundInterval> binaryXor(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.binaryXor(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> asConstant(CompoundInterval pValue) {
        if (pValue.isTop()) {
            return TOP;
        }
        if (pValue.isBottom()) {
            return BOTTOM;
        }
        if (pValue.equals(CompoundInterval.logicalTrue())) {
            return TRUE;
        }
        if (pValue.equals(CompoundInterval.logicalFalse())) {
            return FALSE;
        }
        return InvariantsFormulaManager.INSTANCE.asConstant(pValue);
    }

    public InvariantsFormula<CompoundInterval> divide(InvariantsFormula<CompoundInterval> pNumerator, InvariantsFormula<CompoundInterval> pDenominator) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pNumerator) || CompoundIntervalFormulaManager.isDefinitelyBottom(pDenominator)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pNumerator) || CompoundIntervalFormulaManager.isDefinitelyTop(pDenominator)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.divide(pNumerator, pDenominator);
    }

    public InvariantsFormula<CompoundInterval> equal(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.equal(union.getOperand1(), pOperand2), this.equal(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.equal(pOperand1, union.getOperand1()), this.equal(pOperand1, union.getOperand2()));
        }
        return InvariantsFormulaManager.INSTANCE.equal(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> greaterThan(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        return this.lessThan(pOperand2, pOperand1);
    }

    public InvariantsFormula<CompoundInterval> greaterThanOrEqual(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        return this.lessThanOrEqual(pOperand2, pOperand1);
    }

    public InvariantsFormula<CompoundInterval> lessThan(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.lessThan(union.getOperand1(), pOperand2), this.lessThan(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.lessThan(pOperand1, union.getOperand1()), this.lessThan(pOperand1, union.getOperand2()));
        }
        return InvariantsFormulaManager.INSTANCE.lessThan(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> lessThanOrEqual(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.lessThanOrEqual(union.getOperand1(), pOperand2), this.lessThanOrEqual(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.lessThanOrEqual(pOperand1, union.getOperand1()), this.lessThanOrEqual(pOperand1, union.getOperand2()));
        }
        return InvariantsFormulaManager.INSTANCE.lessThanOrEqual(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> logicalAnd(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyFalse(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyFalse(pOperand2)) {
            return FALSE;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTrue(pOperand1)) {
            return pOperand2;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTrue(pOperand2)) {
            return pOperand1;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) && CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        NonRecursiveEnvironment.Builder tmpEnvironment = new NonRecursiveEnvironment.Builder();
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(FORMULA_EVALUATION_VISITOR, tmpEnvironment);
        if (!pOperand1.accept(patev, CompoundInterval.logicalTrue()).booleanValue()) {
            return FALSE;
        }
        if (!pOperand2.accept(patev, CompoundInterval.logicalTrue()).booleanValue()) {
            return FALSE;
        }
        if (CompoundIntervalFormulaManager.definitelyImplies(pOperand1, pOperand2)) {
            return pOperand1;
        }
        if (CompoundIntervalFormulaManager.definitelyImplies(pOperand2, pOperand1)) {
            return pOperand2;
        }
        if (pOperand1 instanceof Equal && pOperand2 instanceof Equal) {
            Equal p1 = (Equal)pOperand1;
            Equal p2 = (Equal)pOperand2;
            Variable var = null;
            CompoundInterval value = null;
            if (p1.getOperand1() instanceof Variable && p1.getOperand2() instanceof Constant) {
                var = (Variable)p1.getOperand1();
                value = (CompoundInterval)((Constant)p1.getOperand2()).getValue();
            } else if (p1.getOperand2() instanceof Variable && p1.getOperand1() instanceof Constant) {
                var = (Variable)p1.getOperand2();
                value = (CompoundInterval)((Constant)p1.getOperand1()).getValue();
            }
            if (var != null && value != null) {
                CompoundInterval newValue = null;
                if (var.equals(p2.getOperand1()) && p2.getOperand2() instanceof Constant) {
                    newValue = value.intersectWith((CompoundInterval)((Constant)p2.getOperand2()).getValue());
                } else if (var.equals(p2.getOperand2()) && p2.getOperand1() instanceof Constant) {
                    newValue = value.intersectWith((CompoundInterval)((Constant)p2.getOperand1()).getValue());
                }
                if (newValue != null) {
                    if (newValue.isTop()) {
                        return TRUE;
                    }
                    if (newValue.isBottom()) {
                        return FALSE;
                    }
                    return this.equal(var, this.asConstant(newValue));
                }
            }
        }
        return LogicalAnd.of(pOperand1, pOperand2);
    }

    public InvariantsFormula<CompoundInterval> logicalNot(InvariantsFormula<CompoundInterval> pToNegate) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pToNegate)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pToNegate)) {
            return TOP;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyFalse(pToNegate)) {
            return TRUE;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTrue(pToNegate)) {
            return FALSE;
        }
        if (pToNegate instanceof LogicalNot) {
            return ((LogicalNot)pToNegate).getNegated();
        }
        return InvariantsFormulaManager.INSTANCE.logicalNot(pToNegate);
    }

    public InvariantsFormula<CompoundInterval> logicalOr(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyTrue(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTrue(pOperand2)) {
            return TRUE;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyFalse(pOperand1)) {
            return pOperand2;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyFalse(pOperand2)) {
            return pOperand1;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) && CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        if (CompoundIntervalFormulaManager.definitelyImplies(pOperand1, pOperand2)) {
            return pOperand2;
        }
        if (CompoundIntervalFormulaManager.definitelyImplies(pOperand2, pOperand1)) {
            return pOperand1;
        }
        if (pOperand1 instanceof Equal && pOperand2 instanceof Equal) {
            Equal p1 = (Equal)pOperand1;
            Equal p2 = (Equal)pOperand2;
            Variable var = null;
            InvariantsFormula<CompoundInterval> value = null;
            if (p1.getOperand1() instanceof Variable) {
                var = (Variable)p1.getOperand1();
                value = p1.getOperand2();
            } else if (p1.getOperand2() instanceof Variable) {
                var = (Variable)p1.getOperand2();
                value = p1.getOperand1();
            }
            if (var != null && value != null) {
                InvariantsFormula<CompoundInterval> newValue = null;
                InvariantsFormula otherValue = null;
                if (var.equals(p2.getOperand1())) {
                    otherValue = p2.getOperand2();
                } else if (var.equals(p2.getOperand2())) {
                    otherValue = p2.getOperand1();
                }
                if (otherValue != null) {
                    newValue = INSTANCE.union(value, p2.getOperand2());
                    CompoundInterval val = CompoundIntervalFormulaManager.evaluate(newValue = newValue.accept(new PartialEvaluator(), FORMULA_EVALUATION_VISITOR));
                    if (val.isTop() && newValue instanceof Constant) {
                        return TRUE;
                    }
                    if (val.isBottom()) {
                        return FALSE;
                    }
                    boolean useNewValue = true;
                    if (newValue instanceof Union) {
                        Union union = (Union)newValue;
                        InvariantsFormula op1 = union.getOperand1();
                        InvariantsFormula op2 = union.getOperand2();
                        boolean bl = useNewValue = !(op1.equals(value) && op2.equals(otherValue) || op1.equals(otherValue) && op2.equals(value));
                    }
                    if (useNewValue) {
                        return this.equal(var, newValue);
                    }
                }
            }
        }
        return this.logicalNot(this.logicalAnd(this.logicalNot(pOperand1), this.logicalNot(pOperand2)));
    }

    public InvariantsFormula<CompoundInterval> logicalImplies(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.definitelyImplies(pOperand1, pOperand2)) {
            return TRUE;
        }
        return this.logicalNot(this.logicalAnd(pOperand1, this.logicalNot(pOperand2)));
    }

    public InvariantsFormula<CompoundInterval> modulo(InvariantsFormula<CompoundInterval> pNumerator, InvariantsFormula<CompoundInterval> pDenominator) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pNumerator) || CompoundIntervalFormulaManager.isDefinitelyBottom(pDenominator)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pNumerator) || CompoundIntervalFormulaManager.isDefinitelyTop(pDenominator)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.modulo(pNumerator, pDenominator);
    }

    public InvariantsFormula<CompoundInterval> multiply(InvariantsFormula<CompoundInterval> pFactor1, InvariantsFormula<CompoundInterval> pFactor2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pFactor1) || CompoundIntervalFormulaManager.isDefinitelyBottom(pFactor2)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pFactor1) || CompoundIntervalFormulaManager.isDefinitelyTop(pFactor2)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.multiply(pFactor1, pFactor2);
    }

    public InvariantsFormula<CompoundInterval> negate(InvariantsFormula<CompoundInterval> pToNegate) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pToNegate)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pToNegate)) {
            return TOP;
        }
        if (pToNegate instanceof Multiply) {
            InvariantsFormula<CompoundInterval> factor1 = ((Multiply)pToNegate).getFactor1();
            InvariantsFormula<CompoundInterval> factor2 = ((Multiply)pToNegate).getFactor2();
            if (factor1.equals(MINUS_ONE)) {
                return factor2;
            }
            if (factor2.equals(MINUS_ONE)) {
                return factor1;
            }
        }
        return InvariantsFormulaManager.INSTANCE.multiply(pToNegate, MINUS_ONE);
    }

    public InvariantsFormula<CompoundInterval> subtract(InvariantsFormula<CompoundInterval> pMinuend, InvariantsFormula<CompoundInterval> pSubtrahend) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pMinuend) || CompoundIntervalFormulaManager.isDefinitelyBottom(pSubtrahend)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pMinuend) || CompoundIntervalFormulaManager.isDefinitelyTop(pSubtrahend)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.add(pMinuend, this.negate(pSubtrahend));
    }

    public InvariantsFormula<CompoundInterval> shiftLeft(InvariantsFormula<CompoundInterval> pToShift, InvariantsFormula<CompoundInterval> pShiftDistance) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pToShift) || CompoundIntervalFormulaManager.isDefinitelyBottom(pShiftDistance)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pToShift) || CompoundIntervalFormulaManager.isDefinitelyTop(pShiftDistance)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.shiftLeft(pToShift, pShiftDistance);
    }

    public InvariantsFormula<CompoundInterval> shiftRight(InvariantsFormula<CompoundInterval> pToShift, InvariantsFormula<CompoundInterval> pShiftDistance) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pToShift) || CompoundIntervalFormulaManager.isDefinitelyBottom(pShiftDistance)) {
            return BOTTOM;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pToShift) || CompoundIntervalFormulaManager.isDefinitelyTop(pShiftDistance)) {
            return TOP;
        }
        return InvariantsFormulaManager.INSTANCE.shiftRight(pToShift, pShiftDistance);
    }

    public InvariantsFormula<CompoundInterval> union(InvariantsFormula<CompoundInterval> pOperand1, InvariantsFormula<CompoundInterval> pOperand2) {
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand1)) {
            if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
                return BOTTOM;
            }
            return pOperand2;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyBottom(pOperand2)) {
            return pOperand1;
        }
        if (CompoundIntervalFormulaManager.isDefinitelyTop(pOperand1) || CompoundIntervalFormulaManager.isDefinitelyTop(pOperand2)) {
            return TOP;
        }
        if (pOperand1.equals(pOperand2)) {
            return pOperand1;
        }
        HashSet<InvariantsFormula<CompoundInterval>> atomicUnionParts = new HashSet<InvariantsFormula<CompoundInterval>>();
        ArrayDeque unionParts = new ArrayDeque();
        CompoundInterval constantPart = CompoundInterval.bottom();
        unionParts.offer(pOperand1);
        unionParts.offer(pOperand2);
        while (!unionParts.isEmpty()) {
            InvariantsFormula currentPart = (InvariantsFormula)unionParts.poll();
            if (currentPart instanceof Union) {
                Union currentUnion = (Union)currentPart;
                unionParts.add(currentUnion.getOperand1());
                unionParts.add(currentUnion.getOperand2());
                continue;
            }
            if (currentPart instanceof Constant) {
                constantPart = constantPart.unionWith((CompoundInterval)((Constant)currentPart).getValue());
                continue;
            }
            atomicUnionParts.add(currentPart);
        }
        return this.unionAll(constantPart, atomicUnionParts);
    }

    private InvariantsFormula<CompoundInterval> unionAll(CompoundInterval pConstantPart, Collection<InvariantsFormula<CompoundInterval>> pFormulas) {
        if (pFormulas.isEmpty() || pConstantPart.isTop()) {
            return this.asConstant(pConstantPart);
        }
        InvariantsFormula<CompoundInterval> result = null;
        Iterator<InvariantsFormula<CompoundInterval>> atomicUnionPartsIterator = pFormulas.iterator();
        result = atomicUnionPartsIterator.next();
        while (atomicUnionPartsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.union(result, atomicUnionPartsIterator.next());
        }
        if (!pConstantPart.isBottom()) {
            InvariantsFormula<CompoundInterval> constantPartFormula = this.asConstant(pConstantPart);
            result = InvariantsFormulaManager.INSTANCE.union(result, constantPartFormula);
        }
        return result;
    }

    public Variable<CompoundInterval> asVariable(String pName) {
        return InvariantsFormulaManager.INSTANCE.asVariable(pName);
    }

    public InvariantsFormula<CompoundInterval> exclude(InvariantsFormula<CompoundInterval> pToExclude) {
        Constant c;
        if (pToExclude instanceof Constant && ((CompoundInterval)(c = (Constant)pToExclude).getValue()).isSingleton()) {
            return this.asConstant(((CompoundInterval)c.getValue()).invert());
        }
        return InvariantsFormulaManager.INSTANCE.exclude(pToExclude);
    }

    static {
        $VALUES = new CompoundIntervalFormulaManager[]{INSTANCE};
        FORMULA_EVALUATION_VISITOR = new FormulaCompoundStateEvaluationVisitor();
        EMPTY_ENVIRONMENT = Collections.emptyMap();
        CACHING_EVALUATION_VISITOR = new CachingEvaluationVisitor<CompoundInterval>(EMPTY_ENVIRONMENT, FORMULA_EVALUATION_VISITOR);
        BOTTOM = InvariantsFormulaManager.INSTANCE.asConstant(CompoundInterval.bottom());
        TOP = InvariantsFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
        FALSE = InvariantsFormulaManager.INSTANCE.asConstant(CompoundInterval.logicalFalse());
        TRUE = InvariantsFormulaManager.INSTANCE.asConstant(CompoundInterval.logicalTrue());
        MINUS_ONE = InvariantsFormulaManager.INSTANCE.asConstant(CompoundInterval.minusOne());
        COLLECT_VARS_VISITOR = new CollectVarsVisitor();
        CONTAINS_ONLY_ENV_INFO_VISITOR = new ContainsOnlyEnvInfoVisitor();
        SPLIT_CONJUNCTIONS_VISITOR = new SplitConjunctionsVisitor();
        SPLIT_DISJUNCTIONS_VISITOR = new SplitDisjunctionsVisitor();
    }
}

