/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedInvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class ContainsVarVisitor<T>
implements ParameterizedInvariantsFormulaVisitor<T, String, Boolean> {
    private final Map<? extends String, ? extends InvariantsFormula<T>> environment;

    public ContainsVarVisitor() {
        this(null);
    }

    public ContainsVarVisitor(Map<? extends String, ? extends InvariantsFormula<T>> pEnvironment) {
        this.environment = pEnvironment;
    }

    @Override
    public Boolean visit(Add<T> pAdd, String pVarName) {
        return (Boolean)pAdd.getSummand1().accept(this, pVarName) != false || (Boolean)pAdd.getSummand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryAnd<T> pAnd, String pVarName) {
        return (Boolean)pAnd.getOperand1().accept(this, pVarName) != false || (Boolean)pAnd.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryNot<T> pNot, String pVarName) {
        return (Boolean)pNot.getFlipped().accept(this, pVarName);
    }

    @Override
    public Boolean visit(BinaryOr<T> pOr, String pVarName) {
        return (Boolean)pOr.getOperand1().accept(this, pVarName) != false || (Boolean)pOr.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryXor<T> pXor, String pVarName) {
        return (Boolean)pXor.getOperand1().accept(this, pVarName) != false || (Boolean)pXor.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Constant<T> pConstant, String pVarName) {
        return false;
    }

    @Override
    public Boolean visit(Divide<T> pDivide, String pVarName) {
        return (Boolean)pDivide.getNumerator().accept(this, pVarName) != false || (Boolean)pDivide.getDenominator().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Equal<T> pEqual, String pVarName) {
        return (Boolean)pEqual.getOperand1().accept(this, pVarName) != false || (Boolean)pEqual.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Exclusion<T> pExclusion, String pParameter) {
        return (Boolean)pExclusion.getExcluded().accept(this, pParameter);
    }

    @Override
    public Boolean visit(LessThan<T> pLessThan, String pVarName) {
        return (Boolean)pLessThan.getOperand1().accept(this, pVarName) != false || (Boolean)pLessThan.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(LogicalAnd<T> pAnd, String pVarName) {
        return (Boolean)pAnd.getOperand1().accept(this, pVarName) != false || (Boolean)pAnd.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(LogicalNot<T> pNot, String pVarName) {
        return (Boolean)pNot.getNegated().accept(this, pVarName);
    }

    @Override
    public Boolean visit(Modulo<T> pModulo, String pVarName) {
        return (Boolean)pModulo.getNumerator().accept(this, pVarName) != false || (Boolean)pModulo.getDenominator().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Multiply<T> pMultiply, String pVarName) {
        return (Boolean)pMultiply.getFactor1().accept(this, pVarName) != false || (Boolean)pMultiply.getFactor2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(ShiftLeft<T> pShiftLeft, String pVarName) {
        return (Boolean)pShiftLeft.getShifted().accept(this, pVarName) != false || (Boolean)pShiftLeft.getShiftDistance().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(ShiftRight<T> pShiftRight, String pVarName) {
        return (Boolean)pShiftRight.getShifted().accept(this, pVarName) != false || (Boolean)pShiftRight.getShiftDistance().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Union<T> pUnion, String pVarName) {
        return (Boolean)pUnion.getOperand1().accept(this, pVarName) != false || (Boolean)pUnion.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Variable<T> pVariable, String pVarName) {
        return pVariable.getName().equals(pVarName) || this.refersTo(pVariable, pVarName);
    }

    private boolean refersTo(Variable<T> pVariable, String pVarName) {
        if (this.environment == null) {
            return false;
        }
        InvariantsFormula<T> value = this.environment.get(pVariable.getName());
        if (value == null) {
            return false;
        }
        return (Boolean)value.accept(this, pVarName);
    }
}

