/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class FormulaAbstractionVisitor
extends DefaultParameterizedFormulaVisitor<CompoundInterval, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>>, CompoundInterval>
implements FormulaEvaluationVisitor<CompoundInterval> {
    private static final FormulaCompoundStateEvaluationVisitor EVALUATION_VISITOR = new FormulaCompoundStateEvaluationVisitor();

    private static CompoundInterval abstractionOf(CompoundInterval pValue) {
        if (pValue.isBottom() || pValue.isTop()) {
            return pValue;
        }
        CompoundInterval result = pValue.signum();
        boolean extendToNeg = false;
        if (!pValue.lessThan(result).isDefinitelyFalse()) {
            extendToNeg = true;
        }
        if (!pValue.greaterThan(result).isDefinitelyFalse()) {
            result = result.extendToPositiveInfinity();
        }
        if (extendToNeg) {
            result = result.extendToNegativeInfinity();
        }
        assert (result.unionWith(pValue).equals(result));
        return result;
    }

    private CompoundInterval weakAdd(CompoundInterval pA, CompoundInterval pB) {
        if (pA.isSingleton() && pA.containsZero()) {
            return pB;
        }
        if (pB.isSingleton() && pB.containsZero()) {
            return pA;
        }
        return FormulaAbstractionVisitor.abstractionOf(pA.add(pB));
    }

    private CompoundInterval weakMultiply(CompoundInterval a, CompoundInterval b) {
        if (a.isSingleton() && a.containsZero()) {
            return a;
        }
        if (b.isSingleton() && b.containsZero()) {
            return b;
        }
        if (a.isSingleton() && a.contains(1L)) {
            return b;
        }
        if (b.isSingleton() && b.contains(1L)) {
            return a;
        }
        if (a.isSingleton() && a.contains(BigInteger.ONE.negate())) {
            return b.negate();
        }
        if (b.isSingleton() && b.contains(BigInteger.ONE.negate())) {
            return a.negate();
        }
        return FormulaAbstractionVisitor.abstractionOf(a.multiply(b));
    }

    @Override
    public CompoundInterval visit(Add<CompoundInterval> pAdd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.weakAdd(pAdd.getSummand1().accept(EVALUATION_VISITOR, pEnvironment), pAdd.getSummand2().accept(EVALUATION_VISITOR, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Constant<CompoundInterval> pConstant, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pConstant.getValue();
    }

    @Override
    public CompoundInterval visit(Multiply<CompoundInterval> pMultiply, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.weakMultiply(pMultiply.getFactor1().accept(this, pEnvironment), pMultiply.getFactor2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval toShift = pShiftLeft.getShifted().accept(this, pEnvironment);
        CompoundInterval shiftDistance = pShiftLeft.getShiftDistance().accept(this, pEnvironment);
        CompoundInterval evaluation = toShift.shiftLeft(shiftDistance);
        if (!shiftDistance.containsPositive()) {
            return evaluation;
        }
        return FormulaAbstractionVisitor.abstractionOf(evaluation);
    }

    @Override
    public CompoundInterval visit(Variable<CompoundInterval> pVariable, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        InvariantsFormula<CompoundInterval> varState = pEnvironment.get(pVariable.getName());
        if (varState == null) {
            return CompoundInterval.top();
        }
        return varState.accept(this, pEnvironment);
    }

    @Override
    protected CompoundInterval visitDefault(InvariantsFormula<CompoundInterval> pFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pParam) {
        return FormulaAbstractionVisitor.abstractionOf(pFormula.accept(EVALUATION_VISITOR, pParam));
    }
}

