/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IsBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class FormulaCompoundStateEvaluationVisitor
implements FormulaEvaluationVisitor<CompoundInterval> {
    private static final IsBooleanFormulaVisitor<CompoundInterval> IS_BOOLEAN_FORMULA_VISITOR = new IsBooleanFormulaVisitor();

    @Override
    public CompoundInterval visit(Add<CompoundInterval> pAdd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pAdd.getSummand1().accept(this, pEnvironment).add(pAdd.getSummand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pAnd.getOperand1().accept(this, pEnvironment).binaryAnd(pAnd.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pNot.getFlipped().accept(this, pEnvironment).binaryNot();
    }

    @Override
    public CompoundInterval visit(BinaryOr<CompoundInterval> pOr, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pOr.getOperand1().accept(this, pEnvironment).binaryOr(pOr.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryXor<CompoundInterval> pXor, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pXor.getOperand1().accept(this, pEnvironment).binaryXor(pXor.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Constant<CompoundInterval> pConstant, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pConstant.getValue();
    }

    @Override
    public CompoundInterval visit(Divide<CompoundInterval> pDivide, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pDivide.getNumerator().accept(this, pEnvironment).divide(pDivide.getDenominator().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Equal<CompoundInterval> pEqual, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval result;
        CompoundInterval operand1 = pEqual.getOperand1().accept(this, pEnvironment);
        CompoundInterval operand2 = pEqual.getOperand2().accept(this, pEnvironment);
        if (((Boolean)pEqual.getOperand1().accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue() && ((Boolean)pEqual.getOperand2().accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue() && (operand1.isDefinitelyTrue() || operand1.isDefinitelyFalse())) {
            if (operand2.isDefinitelyTrue()) {
                return operand1;
            }
            if (operand2.isDefinitelyFalse()) {
                return operand2;
            }
        }
        if ((result = operand1.logicalEquals(operand2)).isTop()) {
            Exclusion exclusion;
            InvariantsFormula<CompoundInterval> value;
            Variable var;
            if (pEqual.getOperand1() instanceof Variable) {
                var = (Variable)pEqual.getOperand1();
                value = pEnvironment.get(var.getName());
                while (value != null) {
                    if (value.equals(pEqual.getOperand2())) {
                        return CompoundInterval.logicalTrue();
                    }
                    if (value instanceof Exclusion && (exclusion = (Exclusion)value).getExcluded().equals(pEqual.getOperand2())) {
                        return CompoundInterval.logicalFalse();
                    }
                    if (value instanceof Variable) {
                        var = (Variable)value;
                        value = pEnvironment.get(var.getName());
                        continue;
                    }
                    value = null;
                }
            }
            if (pEqual.getOperand2() instanceof Variable) {
                var = (Variable)pEqual.getOperand2();
                value = pEnvironment.get(var.getName());
                while (value != null) {
                    if (value.equals(pEqual.getOperand1())) {
                        return CompoundInterval.logicalTrue();
                    }
                    if (value instanceof Exclusion && (exclusion = (Exclusion)value).getExcluded().equals(pEqual.getOperand1())) {
                        return CompoundInterval.logicalFalse();
                    }
                    if (value instanceof Variable) {
                        var = (Variable)value;
                        value = pEnvironment.get(var.getName());
                        continue;
                    }
                    value = null;
                }
            }
        }
        return result;
    }

    @Override
    public CompoundInterval visit(Exclusion<CompoundInterval> pExclusion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval excluded = pExclusion.getExcluded().accept(this, pEnvironment);
        if (excluded.isSingleton()) {
            return excluded.invert();
        }
        return CompoundInterval.top();
    }

    @Override
    public CompoundInterval visit(LessThan<CompoundInterval> pLessThan, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pLessThan.getOperand1().accept(this, pEnvironment).lessThan(pLessThan.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pAnd.getOperand1().accept(this, pEnvironment).logicalAnd(pAnd.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(LogicalNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pNot.getNegated().accept(this, pEnvironment).logicalNot();
    }

    @Override
    public CompoundInterval visit(Modulo<CompoundInterval> pModulo, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pModulo.getNumerator().accept(this, pEnvironment).modulo(pModulo.getDenominator().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Multiply<CompoundInterval> pMultiply, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pMultiply.getFactor1().accept(this, pEnvironment).multiply(pMultiply.getFactor2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pShiftLeft.getShifted().accept(this, pEnvironment).shiftLeft(pShiftLeft.getShiftDistance().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pShiftRight.getShifted().accept(this, pEnvironment).shiftRight(pShiftRight.getShiftDistance().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Union<CompoundInterval> pUnion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return pUnion.getOperand1().accept(this, pEnvironment).unionWith(pUnion.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Variable<CompoundInterval> pVariable, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        InvariantsFormula<CompoundInterval> varState = pEnvironment.get(pVariable.getName());
        if (varState == null) {
            return CompoundInterval.top();
        }
        return varState.accept(this, pEnvironment);
    }
}

