/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public enum InvariantsFormulaManager {
    INSTANCE;


    public <T> InvariantsFormula<T> add(InvariantsFormula<T> pSummand1, InvariantsFormula<T> pSummand2) {
        return Add.of(pSummand1, pSummand2);
    }

    public <T> InvariantsFormula<T> binaryAnd(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return BinaryAnd.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> binaryNot(InvariantsFormula<T> pToFlip) {
        return BinaryNot.of(pToFlip);
    }

    public <T> InvariantsFormula<T> binaryOr(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return BinaryOr.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> binaryXor(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return BinaryXor.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> asConstant(T pValue) {
        return Constant.of(pValue);
    }

    public <T> InvariantsFormula<T> divide(InvariantsFormula<T> pNumerator, InvariantsFormula<T> pDenominator) {
        return Divide.of(pNumerator, pDenominator);
    }

    public <T> InvariantsFormula<T> equal(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return Equal.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> exclude(InvariantsFormula<T> pToExclude) {
        return Exclusion.of(pToExclude);
    }

    public <T> InvariantsFormula<T> greaterThan(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return this.lessThan(pOperand2, pOperand1);
    }

    public <T> InvariantsFormula<T> greaterThanOrEqual(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return this.logicalNot(this.lessThan(pOperand1, pOperand2));
    }

    public <T> InvariantsFormula<T> lessThan(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return LessThan.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> lessThanOrEqual(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return this.greaterThanOrEqual(pOperand2, pOperand1);
    }

    public <T> InvariantsFormula<T> logicalAnd(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return LogicalAnd.of(pOperand1, pOperand2);
    }

    public <T> InvariantsFormula<T> logicalNot(InvariantsFormula<T> pToNegate) {
        if (pToNegate instanceof LogicalNot) {
            return ((LogicalNot)pToNegate).getNegated();
        }
        return LogicalNot.of(pToNegate);
    }

    public <T> InvariantsFormula<T> logicalOr(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return this.logicalNot(LogicalAnd.of(this.logicalNot(pOperand1), this.logicalNot(pOperand2)));
    }

    public <T> InvariantsFormula<T> logicalImplies(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        return this.logicalNot(LogicalAnd.of(pOperand1, this.logicalNot(pOperand2)));
    }

    public <T> InvariantsFormula<T> modulo(InvariantsFormula<T> pNumerator, InvariantsFormula<T> pDenominator) {
        return Modulo.of(pNumerator, pDenominator);
    }

    public <T> InvariantsFormula<T> multiply(InvariantsFormula<T> pFactor1, InvariantsFormula<T> pFactor2) {
        return Multiply.of(pFactor1, pFactor2);
    }

    public <T> InvariantsFormula<T> shiftLeft(InvariantsFormula<T> pToShift, InvariantsFormula<T> pShiftDistance) {
        return ShiftLeft.of(pToShift, pShiftDistance);
    }

    public <T> InvariantsFormula<T> shiftRight(InvariantsFormula<T> pToShift, InvariantsFormula<T> pShiftDistance) {
        return ShiftRight.of(pToShift, pShiftDistance);
    }

    public <T> InvariantsFormula<T> union(InvariantsFormula<T> pOperand1, InvariantsFormula<T> pOperand2) {
        if (pOperand1.equals(pOperand2)) {
            return pOperand1;
        }
        return Union.of(pOperand1, pOperand2);
    }

    public <T> Variable<T> asVariable(String pName) {
        return Variable.of(pName);
    }
}

