/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.formula.AbstractFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedInvariantsFormulaVisitor;

public class LogicalNot<ConstantType>
extends AbstractFormula<ConstantType>
implements InvariantsFormula<ConstantType> {
    private final InvariantsFormula<ConstantType> negated;

    private LogicalNot(InvariantsFormula<ConstantType> pToNegate) {
        this.negated = pToNegate;
    }

    public InvariantsFormula<ConstantType> getNegated() {
        return this.negated;
    }

    public String toString() {
        InvariantsFormula<ConstantType> negated = this.getNegated();
        if (negated instanceof LogicalNot) {
            return ((LogicalNot)negated).getNegated().toString();
        }
        if (negated instanceof Equal) {
            Equal equation = (Equal)negated;
            return String.format("(%s != %s) ", equation.getOperand1(), equation.getOperand2());
        }
        if (negated instanceof LessThan) {
            LessThan lessThan = (LessThan)negated;
            return String.format("(%s >= %s) ", lessThan.getOperand1(), lessThan.getOperand2());
        }
        if (negated instanceof LogicalAnd) {
            LogicalAnd and = (LogicalAnd)negated;
            String left = and.getOperand1() instanceof LogicalNot ? ((LogicalNot)and.getOperand1()).getNegated().toString() : String.format("(!%s)", and.getOperand1());
            String right = and.getOperand2() instanceof LogicalNot ? ((LogicalNot)and.getOperand2()).getNegated().toString() : String.format("(!%s)", and.getOperand2());
            return String.format("(%s || %s)", left, right);
        }
        return String.format("(!%s)", negated);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LogicalNot) {
            return this.getNegated().equals(((LogicalNot)o).getNegated());
        }
        return false;
    }

    public int hashCode() {
        return -this.getNegated().hashCode();
    }

    @Override
    public <ReturnType> ReturnType accept(InvariantsFormulaVisitor<ConstantType, ReturnType> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedInvariantsFormulaVisitor<ConstantType, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return pVisitor.visit(this, pParameter);
    }

    static <ConstantType> LogicalNot<ConstantType> of(InvariantsFormula<ConstantType> pToNegate) {
        return new LogicalNot<ConstantType>(pToNegate);
    }
}

