/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IsBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedInvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushSummandVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class PartialEvaluator
implements ParameterizedInvariantsFormulaVisitor<CompoundInterval, FormulaEvaluationVisitor<CompoundInterval>, InvariantsFormula<CompoundInterval>> {
    private static final InvariantsFormula<CompoundInterval> TOP = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
    private static final InvariantsFormula<CompoundInterval> BOTTOM = CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.bottom());
    private static final IsBooleanFormulaVisitor<CompoundInterval> IS_BOOLEAN_FORMULA_VISITOR = new IsBooleanFormulaVisitor();
    private final Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> environment;

    public PartialEvaluator() {
        this(Collections.emptyMap());
    }

    public PartialEvaluator(Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this.environment = pEnvironment;
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Add<CompoundInterval> pAdd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> summand1 = pAdd.getSummand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> summand2 = pAdd.getSummand2().accept(this, pEvaluationVisitor);
        if (summand1 instanceof Constant && summand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pAdd.accept(pEvaluationVisitor, this.environment));
        }
        Constant c = null;
        InvariantsFormula<CompoundInterval> other = null;
        if (summand1 instanceof Constant) {
            c = (Constant)summand1;
            other = summand2;
        } else if (summand2 instanceof Constant) {
            c = (Constant)summand2;
            other = summand1;
        }
        if (c != null && other != null) {
            CompoundInterval value = (CompoundInterval)c.getValue();
            if (value.isSingleton() && value.getValue().equals(BigInteger.ZERO)) {
                return other;
            }
            if (value.isTop() || value.isBottom()) {
                return c;
            }
            PushSummandVisitor<CompoundInterval> psv = new PushSummandVisitor<CompoundInterval>(pEvaluationVisitor);
            other = (InvariantsFormula<CompoundInterval>)other.accept(psv, value);
            if (psv.isSummandConsumed()) {
                other = other.accept(this, pEvaluationVisitor);
            }
            return other;
        }
        if (summand1 == pAdd.getSummand1() && summand2 == pAdd.getSummand2()) {
            return pAdd;
        }
        return CompoundIntervalFormulaManager.INSTANCE.add(summand1, summand2);
    }

    private static boolean isDefinitelyBottom(InvariantsFormula<CompoundInterval> pFormula) {
        if (pFormula instanceof Constant) {
            Constant constant = (Constant)pFormula;
            return ((CompoundInterval)constant.getValue()).isBottom();
        }
        return false;
    }

    private static boolean isDefinitelyTop(InvariantsFormula<CompoundInterval> pFormula) {
        if (pFormula instanceof Constant) {
            Constant constant = (Constant)pFormula;
            return ((CompoundInterval)constant.getValue()).isTop();
        }
        return false;
    }

    private static InvariantsFormula<CompoundInterval> extractBottomOrTop(InvariantsFormula<CompoundInterval> pFormula1, InvariantsFormula<CompoundInterval> pFormula2) {
        if (PartialEvaluator.isDefinitelyBottom(pFormula1)) {
            return pFormula1;
        }
        if (PartialEvaluator.isDefinitelyBottom(pFormula2)) {
            return pFormula2;
        }
        if (PartialEvaluator.isDefinitelyTop(pFormula1)) {
            return pFormula1;
        }
        if (PartialEvaluator.isDefinitelyTop(pFormula2)) {
            return pFormula2;
        }
        return null;
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(BinaryAnd<CompoundInterval> pAnd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pAnd.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pAnd.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pAnd.accept(pEvaluationVisitor, this.environment));
        }
        if (operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2()) {
            return pAnd;
        }
        return CompoundIntervalFormulaManager.INSTANCE.binaryAnd(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(BinaryNot<CompoundInterval> pNot, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand = pNot.getFlipped().accept(this, pEvaluationVisitor);
        if (operand instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pNot.accept(pEvaluationVisitor, this.environment));
        }
        if (operand == pNot.getFlipped()) {
            return pNot;
        }
        return CompoundIntervalFormulaManager.INSTANCE.binaryNot(operand);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(BinaryOr<CompoundInterval> pOr, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pOr.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pOr.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pOr.accept(pEvaluationVisitor, this.environment));
        }
        if (operand1 == pOr.getOperand1() && operand2 == pOr.getOperand2()) {
            return pOr;
        }
        return CompoundIntervalFormulaManager.INSTANCE.binaryOr(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(BinaryXor<CompoundInterval> pXor, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pXor.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pXor.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pXor.accept(pEvaluationVisitor, this.environment));
        }
        if (operand1 == pXor.getOperand1() && operand2 == pXor.getOperand2()) {
            return pXor;
        }
        return CompoundIntervalFormulaManager.INSTANCE.binaryXor(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Constant<CompoundInterval> pConstant, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return pConstant;
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Divide<CompoundInterval> pDivide, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        CompoundInterval value;
        InvariantsFormula<CompoundInterval> numerator = pDivide.getNumerator().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> denominator = pDivide.getDenominator().accept(this, pEvaluationVisitor);
        if (numerator instanceof Constant && denominator instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pDivide.accept(pEvaluationVisitor, this.environment));
        }
        if (denominator instanceof Constant && (value = (CompoundInterval)(c = (Constant)denominator).getValue()).isSingleton()) {
            if (value.getValue().equals(BigInteger.ONE)) {
                return numerator;
            }
            if (value.getValue().equals(BigInteger.valueOf(-1L))) {
                return CompoundIntervalFormulaManager.INSTANCE.negate(numerator);
            }
        }
        if (numerator == pDivide.getNumerator() && denominator == pDivide.getDenominator()) {
            return pDivide;
        }
        return CompoundIntervalFormulaManager.INSTANCE.divide(numerator, denominator);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Equal<CompoundInterval> pEqual, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pEqual.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pEqual.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pEqual.accept(pEvaluationVisitor, this.environment));
        }
        InvariantsFormula<CompoundInterval> botOrTop = PartialEvaluator.extractBottomOrTop(operand1, operand2);
        if (botOrTop != null) {
            return botOrTop;
        }
        CompoundInterval c = null;
        InvariantsFormula<CompoundInterval> other = null;
        if (operand1 instanceof Constant && (((Boolean)pEqual.getOperand2().accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue() || ((Boolean)operand2.accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue())) {
            c = (CompoundInterval)operand1.accept(pEvaluationVisitor, this.environment);
            other = operand2;
        } else if (operand2 instanceof Constant && (((Boolean)pEqual.getOperand1().accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue() || ((Boolean)operand1.accept(IS_BOOLEAN_FORMULA_VISITOR)).booleanValue())) {
            c = (CompoundInterval)operand2.accept(pEvaluationVisitor, this.environment);
            other = operand1;
        }
        if (c != null && other != null) {
            if (c.isDefinitelyTrue()) {
                return other;
            }
            if (c.isDefinitelyFalse()) {
                return CompoundIntervalFormulaManager.INSTANCE.logicalNot(other).accept(this, pEvaluationVisitor);
            }
        }
        if (operand1 == pEqual.getOperand1() && operand2 == pEqual.getOperand2()) {
            return pEqual;
        }
        return CompoundIntervalFormulaManager.INSTANCE.equal(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(LessThan<CompoundInterval> pLessThan, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pLessThan.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pLessThan.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pLessThan.accept(pEvaluationVisitor, this.environment));
        }
        InvariantsFormula<CompoundInterval> botOrTop = PartialEvaluator.extractBottomOrTop(operand1, operand2);
        if (botOrTop != null) {
            return botOrTop;
        }
        if (operand1 == pLessThan.getOperand1() && operand2 == pLessThan.getOperand2()) {
            return pLessThan;
        }
        return CompoundIntervalFormulaManager.INSTANCE.lessThan(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(LogicalAnd<CompoundInterval> pAnd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pAnd.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pAnd.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pAnd.accept(pEvaluationVisitor, this.environment));
        }
        InvariantsFormula<CompoundInterval> constant = null;
        InvariantsFormula<CompoundInterval> other = null;
        if (operand1 instanceof Constant) {
            constant = operand1;
            other = operand2;
        } else if (operand2 instanceof Constant) {
            constant = operand2;
            other = operand1;
        }
        if (constant != null && other != null) {
            CompoundInterval constantValue = (CompoundInterval)((Constant)constant).getValue();
            if (constantValue.isDefinitelyFalse() || constantValue.isBottom() || constantValue.isTop()) {
                return constant;
            }
            if (constantValue.isDefinitelyTrue()) {
                return other;
            }
        }
        if (operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2()) {
            return pAnd;
        }
        return CompoundIntervalFormulaManager.INSTANCE.logicalAnd(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(LogicalNot<CompoundInterval> pNot, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand = pNot.getNegated().accept(this, pEvaluationVisitor);
        if (operand instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pNot.accept(pEvaluationVisitor, this.environment));
        }
        if (operand instanceof LogicalNot) {
            return ((LogicalNot)operand).getNegated();
        }
        if (operand instanceof LogicalAnd) {
            LogicalAnd land = (LogicalAnd)operand;
            if (((CompoundInterval)land.getOperand1().accept(pEvaluationVisitor, this.environment)).isDefinitelyFalse()) {
                return CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.logicalTrue());
            }
            if (((CompoundInterval)land.getOperand2().accept(pEvaluationVisitor, this.environment)).isDefinitelyFalse()) {
                return CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.logicalTrue());
            }
            if (((CompoundInterval)land.getOperand1().accept(pEvaluationVisitor, this.environment)).isDefinitelyTrue()) {
                return CompoundIntervalFormulaManager.INSTANCE.logicalNot(land.getOperand2()).accept(this, pEvaluationVisitor);
            }
            if (((CompoundInterval)land.getOperand2().accept(pEvaluationVisitor, this.environment)).isDefinitelyTrue()) {
                return CompoundIntervalFormulaManager.INSTANCE.logicalNot(land.getOperand1()).accept(this, pEvaluationVisitor);
            }
        }
        if (operand == pNot.getNegated()) {
            return pNot;
        }
        return CompoundIntervalFormulaManager.INSTANCE.logicalNot(operand);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Modulo<CompoundInterval> pModulo, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        CompoundInterval value;
        InvariantsFormula<CompoundInterval> numerator = pModulo.getNumerator().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> denominator = pModulo.getDenominator().accept(this, pEvaluationVisitor);
        if (numerator instanceof Constant && denominator instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pModulo.accept(pEvaluationVisitor, this.environment));
        }
        if (denominator instanceof Constant && (value = (CompoundInterval)(c = (Constant)denominator).getValue()).isSingleton() && (value.getValue().equals(BigInteger.ONE) || value.getValue().equals(BigInteger.valueOf(-1L)))) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.singleton(1L));
        }
        if (numerator == pModulo.getNumerator() && denominator == pModulo.getDenominator()) {
            return pModulo;
        }
        return CompoundIntervalFormulaManager.INSTANCE.modulo(numerator, denominator);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Multiply<CompoundInterval> pMultiply, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval state;
        InvariantsFormula<CompoundInterval> factor1 = pMultiply.getFactor1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> factor2 = pMultiply.getFactor2().accept(this, pEvaluationVisitor);
        if (factor1 instanceof Constant && factor2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pMultiply.accept(pEvaluationVisitor, this.environment));
        }
        Constant c = null;
        InvariantsFormula<CompoundInterval> otherFactor = null;
        if (factor1 instanceof Constant) {
            c = (Constant)factor1;
            otherFactor = factor2;
        } else if (factor2 instanceof Constant) {
            c = (Constant)factor2;
            otherFactor = factor1;
        }
        if (c != null && otherFactor != null && (state = (CompoundInterval)c.getValue()).isSingleton()) {
            BigInteger value = state.getValue();
            if (value.equals(BigInteger.ONE)) {
                return otherFactor;
            }
            if (value.equals(BigInteger.valueOf(-1L))) {
                return CompoundIntervalFormulaManager.INSTANCE.negate(otherFactor);
            }
            if (value.equals(BigInteger.ZERO)) {
                return CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.singleton(BigInteger.ZERO));
            }
        }
        if (factor1 == pMultiply.getFactor1() && factor2 == pMultiply.getFactor2()) {
            return pMultiply;
        }
        return CompoundIntervalFormulaManager.INSTANCE.multiply(factor1, factor2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(ShiftLeft<CompoundInterval> pShiftLeft, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        InvariantsFormula<CompoundInterval> shifted = pShiftLeft.getShifted().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> shiftDistance = pShiftLeft.getShiftDistance().accept(this, pEvaluationVisitor);
        if (shifted instanceof Constant && shiftDistance instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pShiftLeft.accept(pEvaluationVisitor, this.environment));
        }
        if (shiftDistance instanceof Constant && ((CompoundInterval)(c = (Constant)shiftDistance).getValue()).isSingleton() && ((CompoundInterval)c.getValue()).getValue().equals(BigInteger.ZERO)) {
            return shifted;
        }
        if (shifted == pShiftLeft.getShifted() && shiftDistance == pShiftLeft.getShiftDistance()) {
            return pShiftLeft;
        }
        return CompoundIntervalFormulaManager.INSTANCE.shiftLeft(shifted, shiftDistance);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(ShiftRight<CompoundInterval> pShiftRight, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        InvariantsFormula<CompoundInterval> shifted = pShiftRight.getShifted().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> shiftDistance = pShiftRight.getShiftDistance().accept(this, pEvaluationVisitor);
        if (shifted instanceof Constant && shiftDistance instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pShiftRight.accept(pEvaluationVisitor, this.environment));
        }
        if (shiftDistance instanceof Constant && ((CompoundInterval)(c = (Constant)shiftDistance).getValue()).isSingleton() && ((CompoundInterval)c.getValue()).getValue().equals(BigInteger.ZERO)) {
            return shifted;
        }
        if (shifted == pShiftRight.getShifted() && shiftDistance == pShiftRight.getShiftDistance()) {
            return pShiftRight;
        }
        return CompoundIntervalFormulaManager.INSTANCE.shiftRight(shifted, shiftDistance);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Union<CompoundInterval> pUnion, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        InvariantsFormula<CompoundInterval> operand1 = pUnion.getOperand1().accept(this, pEvaluationVisitor);
        InvariantsFormula<CompoundInterval> operand2 = pUnion.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant((CompoundInterval)pUnion.accept(pEvaluationVisitor, this.environment));
        }
        if (operand1.equals(TOP) || operand2.equals(TOP)) {
            return TOP;
        }
        if (operand1.equals(BOTTOM)) {
            return operand2;
        }
        if (operand2.equals(BOTTOM)) {
            return operand1;
        }
        HashSet<InvariantsFormula> atomicUnionParts = new HashSet<InvariantsFormula>();
        ArrayDeque unionParts = new ArrayDeque();
        CompoundInterval constantPart = CompoundInterval.bottom();
        unionParts.offer(pUnion);
        int partsFound = 0;
        while (!unionParts.isEmpty()) {
            InvariantsFormula currentPart = (InvariantsFormula)unionParts.poll();
            if (currentPart instanceof Union) {
                Union currentUnion = (Union)currentPart;
                unionParts.add(currentUnion.getOperand1());
                unionParts.add(currentUnion.getOperand2());
                partsFound += 2;
                continue;
            }
            if (currentPart instanceof Constant) {
                constantPart = constantPart.unionWith((CompoundInterval)((Constant)currentPart).getValue());
                continue;
            }
            atomicUnionParts.add(currentPart);
        }
        if (partsFound > atomicUnionParts.size()) {
            InvariantsFormula<CompoundInterval> result = null;
            if (atomicUnionParts.size() > 0) {
                Iterator atomicUnionPartsIterator = atomicUnionParts.iterator();
                result = (InvariantsFormula<CompoundInterval>)atomicUnionPartsIterator.next();
                while (atomicUnionPartsIterator.hasNext()) {
                    result = CompoundIntervalFormulaManager.INSTANCE.union(result, (InvariantsFormula)atomicUnionPartsIterator.next());
                }
            }
            if (!constantPart.isBottom()) {
                InvariantsFormula<CompoundInterval> constantPartFormula = CompoundIntervalFormulaManager.INSTANCE.asConstant(constantPart);
                InvariantsFormula<CompoundInterval> invariantsFormula = result = result == null ? constantPartFormula : CompoundIntervalFormulaManager.INSTANCE.union(result, constantPartFormula);
            }
            if (result != null) {
                return result;
            }
        }
        if (operand1 == pUnion.getOperand1() && operand2 == pUnion.getOperand2()) {
            return pUnion;
        }
        return CompoundIntervalFormulaManager.INSTANCE.union(operand1, operand2);
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Variable<CompoundInterval> pVariable, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval value = (CompoundInterval)pVariable.accept(pEvaluationVisitor, this.environment);
        if (value.isSingleton()) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant(value);
        }
        return pVariable;
    }

    @Override
    public InvariantsFormula<CompoundInterval> visit(Exclusion<CompoundInterval> pExclusion, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval value = (CompoundInterval)pExclusion.accept(pEvaluationVisitor, this.environment);
        if (value.isSingleton()) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant(value);
        }
        return pExclusion;
    }
}

