/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CachingEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedInvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class PushAssumptionToEnvironmentVisitor
implements ParameterizedInvariantsFormulaVisitor<CompoundInterval, CompoundInterval, Boolean> {
    private final NonRecursiveEnvironment.Builder environment;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final CachingEvaluationVisitor<CompoundInterval> cachingEvaluationVisitor;

    public PushAssumptionToEnvironmentVisitor(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, NonRecursiveEnvironment.Builder pEnvironment) {
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.cachingEvaluationVisitor = new CachingEvaluationVisitor<CompoundInterval>(this.environment, this.evaluationVisitor);
    }

    private CompoundInterval evaluate(InvariantsFormula<CompoundInterval> pFormula) {
        return (CompoundInterval)pFormula.accept(this.cachingEvaluationVisitor);
    }

    @Override
    public Boolean visit(Add<CompoundInterval> pAdd, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pAdd).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pAdd.getSummand1());
        CompoundInterval rightValue = this.evaluate(pAdd.getSummand2());
        CompoundInterval pushLeftValue = parameter.add(rightValue.negate());
        CompoundInterval pushRightValue = parameter.add(leftValue.negate());
        if (!pAdd.getSummand1().accept(this, pushLeftValue).booleanValue() || !pAdd.getSummand2().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryAnd<CompoundInterval> pAnd, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pAnd).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(BinaryNot<CompoundInterval> pNot, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pNot).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (!pNot.getFlipped().accept(this, parameter.invert()).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryOr<CompoundInterval> pOr, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pOr).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(BinaryXor<CompoundInterval> pXor, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pXor).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(Constant<CompoundInterval> pConstant, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return pConstant.getValue().intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(Divide<CompoundInterval> pDivide, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pDivide).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pDivide.getNumerator());
        CompoundInterval rightValue = this.evaluate(pDivide.getDenominator());
        CompoundInterval computedLeftValue = parameter.multiply(rightValue);
        for (SimpleInterval interval : computedLeftValue.getIntervals()) {
            CompoundInterval borderA = CompoundInterval.of(interval);
            CompoundInterval borderB = borderA.add(rightValue.add(rightValue.signum().negate()));
            computedLeftValue = computedLeftValue.unionWith(CompoundInterval.span(borderA, borderB));
        }
        CompoundInterval pushLeftValue = leftValue.intersectWith(computedLeftValue);
        CompoundInterval pushRightValue = leftValue.divide(parameter);
        if (!pDivide.getNumerator().accept(this, pushLeftValue).booleanValue() || !pDivide.getDenominator().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Equal<CompoundInterval> pEqual, CompoundInterval pParameter) {
        String varName;
        CompoundInterval parameter = this.evaluate(pEqual).intersectWith(pParameter);
        if (!parameter.isDefinitelyTrue() && !parameter.isDefinitelyFalse()) {
            return !parameter.isBottom();
        }
        CompoundInterval leftValue = this.evaluate(pEqual.getOperand1());
        CompoundInterval rightValue = this.evaluate(pEqual.getOperand2());
        if (parameter.isDefinitelyTrue()) {
            Object previous;
            String varName2;
            InvariantsFormula<CompoundInterval> op1 = pEqual.getOperand1();
            InvariantsFormula<CompoundInterval> op2 = pEqual.getOperand2();
            if (op1 instanceof Variable) {
                varName2 = ((Variable)op1).getName();
                previous = this.environment.get(varName2);
                this.environment.put(varName2, op2);
                if (previous != null && !CompoundIntervalFormulaManager.definitelyImplies(this.environment, CompoundIntervalFormulaManager.INSTANCE.equal(op1, (InvariantsFormula<CompoundInterval>)previous))) {
                    this.environment.put(varName2, (InvariantsFormula<CompoundInterval>)previous);
                }
            }
            if (op2 instanceof Variable) {
                varName2 = ((Variable)op2).getName();
                previous = this.environment.get(varName2);
                this.environment.put(varName2, op1);
                if (previous != null && !CompoundIntervalFormulaManager.definitelyImplies(this.environment, CompoundIntervalFormulaManager.INSTANCE.equal(op2, (InvariantsFormula<CompoundInterval>)previous))) {
                    this.environment.put(varName2, (InvariantsFormula<CompoundInterval>)previous);
                }
            }
            return pEqual.getOperand1().accept(this, rightValue) != false && pEqual.getOperand2().accept(this, leftValue) != false;
        }
        InvariantsFormula<CompoundInterval> op1 = pEqual.getOperand1();
        InvariantsFormula<CompoundInterval> op2 = pEqual.getOperand2();
        if (op1 instanceof Variable && this.environment.get(varName = ((Variable)op1).getName()) == null) {
            this.environment.put(varName, CompoundIntervalFormulaManager.INSTANCE.exclude(op2));
        }
        if (op2 instanceof Variable && this.environment.get(varName = ((Variable)op2).getName()) == null) {
            this.environment.put(varName, CompoundIntervalFormulaManager.INSTANCE.exclude(op1));
        }
        if (rightValue.isSingleton() && !pEqual.getOperand1().accept(this, rightValue.invert()).booleanValue()) {
            return false;
        }
        if (leftValue.isSingleton() && !pEqual.getOperand2().accept(this, leftValue.invert()).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Exclusion<CompoundInterval> pExclusion, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pExclusion).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(LessThan<CompoundInterval> pLessThan, CompoundInterval pParameter) {
        CompoundInterval rightPushValue;
        CompoundInterval leftPushValue;
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pLessThan).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (!parameter.isDefinitelyTrue() && !parameter.isDefinitelyFalse()) {
            return !parameter.isBottom();
        }
        CompoundInterval leftValue = this.evaluate(pLessThan.getOperand1());
        CompoundInterval rightValue = this.evaluate(pLessThan.getOperand2());
        if (parameter.isDefinitelyTrue()) {
            leftPushValue = rightValue.extendToNegativeInfinity().span().add(-1L);
            rightPushValue = leftValue.extendToPositiveInfinity().span().add(1L);
        } else {
            leftPushValue = rightValue.extendToPositiveInfinity().span();
            rightPushValue = leftValue.extendToNegativeInfinity().span();
        }
        return pLessThan.getOperand1().accept(this, leftPushValue) != false && pLessThan.getOperand2().accept(this, rightPushValue) != false;
    }

    @Override
    public Boolean visit(LogicalAnd<CompoundInterval> pAnd, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pAnd).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (parameter.isDefinitelyTrue()) {
            return pAnd.getOperand1().accept(this, parameter) != false && pAnd.getOperand2().accept(this, parameter) != false;
        }
        if (parameter.isDefinitelyFalse()) {
            NonRecursiveEnvironment.Builder env1 = new NonRecursiveEnvironment.Builder(this.environment);
            boolean push1 = pAnd.getOperand1().accept(new PushAssumptionToEnvironmentVisitor(this.evaluationVisitor, env1), pParameter);
            if (!push1) {
                return pAnd.getOperand2().accept(this, CompoundInterval.logicalFalse());
            }
            NonRecursiveEnvironment.Builder env2 = new NonRecursiveEnvironment.Builder(this.environment);
            boolean push2 = pAnd.getOperand2().accept(new PushAssumptionToEnvironmentVisitor(this.evaluationVisitor, env2), pParameter);
            if (!push2) {
                return pAnd.getOperand1().accept(this, CompoundInterval.logicalFalse());
            }
            for (Map.Entry<String, InvariantsFormula<CompoundInterval>> entry : env2.entrySet()) {
                String varName = entry.getKey();
                Object value1 = env1.get(varName);
                if (value1 == null) continue;
                InvariantsFormula<CompoundInterval> value2 = entry.getValue();
                InvariantsFormula<CompoundInterval> newValueFormula = CompoundIntervalFormulaManager.INSTANCE.union((InvariantsFormula<CompoundInterval>)value1, value2).accept(new PartialEvaluator(this.environment), this.evaluationVisitor);
                if (((CompoundInterval)newValueFormula.accept(this.evaluationVisitor, this.environment)).isBottom()) {
                    this.cachingEvaluationVisitor.clearCache();
                    return false;
                }
                if (newValueFormula instanceof Constant && ((CompoundInterval)((Constant)newValueFormula).getValue()).isTop()) continue;
                this.environment.put(varName, newValueFormula);
                this.cachingEvaluationVisitor.clearCache();
            }
        }
        return true;
    }

    @Override
    public Boolean visit(LogicalNot<CompoundInterval> pNot, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pNot).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (parameter.isDefinitelyTrue() || parameter.isDefinitelyFalse()) {
            return pNot.getNegated().accept(this, parameter.logicalNot());
        }
        return true;
    }

    @Override
    public Boolean visit(Modulo<CompoundInterval> pModulo, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pModulo).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(Multiply<CompoundInterval> pMultiply, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pMultiply).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pMultiply.getFactor1());
        CompoundInterval rightValue = this.evaluate(pMultiply.getFactor2());
        CompoundInterval pushLeftValue = parameter.divide(rightValue);
        CompoundInterval pushRightValue = parameter.divide(leftValue);
        if (!pMultiply.getFactor1().accept(this, pushLeftValue).booleanValue() || !pMultiply.getFactor2().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ShiftLeft<CompoundInterval> pShiftLeft, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pShiftLeft).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(ShiftRight<CompoundInterval> pShiftRight, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.evaluate(pShiftRight).intersectsWith(pParameter);
    }

    @Override
    public Boolean visit(Union<CompoundInterval> pUnion, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        InvariantsFormula<CompoundInterval> operand1 = pUnion.getOperand1();
        InvariantsFormula<CompoundInterval> operand2 = pUnion.getOperand2();
        if (!this.evaluate(operand1).intersectsWith(pParameter) && !operand2.accept(this, pParameter).booleanValue()) {
            return false;
        }
        if (!this.evaluate(operand2).intersectsWith(pParameter) && !operand1.accept(this, pParameter).booleanValue()) {
            return false;
        }
        CompoundIntervalFormulaManager ifm = CompoundIntervalFormulaManager.INSTANCE;
        InvariantsFormula<CompoundInterval> parameter = ifm.asConstant(pParameter);
        return ifm.logicalOr(ifm.equal(pUnion.getOperand1(), parameter), ifm.equal(pUnion.getOperand2(), parameter)).accept(this, CompoundInterval.logicalTrue());
    }

    @Override
    public Boolean visit(Variable<CompoundInterval> pVariable, CompoundInterval pParameter) {
        CompoundInterval newValue;
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundInterval parameter = this.evaluate(pVariable).intersectWith(pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (parameter.isTop()) {
            return true;
        }
        String varName = pVariable.getName();
        InvariantsFormula<CompoundInterval> resolved = this.getFromEnvironment(varName);
        if (!resolved.accept(this, parameter).booleanValue()) {
            return false;
        }
        if (resolved instanceof Constant) {
            CompoundInterval resolvedValue = (CompoundInterval)((Constant)resolved).getValue();
            newValue = resolvedValue.intersectWith(parameter);
        } else if (!parameter.equals(pParameter)) {
            newValue = parameter;
        } else {
            return true;
        }
        if (newValue.isBottom()) {
            return false;
        }
        if (newValue.isTop()) {
            this.environment.remove(varName);
        } else {
            CompoundIntervalFormulaManager ifm = CompoundIntervalFormulaManager.INSTANCE;
            this.environment.put(varName, ifm.asConstant(newValue));
        }
        this.cachingEvaluationVisitor.clearCache();
        return true;
    }

    private InvariantsFormula<CompoundInterval> getFromEnvironment(String pVarName) {
        Object result = this.environment.get(pVarName);
        if (result == null) {
            return CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top());
        }
        return result;
    }
}

