/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Collections;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;

public class PushSummandVisitor<T>
extends DefaultParameterizedFormulaVisitor<T, T, InvariantsFormula<T>> {
    private static final String SUMMAND_ALREADY_CONSUMED_MESSAGE = "Summand already consumed.";
    private final Map<? extends String, ? extends InvariantsFormula<T>> EMPTY_ENVIRONMENT = Collections.emptyMap();
    private final FormulaEvaluationVisitor<T> evaluationVisitor;
    private boolean consumed = false;

    public PushSummandVisitor(FormulaEvaluationVisitor<T> pEvaluationVisitor) {
        this.evaluationVisitor = pEvaluationVisitor;
    }

    public boolean isSummandConsumed() {
        return this.consumed;
    }

    private void checkNotConsumed() throws IllegalStateException {
        if (this.isSummandConsumed()) {
            throw new IllegalStateException(SUMMAND_ALREADY_CONSUMED_MESSAGE);
        }
    }

    @Override
    public InvariantsFormula<T> visit(Add<T> pAdd, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        InvariantsFormula candidateS1 = (InvariantsFormula)pAdd.getSummand1().accept(this, pToPush);
        if (this.isSummandConsumed()) {
            return InvariantsFormulaManager.INSTANCE.add(candidateS1, pAdd.getSummand2());
        }
        InvariantsFormula summand2 = (InvariantsFormula)pAdd.getSummand2().accept(this, pToPush);
        return InvariantsFormulaManager.INSTANCE.add(pAdd.getSummand1(), summand2);
    }

    @Override
    public InvariantsFormula<T> visit(Constant<T> pConstant, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        InvariantsFormulaManager ifm = InvariantsFormulaManager.INSTANCE;
        InvariantsFormula<T> toPush = ifm.asConstant(pToPush);
        InvariantsFormula<T> sum = ifm.add(pConstant, toPush);
        this.consumed = true;
        Object sumValue = sum.accept(this.evaluationVisitor, this.EMPTY_ENVIRONMENT);
        return InvariantsFormulaManager.INSTANCE.asConstant(sumValue);
    }

    @Override
    protected InvariantsFormula<T> visitDefault(InvariantsFormula<T> pFormula, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        InvariantsFormulaManager ifm = InvariantsFormulaManager.INSTANCE;
        InvariantsFormula<T> toPush = ifm.asConstant(pToPush);
        return ifm.add(pFormula, toPush);
    }
}

