/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public abstract class RecursiveDefaultFormulaVisitor<T>
implements InvariantsFormulaVisitor<T, InvariantsFormula<T>> {
    protected abstract InvariantsFormula<T> visitPost(InvariantsFormula<T> var1);

    @Override
    public InvariantsFormula<T> visit(Add<T> pAdd) {
        InvariantsFormula summand1 = (InvariantsFormula)pAdd.getSummand1().accept(this);
        InvariantsFormula summand2 = (InvariantsFormula)pAdd.getSummand2().accept(this);
        InvariantsFormula toVisit = summand1 == pAdd.getSummand1() && summand2 == pAdd.getSummand2() ? pAdd : InvariantsFormulaManager.INSTANCE.add(summand1, summand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(BinaryAnd<T> pAnd) {
        InvariantsFormula operand1 = (InvariantsFormula)pAnd.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pAnd.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2() ? pAnd : InvariantsFormulaManager.INSTANCE.binaryAnd(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(BinaryNot<T> pNot) {
        InvariantsFormula operand = (InvariantsFormula)pNot.getFlipped().accept(this);
        InvariantsFormula<T> toVisit = operand == pNot.getFlipped() ? pNot : InvariantsFormulaManager.INSTANCE.binaryNot(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(BinaryOr<T> pOr) {
        InvariantsFormula operand1 = (InvariantsFormula)pOr.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pOr.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pOr.getOperand1() && operand2 == pOr.getOperand2() ? pOr : InvariantsFormulaManager.INSTANCE.binaryOr(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(BinaryXor<T> pXor) {
        InvariantsFormula operand1 = (InvariantsFormula)pXor.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pXor.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pXor.getOperand1() && operand2 == pXor.getOperand2() ? pXor : InvariantsFormulaManager.INSTANCE.binaryXor(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Constant<T> pConstant) {
        return this.visitPost(pConstant);
    }

    @Override
    public InvariantsFormula<T> visit(Divide<T> pDivide) {
        InvariantsFormula numerator = (InvariantsFormula)pDivide.getNumerator().accept(this);
        InvariantsFormula denominator = (InvariantsFormula)pDivide.getDenominator().accept(this);
        InvariantsFormula toVisit = numerator == pDivide.getNumerator() && denominator == pDivide.getDenominator() ? pDivide : InvariantsFormulaManager.INSTANCE.divide(numerator, denominator);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Equal<T> pEqual) {
        InvariantsFormula operand1 = (InvariantsFormula)pEqual.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pEqual.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pEqual.getOperand1() && operand2 == pEqual.getOperand2() ? pEqual : InvariantsFormulaManager.INSTANCE.equal(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Exclusion<T> pExclusion) {
        InvariantsFormula operand = (InvariantsFormula)pExclusion.getExcluded().accept(this);
        InvariantsFormula<T> toVisit = operand == pExclusion.getExcluded() ? pExclusion : InvariantsFormulaManager.INSTANCE.exclude(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(LessThan<T> pLessThan) {
        InvariantsFormula operand1 = (InvariantsFormula)pLessThan.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pLessThan.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pLessThan.getOperand1() && operand2 == pLessThan.getOperand2() ? pLessThan : InvariantsFormulaManager.INSTANCE.lessThan(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(LogicalAnd<T> pAnd) {
        InvariantsFormula operand1 = (InvariantsFormula)pAnd.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pAnd.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2() ? pAnd : InvariantsFormulaManager.INSTANCE.logicalAnd(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(LogicalNot<T> pNot) {
        InvariantsFormula operand = (InvariantsFormula)pNot.getNegated().accept(this);
        InvariantsFormula<T> toVisit = operand == pNot.getNegated() ? pNot : InvariantsFormulaManager.INSTANCE.logicalNot(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Modulo<T> pModulo) {
        InvariantsFormula numerator = (InvariantsFormula)pModulo.getNumerator().accept(this);
        InvariantsFormula denominator = (InvariantsFormula)pModulo.getDenominator().accept(this);
        InvariantsFormula toVisit = numerator == pModulo.getNumerator() && denominator == pModulo.getDenominator() ? pModulo : InvariantsFormulaManager.INSTANCE.modulo(numerator, denominator);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Multiply<T> pMultiply) {
        InvariantsFormula factor1 = (InvariantsFormula)pMultiply.getFactor1().accept(this);
        InvariantsFormula factor2 = (InvariantsFormula)pMultiply.getFactor2().accept(this);
        InvariantsFormula toVisit = factor1 == pMultiply.getFactor1() && factor2 == pMultiply.getFactor2() ? pMultiply : InvariantsFormulaManager.INSTANCE.multiply(factor1, factor2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(ShiftLeft<T> pShiftLeft) {
        InvariantsFormula shifted = (InvariantsFormula)pShiftLeft.getShifted().accept(this);
        InvariantsFormula shiftDistance = (InvariantsFormula)pShiftLeft.getShiftDistance().accept(this);
        InvariantsFormula toVisit = shifted == pShiftLeft.getShifted() && shiftDistance == pShiftLeft.getShiftDistance() ? pShiftLeft : InvariantsFormulaManager.INSTANCE.shiftLeft(shifted, shiftDistance);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(ShiftRight<T> pShiftRight) {
        InvariantsFormula shifted = (InvariantsFormula)pShiftRight.getShifted().accept(this);
        InvariantsFormula shiftDistance = (InvariantsFormula)pShiftRight.getShiftDistance().accept(this);
        InvariantsFormula toVisit = shifted == pShiftRight.getShifted() && shiftDistance == pShiftRight.getShiftDistance() ? pShiftRight : InvariantsFormulaManager.INSTANCE.shiftRight(shifted, shiftDistance);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Union<T> pUnion) {
        InvariantsFormula operand1 = (InvariantsFormula)pUnion.getOperand1().accept(this);
        InvariantsFormula operand2 = (InvariantsFormula)pUnion.getOperand2().accept(this);
        InvariantsFormula toVisit = operand1 == pUnion.getOperand1() && operand2 == pUnion.getOperand2() ? pUnion : InvariantsFormulaManager.INSTANCE.union(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public InvariantsFormula<T> visit(Variable<T> pVariable) {
        return this.visitPost(pVariable);
    }
}

