/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class StateEqualsVisitor
extends DefaultParameterizedFormulaVisitor<CompoundInterval, InvariantsFormula<CompoundInterval>, Boolean> {
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> environment;

    public StateEqualsVisitor(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
    }

    @Override
    protected Boolean visitDefault(InvariantsFormula<CompoundInterval> pFormula, InvariantsFormula<CompoundInterval> pOther) {
        CompoundInterval leftValue = (CompoundInterval)pFormula.accept(this.evaluationVisitor, this.environment);
        CompoundInterval rightValue = (CompoundInterval)pOther.accept(this.evaluationVisitor, this.environment);
        return leftValue.logicalEquals(rightValue).isDefinitelyTrue();
    }

    private Boolean visitCommutative(InvariantsFormula<CompoundInterval> pO1, InvariantsFormula<CompoundInterval> pO2, InvariantsFormula<CompoundInterval> pOtherO1, InvariantsFormula<CompoundInterval> pOtherO2) {
        return this.visitNonCommutative(pO1, pO2, pOtherO1, pOtherO2) != false || pO1.accept(this, pOtherO2) != false && pO2.accept(this, pOtherO1) != false;
    }

    private Boolean visitNonCommutative(InvariantsFormula<CompoundInterval> pO1, InvariantsFormula<CompoundInterval> pO2, InvariantsFormula<CompoundInterval> pOtherO1, InvariantsFormula<CompoundInterval> pOtherO2) {
        return pO1.accept(this, pOtherO1) != false && pO2.accept(this, pOtherO2) != false;
    }

    @Override
    public Boolean visit(Add<CompoundInterval> pAdd, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Add) {
            Add other = (Add)pOther;
            if (this.visitCommutative(pAdd.getSummand1(), pAdd.getSummand2(), other.getSummand1(), other.getSummand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pAdd, pOther);
    }

    @Override
    public Boolean visit(BinaryAnd<CompoundInterval> pAnd, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryAnd) {
            BinaryAnd other = (BinaryAnd)pOther;
            if (this.visitCommutative(pAnd.getOperand1(), pAnd.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pAnd, pOther);
    }

    @Override
    public Boolean visit(BinaryNot<CompoundInterval> pNot, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryNot) {
            BinaryNot other = (BinaryNot)pOther;
            if (pNot.getFlipped().accept(this, other.getFlipped()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pNot, pOther);
    }

    @Override
    public Boolean visit(BinaryOr<CompoundInterval> pOr, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryOr) {
            BinaryOr other = (BinaryOr)pOther;
            if (this.visitCommutative(pOr.getOperand1(), pOr.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pOr, pOther);
    }

    @Override
    public Boolean visit(BinaryXor<CompoundInterval> pXor, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryXor) {
            BinaryXor other = (BinaryXor)pOther;
            if (this.visitCommutative(pXor.getOperand1(), pXor.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pXor, pOther);
    }

    @Override
    public Boolean visit(Divide<CompoundInterval> pDivide, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Divide) {
            Divide other = (Divide)pOther;
            if (this.visitNonCommutative(pDivide.getNumerator(), pDivide.getDenominator(), other.getNumerator(), other.getDenominator()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pDivide, pOther);
    }

    @Override
    public Boolean visit(Equal<CompoundInterval> pEqual, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Equal) {
            Equal other = (Equal)pOther;
            if (this.visitCommutative(pEqual.getOperand1(), pEqual.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pEqual, pOther);
    }

    @Override
    public Boolean visit(LessThan<CompoundInterval> pLessThan, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof LessThan) {
            LessThan other = (LessThan)pOther;
            if (this.visitNonCommutative(pLessThan.getOperand1(), pLessThan.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pLessThan, pOther);
    }

    @Override
    public Boolean visit(LogicalAnd<CompoundInterval> pAnd, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof LogicalAnd) {
            LogicalAnd other = (LogicalAnd)pOther;
            if (this.visitCommutative(pAnd.getOperand1(), pAnd.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pAnd, pOther);
    }

    @Override
    public Boolean visit(LogicalNot<CompoundInterval> pNot, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof LogicalNot) {
            LogicalNot other = (LogicalNot)pOther;
            if (pNot.getNegated().accept(this, other.getNegated()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pNot, pOther);
    }

    @Override
    public Boolean visit(Modulo<CompoundInterval> pModulo, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Modulo) {
            Modulo other = (Modulo)pOther;
            if (this.visitNonCommutative(pModulo.getNumerator(), pModulo.getDenominator(), other.getNumerator(), other.getDenominator()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pModulo, pOther);
    }

    @Override
    public Boolean visit(Multiply<CompoundInterval> pMultiply, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Multiply) {
            Multiply other = (Multiply)pOther;
            if (this.visitCommutative(pMultiply.getFactor1(), pMultiply.getFactor2(), other.getFactor1(), other.getFactor2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pMultiply, pOther);
    }

    @Override
    public Boolean visit(ShiftLeft<CompoundInterval> pShiftLeft, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof ShiftLeft) {
            ShiftLeft other = (ShiftLeft)pOther;
            if (this.visitNonCommutative(pShiftLeft.getShifted(), pShiftLeft.getShiftDistance(), other.getShifted(), other.getShiftDistance()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pShiftLeft, pOther);
    }

    @Override
    public Boolean visit(ShiftRight<CompoundInterval> pShiftRight, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof ShiftRight) {
            ShiftRight other = (ShiftRight)pOther;
            if (this.visitNonCommutative(pShiftRight.getShifted(), pShiftRight.getShiftDistance(), other.getShifted(), other.getShiftDistance()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pShiftRight, pOther);
    }

    @Override
    public Boolean visit(Union<CompoundInterval> pUnion, InvariantsFormula<CompoundInterval> pOther) {
        if (pOther instanceof Union) {
            Union other = (Union)pOther;
            if (this.visitCommutative(pUnion.getOperand1(), pUnion.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pUnion, pOther);
    }

    @Override
    public Boolean visit(Variable<CompoundInterval> pVariable, InvariantsFormula<CompoundInterval> pOther) {
        if (pVariable.equals(pOther)) {
            return true;
        }
        String leftVarName = pVariable.getName();
        InvariantsFormula<CompoundInterval> resolvedLeft = this.environment.get(leftVarName);
        InvariantsFormula<CompoundInterval> invariantsFormula = resolvedLeft = resolvedLeft == null ? CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top()) : resolvedLeft;
        if (pOther instanceof Variable) {
            String rightVarName = ((Variable)pOther).getName();
            if (leftVarName.equals(rightVarName)) {
                return true;
            }
            InvariantsFormula<CompoundInterval> resolvedRight = this.environment.get(rightVarName);
            InvariantsFormula<CompoundInterval> invariantsFormula2 = resolvedRight = resolvedRight == null ? CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.top()) : resolvedRight;
            if (resolvedLeft.accept(this, resolvedRight).booleanValue()) {
                return true;
            }
            if (resolvedRight.accept(this, pVariable).booleanValue()) {
                return true;
            }
        }
        if (resolvedLeft.accept(this, pOther).booleanValue()) {
            return true;
        }
        return this.visitDefault((InvariantsFormula<CompoundInterval>)pVariable, pOther);
    }
}

