/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class ToBitvectorFormulaVisitor
implements ToFormulaVisitor<CompoundInterval, BitvectorFormula> {
    private final BooleanFormulaManager bfmgr;
    private final BitvectorFormulaManager bvfmgr;
    private final ToFormulaVisitor<CompoundInterval, BooleanFormula> toBooleanFormulaVisitor;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final int size;
    private final Map<String, CType> types;
    private final MachineModel machineModel;

    ToBitvectorFormulaVisitor(FormulaManagerView pFmgr, ToFormulaVisitor<CompoundInterval, BooleanFormula> pToBooleanFormulaVisitor, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, int pSize, Map<String, CType> pTypes, MachineModel pMachineModel) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.bvfmgr = pFmgr.getBitvectorFormulaManager();
        this.toBooleanFormulaVisitor = pToBooleanFormulaVisitor;
        this.evaluationVisitor = pEvaluationVisitor;
        this.size = pSize;
        this.types = pTypes;
        this.machineModel = pMachineModel;
    }

    private BitvectorFormula makeVariable(String pVariableName) {
        CType type = this.types.get(pVariableName);
        if (type == null) {
            return null;
        }
        int variableSize = this.machineModel.getSizeof(type) * this.machineModel.getSizeofCharInBits();
        BitvectorFormula variable = this.bvfmgr.makeVariable(variableSize, pVariableName);
        if (this.size <= variableSize) {
            return this.bvfmgr.extract(variable, this.size - 1, 0);
        }
        return this.bvfmgr.concat(this.bvfmgr.makeBitvector(this.size - variableSize, 0L), variable);
    }

    @Nullable
    private BitvectorFormula evaluate(InvariantsFormula<CompoundInterval> pFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval intervals = (CompoundInterval)pFormula.accept(this.evaluationVisitor, pEnvironment);
        if (intervals.isSingleton()) {
            boolean negative;
            BigInteger value = intervals.getValue();
            BigInteger upperExclusive = BigInteger.valueOf(2L).pow(this.size);
            boolean bl = negative = value.signum() < 0;
            if (negative && !value.equals(upperExclusive.shiftRight(1).negate())) {
                value = value.negate();
                value = value.and(BigInteger.valueOf(2L).pow(this.size - 1).subtract(BigInteger.valueOf(1L))).negate();
            } else if (!negative) {
                value = value.and(BigInteger.valueOf(2L).pow(this.size).subtract(BigInteger.valueOf(1L)));
            }
            return this.bvfmgr.makeBitvector(this.size, value);
        }
        return null;
    }

    @Nullable
    private BitvectorFormula fromBooleanFormula(InvariantsFormula<CompoundInterval> pBooleanFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula((BooleanFormula)pBooleanFormula.accept(this.toBooleanFormulaVisitor, pEnvironment));
    }

    @Nullable
    private BitvectorFormula fromBooleanFormula(@Nullable BooleanFormula pBooleanFormula) {
        if (pBooleanFormula == null) {
            return null;
        }
        return this.bfmgr.ifThenElse(pBooleanFormula, this.bvfmgr.makeBitvector(this.size, BigInteger.ONE), this.bvfmgr.makeBitvector(this.size, BigInteger.ZERO));
    }

    @Override
    public BitvectorFormula visit(Add<CompoundInterval> pAdd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula summand1 = pAdd.getSummand1().accept(this, pEnvironment);
        BitvectorFormula summand2 = pAdd.getSummand2().accept(this, pEnvironment);
        if (summand1 == null || summand2 == null) {
            return this.evaluate(pAdd, pEnvironment);
        }
        return this.bvfmgr.add(summand1, summand2);
    }

    @Override
    public BitvectorFormula visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pAnd, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pNot, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryOr<CompoundInterval> pOr, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pOr, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryXor<CompoundInterval> pXor, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pXor, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Constant<CompoundInterval> pConstant, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pConstant, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Divide<CompoundInterval> pDivide, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula numerator = pDivide.getNumerator().accept(this, pEnvironment);
        BitvectorFormula denominator = pDivide.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pDivide, pEnvironment);
        }
        return this.bvfmgr.divide(numerator, denominator, true);
    }

    @Override
    public BitvectorFormula visit(Equal<CompoundInterval> pEqual, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pEqual, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Exclusion<CompoundInterval> pExclusion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pExclusion, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(LessThan<CompoundInterval> pLessThan, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pLessThan, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pAnd, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(LogicalNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pNot, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Modulo<CompoundInterval> pModulo, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula numerator = pModulo.getNumerator().accept(this, pEnvironment);
        BitvectorFormula denominator = pModulo.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pModulo, pEnvironment);
        }
        return this.bvfmgr.modulo(numerator, denominator, true);
    }

    @Override
    public BitvectorFormula visit(Multiply<CompoundInterval> pMultiply, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula factor1 = pMultiply.getFactor1().accept(this, pEnvironment);
        BitvectorFormula factor2 = pMultiply.getFactor2().accept(this, pEnvironment);
        if (factor1 == null || factor2 == null) {
            return this.evaluate(pMultiply, pEnvironment);
        }
        return this.bvfmgr.multiply(factor1, factor2);
    }

    @Override
    public BitvectorFormula visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftLeft, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftRight, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Union<CompoundInterval> pUnion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pUnion, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Variable<CompoundInterval> pVariable, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.makeVariable(pVariable.getName());
    }

    @Override
    public BooleanFormula lessThan(BitvectorFormula pOp1, BitvectorFormula pOp2) {
        return this.bvfmgr.lessThan(pOp1, pOp2, true);
    }

    @Override
    public BooleanFormula equal(BitvectorFormula pOp1, BitvectorFormula pOp2) {
        return this.bvfmgr.equal(pOp1, pOp2);
    }

    @Override
    public BooleanFormula greaterThan(BitvectorFormula pOp1, BitvectorFormula pOp2) {
        return this.bvfmgr.greaterThan(pOp1, pOp2, true);
    }

    @Override
    public BooleanFormula lessOrEqual(BitvectorFormula pOp1, BitvectorFormula pOp2) {
        return this.bvfmgr.lessOrEquals(pOp1, pOp2, true);
    }

    @Override
    public BooleanFormula greaterOrEqual(BitvectorFormula pOp1, BitvectorFormula pOp2) {
        return this.bvfmgr.greaterOrEquals(pOp1, pOp2, true);
    }

    @Override
    public BooleanFormula asBoolean(BitvectorFormula pOp1) {
        return this.bfmgr.not(this.bvfmgr.equal(pOp1, this.bvfmgr.makeBitvector(this.bvfmgr.getLength(pOp1), BigInteger.ZERO)));
    }

    public static Integer getSize(InvariantsFormula<CompoundInterval> pFormula, Map<String, CType> pTypes, MachineModel pMachineModel) {
        return pFormula.accept(new GetSizeVisitor(pTypes, pMachineModel));
    }

    private static Integer decideSize(Integer pSize1, Integer pSize2) {
        if (pSize1 == null) {
            return pSize2;
        }
        if (pSize2 == null) {
            return pSize1;
        }
        return Math.max(pSize1, pSize2);
    }

    private static class GetSizeVisitor
    implements InvariantsFormulaVisitor<CompoundInterval, Integer> {
        private final Map<String, CType> types;
        private final MachineModel machineModel;

        public GetSizeVisitor(Map<String, CType> pTypes, MachineModel pMachineModel) {
            this.types = pTypes;
            this.machineModel = pMachineModel;
        }

        @Override
        public Integer visit(Add<CompoundInterval> pAdd) {
            Integer size1 = pAdd.getSummand1().accept(this);
            Integer size2 = pAdd.getSummand1().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(BinaryAnd<CompoundInterval> pAnd) {
            Integer size1 = pAnd.getOperand1().accept(this);
            Integer size2 = pAnd.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(BinaryNot<CompoundInterval> pNot) {
            return pNot.getFlipped().accept(this);
        }

        @Override
        public Integer visit(BinaryOr<CompoundInterval> pOr) {
            Integer size1 = pOr.getOperand1().accept(this);
            Integer size2 = pOr.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(BinaryXor<CompoundInterval> pXor) {
            Integer size1 = pXor.getOperand1().accept(this);
            Integer size2 = pXor.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Constant<CompoundInterval> pConstant) {
            return null;
        }

        @Override
        public Integer visit(Divide<CompoundInterval> pDivide) {
            Integer size1 = pDivide.getNumerator().accept(this);
            Integer size2 = pDivide.getDenominator().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Equal<CompoundInterval> pEqual) {
            Integer size1 = pEqual.getOperand1().accept(this);
            Integer size2 = pEqual.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Exclusion<CompoundInterval> pExclusion) {
            return pExclusion.getExcluded().accept(this);
        }

        @Override
        public Integer visit(LessThan<CompoundInterval> pLessThan) {
            Integer size1 = pLessThan.getOperand1().accept(this);
            Integer size2 = pLessThan.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(LogicalAnd<CompoundInterval> pAnd) {
            Integer size1 = pAnd.getOperand1().accept(this);
            Integer size2 = pAnd.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(LogicalNot<CompoundInterval> pNot) {
            return pNot.getNegated().accept(this);
        }

        @Override
        public Integer visit(Modulo<CompoundInterval> pModulo) {
            Integer size1 = pModulo.getNumerator().accept(this);
            Integer size2 = pModulo.getDenominator().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Multiply<CompoundInterval> pMultiply) {
            Integer size1 = pMultiply.getFactor1().accept(this);
            Integer size2 = pMultiply.getFactor2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(ShiftLeft<CompoundInterval> pShiftLeft) {
            Integer size1 = pShiftLeft.getShifted().accept(this);
            Integer size2 = pShiftLeft.getShiftDistance().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(ShiftRight<CompoundInterval> pShiftRight) {
            Integer size1 = pShiftRight.getShifted().accept(this);
            Integer size2 = pShiftRight.getShiftDistance().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Union<CompoundInterval> pUnion) {
            Integer size1 = pUnion.getOperand1().accept(this);
            Integer size2 = pUnion.getOperand2().accept(this);
            return ToBitvectorFormulaVisitor.decideSize(size1, size2);
        }

        @Override
        public Integer visit(Variable<CompoundInterval> pVariable) {
            CType type = this.types.get(pVariable.getName());
            if (type == null) {
                return null;
            }
            return this.machineModel.getSizeof(type) * this.machineModel.getSizeofCharInBits();
        }
    }
}

