/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToBitvectorFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public class ToBooleanFormulaVisitor<ValueFormulaType>
implements ToFormulaVisitor<CompoundInterval, BooleanFormula> {
    private final BooleanFormulaManager bfmgr;
    private final MachineModel machineModel;
    private final Map<String, CType> types;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final boolean useBitvectors;
    private final ToValueFormulaVisitorProvider<ValueFormulaType> toValueFormulaVisitorProvider;

    public static ToFormulaVisitor<CompoundInterval, BooleanFormula> getVisitor(final FormulaManagerView pFmgr, final FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, boolean pUseBitvectors, final MachineModel pMachineModel, final Map<String, CType> pVariableTypes) {
        if (pUseBitvectors) {
            return new ToBooleanFormulaVisitor<BitvectorFormula>(pFmgr, pUseBitvectors, pEvaluationVisitor, pMachineModel, pVariableTypes, new ToValueFormulaVisitorProvider<BitvectorFormula>(){

                @Override
                public ToFormulaVisitor<CompoundInterval, BitvectorFormula> getValueVisitor(Integer pSize, ToBooleanFormulaVisitor<BitvectorFormula> pToBooleanFormulaVisitor) {
                    return new ToBitvectorFormulaVisitor(pFmgr, pToBooleanFormulaVisitor, pEvaluationVisitor, pSize, pVariableTypes, pMachineModel);
                }
            });
        }
        return new ToBooleanFormulaVisitor<NumeralFormula>(pFmgr, pUseBitvectors, pEvaluationVisitor, pMachineModel, pVariableTypes, new ToValueFormulaVisitorProvider<NumeralFormula>(){

            @Override
            public ToFormulaVisitor<CompoundInterval, NumeralFormula> getValueVisitor(Integer pSize, ToBooleanFormulaVisitor<NumeralFormula> pToBooleanFormulaVisitor) {
                NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> mgr = pFmgr.getRationalFormulaManager();
                return new ToNumeralFormulaVisitor<NumeralFormula>(pFmgr, mgr, pToBooleanFormulaVisitor, pEvaluationVisitor);
            }
        });
    }

    private ToBooleanFormulaVisitor(FormulaManagerView pFmgr, boolean pUseBitvectors, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, MachineModel pMachineModel, Map<String, CType> pTypes, ToValueFormulaVisitorProvider<ValueFormulaType> pToValueFormulaVisitorProvider) {
        this.toValueFormulaVisitorProvider = pToValueFormulaVisitorProvider;
        this.machineModel = pMachineModel;
        this.types = pTypes;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.evaluationVisitor = pEvaluationVisitor;
        this.useBitvectors = pUseBitvectors;
    }

    private ToFormulaVisitor<CompoundInterval, ValueFormulaType> getValueVisitor(InvariantsFormula<CompoundInterval> pFormula) {
        Integer size = ToBitvectorFormulaVisitor.getSize(pFormula, this.types, this.machineModel);
        return this.getValueVisitor(size);
    }

    private ToFormulaVisitor<CompoundInterval, ValueFormulaType> getValueVisitor(Integer pSize) {
        return this.toValueFormulaVisitorProvider.getValueVisitor(pSize, this);
    }

    @Nullable
    private BooleanFormula fromValueFormula(InvariantsFormula<CompoundInterval> pValueFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        Object valueFormula = pValueFormula.accept(this.getValueVisitor(pValueFormula), pEnvironment);
        if (valueFormula == null) {
            return this.evaluateAsBoolean(pValueFormula, pEnvironment);
        }
        return this.getValueVisitor(pValueFormula).asBoolean(valueFormula);
    }

    private BooleanFormula evaluateAsBoolean(InvariantsFormula<CompoundInterval> pValueFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval value = (CompoundInterval)pValueFormula.accept(this.evaluationVisitor, pEnvironment);
        if (value.isDefinitelyFalse()) {
            return this.bfmgr.makeBoolean(false);
        }
        if (value.isDefinitelyTrue()) {
            return this.bfmgr.makeBoolean(true);
        }
        return null;
    }

    @Override
    public BooleanFormula visit(Add<CompoundInterval> pAdd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pAdd, pEnvironment);
    }

    @Override
    public BooleanFormula visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pAnd, pEnvironment);
    }

    @Override
    public BooleanFormula visit(BinaryNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pNot, pEnvironment);
    }

    @Override
    public BooleanFormula visit(BinaryOr<CompoundInterval> pOr, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pOr, pEnvironment);
    }

    @Override
    public BooleanFormula visit(BinaryXor<CompoundInterval> pXor, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pXor, pEnvironment);
    }

    @Override
    public BooleanFormula visit(Constant<CompoundInterval> pConstant, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        Object valueFormula;
        CompoundInterval value = pConstant.getValue();
        if (value.isDefinitelyTrue()) {
            return this.bfmgr.makeBoolean(true);
        }
        if (value.isDefinitelyFalse()) {
            return this.bfmgr.makeBoolean(false);
        }
        int size = 0;
        if (value.hasLowerBound()) {
            size = value.getLowerBound().bitLength();
        }
        if (value.hasUpperBound()) {
            size = Math.max(size, value.getUpperBound().bitLength());
        }
        if ((valueFormula = pConstant.accept(this.getValueVisitor(size), pEnvironment)) == null) {
            return null;
        }
        return this.getValueVisitor(pConstant).asBoolean(valueFormula);
    }

    @Override
    public BooleanFormula visit(Divide<CompoundInterval> pDivide, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pDivide, pEnvironment);
    }

    @Override
    public BooleanFormula visit(Equal<CompoundInterval> pEqual, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        Integer size = ToBitvectorFormulaVisitor.getSize(pEqual, this.types, this.machineModel);
        if (size == null) {
            if (this.useBitvectors) {
                return null;
            }
            size = 0;
        }
        Object operand1 = pEqual.getOperand1().accept(this.getValueVisitor(pEqual), pEnvironment);
        Object operand2 = pEqual.getOperand2().accept(this.getValueVisitor(pEqual), pEnvironment);
        if (operand1 == null && operand2 == null) {
            return this.evaluateAsBoolean(pEqual, pEnvironment);
        }
        if (operand1 == null || operand2 == null) {
            InvariantsFormula<CompoundInterval> right;
            Object left;
            if (operand1 != null) {
                left = operand1;
                right = pEqual.getOperand2();
            } else {
                left = operand2;
                right = pEqual.getOperand1();
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            BooleanFormula bf = this.bfmgr.makeBoolean(false);
            for (SimpleInterval interval : rightValue.getIntervals()) {
                BooleanFormula intervalFormula = this.bfmgr.makeBoolean(true);
                if (interval.isSingleton()) {
                    ValueFormulaType value = this.getValueFormula(interval.getLowerBound(), pEnvironment, size);
                    intervalFormula = this.bfmgr.and(intervalFormula, this.getValueVisitor(pEqual).equal(left, value));
                } else {
                    if (interval.hasLowerBound()) {
                        ValueFormulaType lb = this.getValueFormula(interval.getLowerBound(), pEnvironment, size);
                        intervalFormula = this.bfmgr.and(intervalFormula, this.getValueVisitor(pEqual).greaterOrEqual(left, lb));
                    }
                    if (interval.hasUpperBound()) {
                        ValueFormulaType ub = this.getValueFormula(interval.getUpperBound(), pEnvironment, size);
                        intervalFormula = this.bfmgr.and(intervalFormula, this.getValueVisitor(pEqual).lessOrEqual(left, ub));
                    }
                }
                bf = this.bfmgr.or(bf, intervalFormula);
            }
            return bf;
        }
        return this.getValueVisitor(pEqual).equal(operand1, operand2);
    }

    @Override
    public BooleanFormula visit(Exclusion<CompoundInterval> pExclusion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pExclusion, pEnvironment);
    }

    private ValueFormulaType getValueFormula(BigInteger pValue, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment, int pSize) {
        return (ValueFormulaType)CompoundIntervalFormulaManager.INSTANCE.asConstant(CompoundInterval.singleton(pValue)).accept(this.getValueVisitor(pSize), pEnvironment);
    }

    @Override
    public BooleanFormula visit(LessThan<CompoundInterval> pLessThan, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        Integer size = ToBitvectorFormulaVisitor.getSize(pLessThan, this.types, this.machineModel);
        if (size == null) {
            if (this.useBitvectors) {
                return null;
            }
            size = 0;
        }
        Object operand1 = pLessThan.getOperand1().accept(this.getValueVisitor(pLessThan), pEnvironment);
        Object operand2 = pLessThan.getOperand2().accept(this.getValueVisitor(pLessThan), pEnvironment);
        if (operand1 == null && operand2 == null) {
            return this.evaluateAsBoolean(pLessThan, pEnvironment);
        }
        if (operand1 == null || operand2 == null) {
            boolean lessThan;
            InvariantsFormula<CompoundInterval> right;
            Object left;
            if (operand1 != null) {
                left = operand1;
                right = pLessThan.getOperand2();
                lessThan = true;
            } else {
                left = operand2;
                right = pLessThan.getOperand1();
                lessThan = false;
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            if (rightValue.isBottom()) {
                return this.bfmgr.makeBoolean(false);
            }
            if (lessThan) {
                if (rightValue.hasUpperBound()) {
                    return this.getValueVisitor(pLessThan).lessThan(left, this.getValueFormula(rightValue.getUpperBound(), pEnvironment, size));
                }
            } else if (rightValue.hasLowerBound()) {
                return this.getValueVisitor(pLessThan).greaterThan(left, this.getValueFormula(rightValue.getLowerBound(), pEnvironment, size));
            }
            return null;
        }
        return this.getValueVisitor(pLessThan).lessThan(operand1, operand2);
    }

    @Override
    public BooleanFormula visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BooleanFormula operand1 = pAnd.getOperand1().accept(this, pEnvironment);
        BooleanFormula operand2 = pAnd.getOperand2().accept(this, pEnvironment);
        if (operand1 == null || operand2 == null) {
            return this.evaluateAsBoolean(pAnd, pEnvironment);
        }
        return this.bfmgr.and(operand1, operand2);
    }

    @Override
    public BooleanFormula visit(LogicalNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        BooleanFormula operand = pNot.getNegated().accept(this, pEnvironment);
        if (operand == null) {
            return this.evaluateAsBoolean(pNot, pEnvironment);
        }
        return this.bfmgr.not(operand);
    }

    @Override
    public BooleanFormula visit(Modulo<CompoundInterval> pModulo, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pModulo, pEnvironment);
    }

    @Override
    public BooleanFormula visit(Multiply<CompoundInterval> pMultiply, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pMultiply, pEnvironment);
    }

    @Override
    public BooleanFormula visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pShiftLeft, pEnvironment);
    }

    @Override
    public BooleanFormula visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pShiftRight, pEnvironment);
    }

    @Override
    public BooleanFormula visit(Union<CompoundInterval> pUnion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pUnion, pEnvironment);
    }

    @Override
    public BooleanFormula visit(Variable<CompoundInterval> pVariable, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromValueFormula(pVariable, pEnvironment);
    }

    @Override
    public BooleanFormula lessThan(BooleanFormula pOp1, BooleanFormula pOp2) {
        return this.bfmgr.and(this.bfmgr.not(pOp1), pOp2);
    }

    @Override
    public BooleanFormula equal(BooleanFormula pOp1, BooleanFormula pOp2) {
        return this.bfmgr.equivalence(pOp1, pOp2);
    }

    @Override
    public BooleanFormula greaterThan(BooleanFormula pOp1, BooleanFormula pOp2) {
        return this.bfmgr.and(pOp1, this.bfmgr.not(pOp2));
    }

    @Override
    public BooleanFormula lessOrEqual(BooleanFormula pOp1, BooleanFormula pOp2) {
        return this.bfmgr.not(this.greaterThan(pOp1, pOp2));
    }

    @Override
    public BooleanFormula greaterOrEqual(BooleanFormula pOp1, BooleanFormula pOp2) {
        return this.bfmgr.not(this.lessThan(pOp1, pOp2));
    }

    @Override
    public BooleanFormula asBoolean(BooleanFormula pOp1) {
        return pOp1;
    }

    private static interface ToValueFormulaVisitorProvider<ValueFormulaType> {
        public ToFormulaVisitor<CompoundInterval, ValueFormulaType> getValueVisitor(Integer var1, ToBooleanFormulaVisitor<ValueFormulaType> var2);
    }
}

