/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class ToNumeralFormulaVisitor<T extends NumeralFormula>
implements ToFormulaVisitor<CompoundInterval, T> {
    private final BooleanFormulaManager bfmgr;
    private final NumeralFormulaManager<? super T, ? extends T> nfmgr;
    private final T zero;
    private final T one;
    private final ToFormulaVisitor<CompoundInterval, BooleanFormula> toBooleanFormulaVisitor;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;

    ToNumeralFormulaVisitor(FormulaManagerView pFmgr, NumeralFormulaManager<? super T, ? extends T> pNumeralFormualManager, ToFormulaVisitor<CompoundInterval, BooleanFormula> pToBooleanFormulaVisitor, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.nfmgr = pNumeralFormualManager;
        this.zero = this.nfmgr.makeNumber(0L);
        this.one = this.nfmgr.makeNumber(1L);
        this.toBooleanFormulaVisitor = pToBooleanFormulaVisitor;
        this.evaluationVisitor = pEvaluationVisitor;
    }

    @Nullable
    private T evaluate(InvariantsFormula<CompoundInterval> pFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval value = (CompoundInterval)pFormula.accept(this.evaluationVisitor, pEnvironment);
        if (value.isSingleton()) {
            return this.nfmgr.makeNumber(value.getLowerBound());
        }
        return null;
    }

    @Nullable
    private T fromBooleanFormula(InvariantsFormula<CompoundInterval> pBooleanFormula, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula((BooleanFormula)pBooleanFormula.accept(this.toBooleanFormulaVisitor, pEnvironment));
    }

    @Nullable
    private T fromBooleanFormula(@Nullable BooleanFormula pBooleanFormula) {
        if (pBooleanFormula == null) {
            return null;
        }
        return (T)((NumeralFormula)this.bfmgr.ifThenElse(pBooleanFormula, this.one, this.zero));
    }

    @Override
    public T visit(Add<CompoundInterval> pAdd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula summand1 = (NumeralFormula)pAdd.getSummand1().accept(this, pEnvironment);
        NumeralFormula summand2 = (NumeralFormula)pAdd.getSummand2().accept(this, pEnvironment);
        if (summand1 == null || summand2 == null) {
            return this.evaluate(pAdd, pEnvironment);
        }
        return this.nfmgr.add(summand1, summand2);
    }

    @Override
    public T visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pAnd, pEnvironment);
    }

    @Override
    public T visit(BinaryNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pNot, pEnvironment);
    }

    @Override
    public T visit(BinaryOr<CompoundInterval> pOr, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pOr, pEnvironment);
    }

    @Override
    public T visit(BinaryXor<CompoundInterval> pXor, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pXor, pEnvironment);
    }

    @Override
    public T visit(Constant<CompoundInterval> pConstant, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pConstant, pEnvironment);
    }

    @Override
    public T visit(Divide<CompoundInterval> pDivide, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula numerator = (NumeralFormula)pDivide.getNumerator().accept(this, pEnvironment);
        NumeralFormula denominator = (NumeralFormula)pDivide.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pDivide, pEnvironment);
        }
        return this.nfmgr.divide(numerator, denominator);
    }

    @Override
    public T visit(Equal<CompoundInterval> pEqual, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pEqual, pEnvironment);
    }

    @Override
    public T visit(Exclusion<CompoundInterval> pExclusion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pExclusion, pEnvironment);
    }

    @Override
    public T visit(LessThan<CompoundInterval> pLessThan, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pLessThan, pEnvironment);
    }

    @Override
    public T visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pAnd, pEnvironment);
    }

    @Override
    public T visit(LogicalNot<CompoundInterval> pNot, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.fromBooleanFormula(pNot, pEnvironment);
    }

    @Override
    public T visit(Modulo<CompoundInterval> pModulo, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula numerator = (NumeralFormula)pModulo.getNumerator().accept(this, pEnvironment);
        NumeralFormula denominator = (NumeralFormula)pModulo.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pModulo, pEnvironment);
        }
        return this.nfmgr.modulo(numerator, denominator);
    }

    @Override
    public T visit(Multiply<CompoundInterval> pMultiply, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula factor1 = (NumeralFormula)pMultiply.getFactor1().accept(this, pEnvironment);
        NumeralFormula factor2 = (NumeralFormula)pMultiply.getFactor2().accept(this, pEnvironment);
        if (factor1 == null || factor2 == null) {
            return this.evaluate(pMultiply, pEnvironment);
        }
        return this.nfmgr.multiply(factor1, factor2);
    }

    @Override
    public T visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftLeft, pEnvironment);
    }

    @Override
    public T visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftRight, pEnvironment);
    }

    @Override
    public T visit(Union<CompoundInterval> pUnion, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pUnion, pEnvironment);
    }

    @Override
    public T visit(Variable<CompoundInterval> pVariable, Map<? extends String, ? extends InvariantsFormula<CompoundInterval>> pEnvironment) {
        return this.nfmgr.makeVariable(pVariable.getName());
    }

    @Override
    public BooleanFormula lessThan(T pOp1, T pOp2) {
        return this.nfmgr.lessThan(pOp1, pOp2);
    }

    @Override
    public BooleanFormula equal(T pOp1, T pOp2) {
        return this.nfmgr.equal(pOp1, pOp2);
    }

    @Override
    public BooleanFormula greaterThan(T pOp1, T pOp2) {
        return this.nfmgr.greaterThan(pOp1, pOp2);
    }

    @Override
    public BooleanFormula lessOrEqual(T pOp1, T pOp2) {
        return this.nfmgr.lessOrEquals(pOp1, pOp2);
    }

    @Override
    public BooleanFormula greaterOrEqual(T pOp1, T pOp2) {
        return this.nfmgr.greaterOrEquals(pOp1, pOp2);
    }

    @Override
    public BooleanFormula asBoolean(T pOp1) {
        return this.bfmgr.not(this.nfmgr.equal(pOp1, this.nfmgr.makeNumber(0L)));
    }
}

