/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula.variablerelations;

import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.cpa.invariants.formula.variablerelations.VariableRelation;

public abstract class AbstractVariableRelation<ConstantType>
implements VariableRelation<ConstantType> {
    private final Object compatibilityKey;
    private final InvariantsFormula<ConstantType> invariantsFormula;
    private final Variable<ConstantType> operand1;
    private final Variable<ConstantType> operand2;

    public AbstractVariableRelation(InvariantsFormula<ConstantType> pInvariantsFormula, Variable<ConstantType> pOperand1, Variable<ConstantType> pOperand2) {
        this.invariantsFormula = pInvariantsFormula;
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
        this.compatibilityKey = new CompatibilityKey(pOperand1, pOperand2);
    }

    @Override
    public InvariantsFormula<ConstantType> getInvariantsFormula() {
        return this.invariantsFormula;
    }

    @Override
    public Variable<ConstantType> getOperand1() {
        return this.operand1;
    }

    @Override
    public Variable<ConstantType> getOperand2() {
        return this.operand2;
    }

    public int hashCode() {
        return this.operand1.hashCode() * 317 * this.operand2.hashCode() + 43;
    }

    public abstract boolean equals(Object var1);

    @Override
    public boolean isCompatibleWith(VariableRelation<ConstantType> pOther) {
        return this.getCompatibilityKey().equals(pOther.getCompatibilityKey());
    }

    public String toString() {
        return this.getInvariantsFormula().toString();
    }

    @Override
    public Object getCompatibilityKey() {
        return this.compatibilityKey;
    }

    private static class CompatibilityKey {
        private final String var1;
        private final String var2;

        public CompatibilityKey(Variable<?> pVarA, Variable<?> pVarB) {
            if (pVarA.getName().compareTo(pVarB.getName()) <= 0) {
                this.var1 = pVarA.getName();
                this.var2 = pVarB.getName();
            } else {
                this.var1 = pVarB.getName();
                this.var2 = pVarA.getName();
            }
        }

        public String toString() {
            return String.format("(%s, %s)", this.var1, this.var2);
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (pO instanceof CompatibilityKey) {
                CompatibilityKey other = (CompatibilityKey)pO;
                return this.var1.equals(other.var1) && this.var2.equals(other.var2);
            }
            return false;
        }

        public int hashCode() {
            return this.var1.hashCode() * 43 + 31 + this.var2.hashCode();
        }
    }
}

