/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula.variablerelations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.formula.variablerelations.VariableRelation;

public class VariableRelationSet<ConstantType>
implements Set<VariableRelation<ConstantType>> {
    private final Map<Object, VariableRelation<ConstantType>> backingMap;

    public VariableRelationSet() {
        this.backingMap = new HashMap<Object, VariableRelation<ConstantType>>();
    }

    public VariableRelationSet(Collection<VariableRelation<ConstantType>> pRelations) {
        this();
        this.addAll(pRelations);
    }

    public VariableRelationSet(VariableRelationSet<ConstantType> pOther) {
        this(pOther.backingMap);
    }

    private VariableRelationSet(Map<Object, VariableRelation<ConstantType>> pOtherBackingMap) {
        this.backingMap = new HashMap<Object, VariableRelation<ConstantType>>(pOtherBackingMap);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean contains(Object pO) {
        return this.backingMap.values().contains(pO);
    }

    @Override
    public Iterator<VariableRelation<ConstantType>> iterator() {
        return this.backingMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backingMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] pA) {
        return this.backingMap.values().toArray(pA);
    }

    @Override
    public boolean add(VariableRelation<ConstantType> pE) {
        return this.refineBy(pE);
    }

    public boolean uniteWith(VariableRelation<ConstantType> pE) {
        VariableRelation<ConstantType> previous = this.backingMap.get(pE.getCompatibilityKey());
        if (previous == null || previous.equals(pE)) {
            return false;
        }
        VariableRelation<ConstantType> newRelation = previous.union(pE);
        this.put(pE.getCompatibilityKey(), newRelation);
        return true;
    }

    public boolean uniteWith(VariableRelationSet<ConstantType> pOther) {
        boolean changed = this.backingMap.keySet().retainAll(pOther.backingMap.keySet());
        for (VariableRelation<ConstantType> other : pOther.backingMap.values()) {
            changed |= this.uniteWith(other);
        }
        return changed;
    }

    public boolean refineBy(Collection<VariableRelation<ConstantType>> pC) {
        boolean changed = false;
        for (VariableRelation<ConstantType> variableRelation : pC) {
            changed |= this.refineBy(variableRelation);
        }
        return changed;
    }

    public boolean refineBy(VariableRelation<ConstantType> pE) {
        VariableRelation<ConstantType> previous = this.backingMap.get(pE.getCompatibilityKey());
        if (previous == null) {
            this.backingMap.put(pE.getCompatibilityKey(), pE);
            return true;
        }
        VariableRelation<ConstantType> newRelation = previous.intersect(pE);
        if (previous.equals(newRelation)) {
            return false;
        }
        this.put(pE.getCompatibilityKey(), newRelation);
        return true;
    }

    private void put(Object pKey, VariableRelation<ConstantType> pValue) {
        if (pValue == null) {
            this.backingMap.remove(pKey);
        } else {
            this.backingMap.put(pKey, pValue);
        }
    }

    @Override
    public boolean remove(Object pO) {
        if (pO instanceof VariableRelation) {
            return this.backingMap.remove(((VariableRelation)pO).getCompatibilityKey()) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> pC) {
        return this.backingMap.values().containsAll(pC);
    }

    @Override
    public boolean addAll(Collection<? extends VariableRelation<ConstantType>> pC) {
        boolean added = false;
        for (VariableRelation<ConstantType> relation : pC) {
            added |= this.add(relation);
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> pC) {
        return this.backingMap.values().retainAll(pC);
    }

    @Override
    public boolean removeAll(Collection<?> pC) {
        return this.backingMap.values().removeAll(pC);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public String toString() {
        return this.backingMap.values().toString();
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof VariableRelationSet) {
            return this.backingMap.equals(((VariableRelationSet)pO).backingMap);
        }
        if (pO instanceof Set) {
            Set other = (Set)pO;
            return this.containsAll(other) && other.containsAll(this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }
}

