/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IICOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public enum ICCOperator implements Operator<SimpleInterval, CompoundInterval, CompoundInterval>
{
    ADD{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            return pSecondOperand.add(pFirstOperand);
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundInterval current = IICOperator.DIVIDE.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    MODULO{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundInterval current = IICOperator.MODULO.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            return pSecondOperand.multiply(pFirstOperand);
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundInterval current = IICOperator.SHIFT_LEFT.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, CompoundInterval pSecondOperand) {
            CompoundInterval result = CompoundInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundInterval current = IICOperator.SHIFT_RIGHT.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    };


    @Override
    public abstract CompoundInterval apply(SimpleInterval var1, CompoundInterval var2);
}

