/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IIIOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ISCOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public enum IICOperator implements Operator<SimpleInterval, SimpleInterval, CompoundInterval>
{
    ADD{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundInterval.of(IIIOperator.ADD.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundInterval.of(IIIOperator.DIVIDE.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    MODULO{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (!pSecondOperand.hasLowerBound() || !pSecondOperand.hasUpperBound()) {
                return CompoundInterval.of(pFirstOperand);
            }
            return CompoundInterval.of(pFirstOperand).modulo(pSecondOperand.getLowerBound().abs().max(pSecondOperand.getUpperBound().abs()));
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundInterval.of(IIIOperator.MULTIPLY.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return CompoundInterval.of(pFirstOperand);
            }
            CompoundInterval result = CompoundInterval.bottom();
            if (pSecondOperand.containsZero()) {
                result = result.unionWith(pFirstOperand);
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                result = result.unionWith(SHIFT_RIGHT.apply(pFirstOperand, negPart.negate()));
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                CompoundInterval posPartResult = ISCOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getLowerBound());
                if (posPart.hasUpperBound()) {
                    posPartResult = CompoundInterval.span(posPartResult, ISCOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getUpperBound()));
                } else {
                    if (pFirstOperand.containsPositive()) {
                        posPartResult = posPartResult.extendToPositiveInfinity();
                    }
                    if (pFirstOperand.containsNegative()) {
                        posPartResult = posPartResult.extendToNegativeInfinity();
                    }
                }
                result = result.unionWith(posPartResult);
            }
            return result;
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return CompoundInterval.of(pFirstOperand);
            }
            CompoundInterval result = CompoundInterval.bottom();
            if (pSecondOperand.containsZero()) {
                result = result.unionWith(pFirstOperand);
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                result = result.unionWith(SHIFT_LEFT.apply(pFirstOperand, negPart.negate()));
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                CompoundInterval posPartResult = ISCOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getLowerBound());
                posPartResult = posPart.hasUpperBound() ? CompoundInterval.span(posPartResult, ISCOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getUpperBound())) : CompoundInterval.span(posPartResult, CompoundInterval.singleton(BigInteger.ZERO));
                result = result.unionWith(posPartResult);
            }
            return result;
        }
    };


    @Override
    public abstract CompoundInterval apply(SimpleInterval var1, SimpleInterval var2);
}

