/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ISIOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IntervalHelper;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public enum IIIOperator implements Operator<SimpleInterval, SimpleInterval, SimpleInterval>
{
    ADD{

        @Override
        public SimpleInterval apply(SimpleInterval pOperand1, SimpleInterval pOperand2) {
            if (pOperand1.isTop()) {
                return pOperand1;
            }
            if (pOperand2.isTop()) {
                return pOperand2;
            }
            if (pOperand2.isSingleton()) {
                return ISIOperator.ADD.apply(pOperand1, pOperand2.getLowerBound());
            }
            if (pOperand1.isSingleton()) {
                return ISIOperator.ADD.apply(pOperand2, pOperand1.getLowerBound());
            }
            BigInteger lowerBound = IntervalHelper.getLowerBoundOrNull(pOperand1);
            BigInteger upperBound = IntervalHelper.getUpperBoundOrNull(pOperand1);
            BigInteger pLowerBound = IntervalHelper.getLowerBoundOrNull(pOperand2);
            BigInteger pUpperBound = IntervalHelper.getUpperBoundOrNull(pOperand2);
            if (lowerBound != null) {
                lowerBound = pLowerBound == null ? null : lowerBound.add(pLowerBound);
            }
            if (upperBound != null) {
                upperBound = pUpperBound == null ? null : upperBound.add(pUpperBound);
            }
            return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
        }
    }
    ,
    DIVIDE{

        @Override
        @Nullable
        public SimpleInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            boolean posInf;
            if (pSecondOperand.isSingleton()) {
                return ISIOperator.DIVIDE.apply(pFirstOperand, pSecondOperand.getLowerBound());
            }
            if (pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            boolean negInf = !pFirstOperand.hasLowerBound() && pSecondOperand.containsPositive() || !pFirstOperand.hasUpperBound() && pSecondOperand.containsNegative();
            boolean bl = posInf = !pFirstOperand.hasLowerBound() && pSecondOperand.containsNegative() || !pFirstOperand.hasUpperBound() && pSecondOperand.containsPositive();
            if (negInf && posInf) {
                return SimpleInterval.infinite();
            }
            BigInteger lowerBound = null;
            BigInteger upperBound = null;
            if (!posInf) {
                upperBound = pFirstOperand.containsPositive() ? (pSecondOperand.containsPositive() ? pFirstOperand.getUpperBound().divide(pSecondOperand.closestPositiveToZero()) : (!pSecondOperand.hasLowerBound() ? BigInteger.ZERO : pFirstOperand.getLowerBound().divide(pSecondOperand.getLowerBound()))) : (pSecondOperand.containsPositive() ? (!pSecondOperand.hasUpperBound() ? BigInteger.ZERO : pFirstOperand.getUpperBound().divide(pSecondOperand.getUpperBound())) : pFirstOperand.getLowerBound().divide(pSecondOperand.closestNegativeToZero()));
            }
            if (!negInf) {
                lowerBound = pFirstOperand.containsNegative() ? (pSecondOperand.containsPositive() ? pFirstOperand.getLowerBound().divide(pSecondOperand.closestPositiveToZero()) : (!pSecondOperand.hasLowerBound() ? BigInteger.ZERO : pFirstOperand.getUpperBound().divide(pSecondOperand.getLowerBound()))) : (pSecondOperand.containsPositive() ? (!pSecondOperand.hasUpperBound() ? BigInteger.ZERO : pFirstOperand.getLowerBound().divide(pSecondOperand.getUpperBound())) : pFirstOperand.getUpperBound().divide(pSecondOperand.closestNegativeToZero()));
            }
            return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
        }
    }
    ,
    MODULO{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (!pSecondOperand.hasLowerBound() || !pSecondOperand.hasUpperBound()) {
                return pFirstOperand;
            }
            return ISIOperator.MODULO.apply(pFirstOperand, pSecondOperand.getLowerBound().abs().max(pSecondOperand.getUpperBound().abs()));
        }
    }
    ,
    MULTIPLY{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pSecondOperand.isSingleton()) {
                return ISIOperator.MULTIPLY.apply(pFirstOperand, pSecondOperand.getLowerBound());
            }
            if (pFirstOperand.isSingleton()) {
                return ISIOperator.MULTIPLY.apply(pSecondOperand, pFirstOperand.getLowerBound());
            }
            if (pFirstOperand.isTop() || pSecondOperand.isTop()) {
                return SimpleInterval.infinite();
            }
            BigInteger pLowerBound = IntervalHelper.getLowerBoundOrNull(pSecondOperand);
            BigInteger pUpperBound = IntervalHelper.getUpperBoundOrNull(pSecondOperand);
            BigInteger lbLb = null;
            BigInteger lbUb = null;
            BigInteger ubLb = null;
            BigInteger ubUb = null;
            boolean negInf = false;
            boolean posInf = false;
            if (!pFirstOperand.hasLowerBound()) {
                if (pLowerBound == null || pLowerBound.signum() < 0) {
                    posInf = true;
                } else if (pLowerBound.signum() > 0) {
                    negInf = true;
                } else {
                    lbLb = ubLb = BigInteger.ZERO;
                }
                if (pUpperBound == null || pUpperBound.signum() > 0) {
                    negInf = true;
                } else if (pUpperBound.signum() < 0) {
                    posInf = true;
                }
            } else {
                int thisLowerBoundSignum = pFirstOperand.getLowerBound().signum();
                if (pLowerBound == null) {
                    if (thisLowerBoundSignum < 0) {
                        posInf = true;
                    } else if (thisLowerBoundSignum > 0) {
                        negInf = true;
                    } else {
                        lbLb = lbUb = BigInteger.ZERO;
                    }
                } else {
                    lbLb = pFirstOperand.getLowerBound().multiply(pLowerBound);
                }
                if (pUpperBound == null) {
                    if (thisLowerBoundSignum < 0) {
                        negInf = true;
                    } else if (thisLowerBoundSignum > 0) {
                        posInf = true;
                    } else {
                        lbLb = lbUb = BigInteger.ZERO;
                    }
                } else {
                    lbUb = pFirstOperand.getLowerBound().multiply(pUpperBound);
                }
            }
            if (!pFirstOperand.hasUpperBound()) {
                if (pLowerBound == null || pLowerBound.signum() < 0) {
                    negInf = true;
                } else if (pLowerBound.signum() > 0) {
                    posInf = true;
                } else {
                    lbLb = ubLb = BigInteger.ZERO;
                }
                if (pUpperBound == null || pUpperBound.signum() > 0) {
                    posInf = true;
                } else if (pUpperBound.signum() < 0) {
                    negInf = true;
                } else {
                    lbUb = ubUb = BigInteger.ZERO;
                }
            } else {
                int thisUpperBoundSignum = pFirstOperand.getUpperBound().signum();
                if (pLowerBound == null) {
                    if (thisUpperBoundSignum < 0) {
                        posInf = true;
                    } else if (thisUpperBoundSignum > 0) {
                        negInf = true;
                    } else {
                        ubLb = ubUb = BigInteger.ZERO;
                    }
                } else {
                    ubLb = pFirstOperand.getUpperBound().multiply(pLowerBound);
                }
                if (!pSecondOperand.hasUpperBound()) {
                    if (thisUpperBoundSignum < 0) {
                        negInf = true;
                    } else if (thisUpperBoundSignum > 0) {
                        posInf = true;
                    } else {
                        ubLb = ubUb = BigInteger.ZERO;
                    }
                } else {
                    ubUb = pFirstOperand.getUpperBound().multiply(pUpperBound);
                }
            }
            if (negInf && posInf) {
                return SimpleInterval.infinite();
            }
            BigInteger lowerBound = IIIOperator.min(IIIOperator.min(lbLb, lbUb), IIIOperator.min(ubLb, ubUb));
            BigInteger upperBound = IIIOperator.max(IIIOperator.max(lbLb, lbUb), IIIOperator.max(ubLb, ubUb));
            SimpleInterval result = IntervalHelper.ofNullableBounds(lowerBound, upperBound);
            if (negInf) {
                result = result.extendToNegativeInfinity();
            }
            if (posInf) {
                result = result.extendToPositiveInfinity();
            }
            return result;
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            SimpleInterval result = null;
            if (pSecondOperand.containsZero()) {
                result = pFirstOperand;
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                SimpleInterval negPartResult = SHIFT_RIGHT.apply(pFirstOperand, negPart.negate());
                SimpleInterval simpleInterval = result = result == null ? negPartResult : SimpleInterval.span(result, negPartResult);
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                SimpleInterval posPartResult = ISIOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getLowerBound());
                if (posPart.hasUpperBound()) {
                    posPartResult = SimpleInterval.span(posPartResult, ISIOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getUpperBound()));
                } else {
                    if (pFirstOperand.containsPositive()) {
                        posPartResult = posPartResult.extendToPositiveInfinity();
                    }
                    if (pFirstOperand.containsNegative()) {
                        posPartResult = posPartResult.extendToNegativeInfinity();
                    }
                }
                result = result == null ? posPartResult : SimpleInterval.span(result, posPartResult);
            }
            return result;
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            SimpleInterval result = null;
            if (pSecondOperand.containsZero()) {
                result = pFirstOperand;
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                SimpleInterval negPartResult = SHIFT_LEFT.apply(pFirstOperand, negPart.negate());
                SimpleInterval simpleInterval = result = result == null ? negPartResult : SimpleInterval.span(result, negPartResult);
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                SimpleInterval posPartResult = ISIOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getLowerBound());
                posPartResult = posPart.hasUpperBound() ? SimpleInterval.span(posPartResult, ISIOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getUpperBound())) : SimpleInterval.span(posPartResult, SimpleInterval.singleton(BigInteger.ZERO));
                result = result == null ? posPartResult : SimpleInterval.span(result, posPartResult);
            }
            return result;
        }
    };


    @Override
    public abstract SimpleInterval apply(SimpleInterval var1, SimpleInterval var2);

    @Nullable
    private static BigInteger max(@Nullable BigInteger first, @Nullable BigInteger second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.max(second);
    }

    @Nullable
    private static BigInteger min(@Nullable BigInteger first, @Nullable BigInteger second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.min(second);
    }
}

