/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IIIOperator;

public class IIIOperatorTest {
    @Test
    public void testAdd() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        Assert.assertEquals((Object)one, (Object)IIIOperator.ADD.apply(zero, one));
    }

    @Test
    public void testModulo() {
        BigInteger scalarFour = BigInteger.valueOf(4L);
        BigInteger scalarFive = BigInteger.valueOf(5L);
        SimpleInterval five = SimpleInterval.singleton(scalarFive);
        SimpleInterval negFourToFour = SimpleInterval.of(scalarFour.negate(), scalarFour);
        SimpleInterval zeroToFour = SimpleInterval.of(BigInteger.ZERO, scalarFour);
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        SimpleInterval tenToEleven = SimpleInterval.of(BigInteger.valueOf(10L), BigInteger.valueOf(11L));
        SimpleInterval twoToThree = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(3L));
        SimpleInterval zeroToTwo = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(2L));
        SimpleInterval eightToTen = SimpleInterval.of(BigInteger.valueOf(8L), BigInteger.TEN);
        Assert.assertEquals((Object)negFourToFour, (Object)IIIOperator.MODULO.apply(SimpleInterval.infinite(), five));
        Assert.assertEquals((Object)zeroToFour, (Object)IIIOperator.MODULO.apply(zeroToInf, five));
        Assert.assertEquals((Object)zeroToFour, (Object)IIIOperator.MODULO.apply(zeroToInf, five.negate()));
        Assert.assertEquals((Object)twoToThree, (Object)IIIOperator.MODULO.apply(tenToEleven, SimpleInterval.singleton(scalarFour)));
        Assert.assertEquals((Object)zeroToTwo, (Object)IIIOperator.MODULO.apply(eightToTen, SimpleInterval.singleton(scalarFour)));
        Assert.assertEquals((Object)twoToThree, (Object)IIIOperator.MODULO.apply(tenToEleven, SimpleInterval.singleton(scalarFour).negate()));
        Assert.assertEquals((Object)zeroToTwo, (Object)IIIOperator.MODULO.apply(eightToTen, SimpleInterval.singleton(scalarFour).negate()));
        Assert.assertEquals((Object)twoToThree.negate(), (Object)IIIOperator.MODULO.apply(tenToEleven.negate(), SimpleInterval.singleton(scalarFour)));
        Assert.assertEquals((Object)zeroToTwo.negate(), (Object)IIIOperator.MODULO.apply(eightToTen.negate(), SimpleInterval.singleton(scalarFour)));
        Assert.assertEquals((Object)twoToThree.negate(), (Object)IIIOperator.MODULO.apply(tenToEleven.negate(), SimpleInterval.singleton(scalarFour).negate()));
        Assert.assertEquals((Object)zeroToTwo.negate(), (Object)IIIOperator.MODULO.apply(eightToTen.negate(), SimpleInterval.singleton(scalarFour).negate()));
        Assert.assertEquals((Object)zeroToFour, (Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(BigInteger.ZERO, scalarFive)));
        Assert.assertEquals((Object)zeroToFour, (Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(scalarFour.negate(), scalarFive)));
        Assert.assertEquals((Object)zeroToFour, (Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(scalarFive.negate(), scalarFour)));
        Assert.assertEquals((Object)zeroToFour.negate(), (Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(BigInteger.ZERO, scalarFive)));
        Assert.assertEquals((Object)zeroToFour.negate(), (Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(scalarFour.negate(), scalarFive)));
        Assert.assertEquals((Object)zeroToFour.negate(), (Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(scalarFive.negate(), scalarFour)));
        Assert.assertEquals((Object)SimpleInterval.of(scalarFour.negate(), scalarFour), (Object)IIIOperator.MODULO.apply(SimpleInterval.infinite(), SimpleInterval.of(scalarFive.negate(), scalarFour)));
    }

    @Test
    public void testMultiply() {
        BigInteger hundred = BigInteger.valueOf(100L);
        SimpleInterval negTenToZero = SimpleInterval.of(BigInteger.TEN.negate(), BigInteger.ZERO);
        SimpleInterval zeroToTen = SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN);
        SimpleInterval negHundredToHundred = SimpleInterval.of(hundred.negate(), hundred);
        SimpleInterval negHundredToZero = SimpleInterval.of(hundred.negate(), BigInteger.ZERO);
        SimpleInterval negTenToTen = SimpleInterval.of(BigInteger.TEN.negate(), BigInteger.TEN);
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval zeroToOne = SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE);
        SimpleInterval negInfToFive = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToNegativeInfinity();
        SimpleInterval negInfToNegFive = SimpleInterval.singleton(BigInteger.valueOf(-5L)).extendToNegativeInfinity();
        SimpleInterval twentyFiveToInf = SimpleInterval.singleton(BigInteger.valueOf(25L)).extendToPositiveInfinity();
        SimpleInterval twentyToTwentyFive = SimpleInterval.of(BigInteger.valueOf(20L), BigInteger.valueOf(25L));
        SimpleInterval twoToFour = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        SimpleInterval fortyToHundred = SimpleInterval.of(BigInteger.valueOf(40L), BigInteger.valueOf(100L));
        Assert.assertEquals((Object)negHundredToZero, (Object)IIIOperator.MULTIPLY.apply(negTenToZero, zeroToTen));
        Assert.assertEquals((Object)negHundredToHundred, (Object)IIIOperator.MULTIPLY.apply(negTenToZero, negTenToTen));
        Assert.assertEquals((Object)zero, (Object)IIIOperator.MULTIPLY.apply(SimpleInterval.infinite(), zero));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.MULTIPLY.apply(SimpleInterval.infinite(), zeroToOne));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.MULTIPLY.apply(negInfToFive, negInfToFive));
        Assert.assertEquals((Object)twentyFiveToInf, (Object)IIIOperator.MULTIPLY.apply(negInfToNegFive, negInfToNegFive));
        Assert.assertEquals((Object)fortyToHundred, (Object)IIIOperator.MULTIPLY.apply(twentyToTwentyFive, twoToFour));
    }

    @Test
    public void testDivide() {
        SimpleInterval negFourToNegTwo = SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L));
        SimpleInterval negFourToNegOne = SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-1L));
        SimpleInterval negTwoToNegOne = SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L));
        SimpleInterval oneToFour = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(4L));
        SimpleInterval oneToTwo = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        SimpleInterval twoToFour = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        SimpleInterval negTwentyToTwenty = SimpleInterval.of(BigInteger.valueOf(-20L), BigInteger.valueOf(20L));
        SimpleInterval negTwoToTwo = SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(2L));
        SimpleInterval negInfToTen = SimpleInterval.singleton(BigInteger.valueOf(10L)).extendToNegativeInfinity();
        SimpleInterval negInfToFive = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToNegativeInfinity();
        SimpleInterval negInfToNegFive = SimpleInterval.singleton(BigInteger.valueOf(-5L)).extendToNegativeInfinity();
        SimpleInterval fiveToInf = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToPositiveInfinity();
        SimpleInterval negTwentyToTen = SimpleInterval.of(BigInteger.valueOf(-20L), BigInteger.valueOf(10L));
        SimpleInterval negTwoToInf = SimpleInterval.singleton(BigInteger.valueOf(-2L)).extendToPositiveInfinity();
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        SimpleInterval negInfToZero = zeroToInf.negate();
        SimpleInterval zeroToTwo = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(2L));
        Assert.assertEquals((Object)oneToFour, (Object)IIIOperator.DIVIDE.apply(negFourToNegTwo, negTwoToNegOne));
        Assert.assertEquals((Object)negFourToNegOne, (Object)IIIOperator.DIVIDE.apply(negFourToNegTwo, oneToTwo));
        Assert.assertEquals((Object)negFourToNegOne, (Object)IIIOperator.DIVIDE.apply(twoToFour, negTwoToNegOne));
        Assert.assertEquals((Object)oneToFour, (Object)IIIOperator.DIVIDE.apply(twoToFour, oneToTwo));
        Assert.assertEquals((Object)negTwentyToTwenty, (Object)IIIOperator.DIVIDE.apply(negTwentyToTwenty, negTwoToTwo));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.DIVIDE.apply(negInfToTen, negTwoToTwo));
        Assert.assertEquals((Object)negInfToFive, (Object)IIIOperator.DIVIDE.apply(negInfToTen, twoToFour));
        Assert.assertEquals((Object)negInfToZero, (Object)IIIOperator.DIVIDE.apply(negInfToNegFive, fiveToInf));
        Assert.assertEquals((Object)negTwentyToTen, (Object)IIIOperator.DIVIDE.apply(negTwentyToTen, negTwoToInf));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.infinite()));
        Assert.assertNull((Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.ZERO)));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.valueOf(5L))));
        Assert.assertEquals((Object)SimpleInterval.infinite(), (Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.valueOf(-5L))));
        Assert.assertEquals((Object)zeroToInf, (Object)IIIOperator.DIVIDE.apply(zeroToInf, SimpleInterval.singleton(BigInteger.valueOf(5L))));
        Assert.assertEquals((Object)negInfToZero, (Object)IIIOperator.DIVIDE.apply(zeroToInf, SimpleInterval.singleton(BigInteger.valueOf(-5L))));
        Assert.assertEquals((Object)negTwentyToTwenty, (Object)IIIOperator.DIVIDE.apply(negTwentyToTwenty, zeroToInf));
        Assert.assertEquals((Object)oneToFour, (Object)IIIOperator.DIVIDE.apply(twoToFour, zeroToTwo));
    }
}

