/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ISIOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public enum ISCOperator implements Operator<SimpleInterval, BigInteger, CompoundInterval>
{
    ADD{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundInterval.of(ISIOperator.ADD.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundInterval.of(ISIOperator.DIVIDE.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    MODULO{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pValue) {
            if (pValue.signum() == 0) {
                return CompoundInterval.bottom();
            }
            if (pValue.signum() < 0) {
                return this.apply(pFirstOperand, pValue.negate());
            }
            if (pFirstOperand.isSingleton()) {
                return CompoundInterval.singleton(pFirstOperand.getLowerBound().remainder(pValue));
            }
            BigInteger largestPossibleValue = pValue.subtract(BigInteger.ONE);
            CompoundInterval result = CompoundInterval.bottom();
            if (pFirstOperand.containsNegative()) {
                CompoundInterval negRange = CompoundInterval.of(SimpleInterval.of(largestPossibleValue.negate(), BigInteger.ZERO));
                if (pFirstOperand.hasLowerBound()) {
                    SimpleInterval negPart = pFirstOperand.containsZero() ? SimpleInterval.of(pFirstOperand.getLowerBound(), BigInteger.ZERO) : pFirstOperand;
                    negRange = this.apply(negPart.negate(), pValue).negate();
                }
                result = result.unionWith(negRange);
            }
            if (pFirstOperand.containsPositive()) {
                SimpleInterval posPart;
                BigInteger posPartLength;
                CompoundInterval posRange = CompoundInterval.of(SimpleInterval.of(BigInteger.ZERO, largestPossibleValue));
                if (pFirstOperand.hasUpperBound() && (posPartLength = (posPart = pFirstOperand.containsZero() ? SimpleInterval.of(BigInteger.ZERO, pFirstOperand.getUpperBound()) : pFirstOperand).size()).compareTo(pValue) < 0) {
                    BigInteger quotient = posPart.getUpperBound().divide(pValue);
                    BigInteger modBorder = quotient.multiply(pValue);
                    BigInteger nextModBorder = modBorder.add(pValue);
                    if (modBorder.compareTo(posPart.getLowerBound()) <= 0 && nextModBorder.compareTo(posPart.getUpperBound()) >= 0) {
                        BigInteger bound1 = posPart.getLowerBound().remainder(pValue);
                        BigInteger bound2 = posPart.getUpperBound().remainder(pValue);
                        posRange = CompoundInterval.of(SimpleInterval.of(bound1.min(bound2), bound1.max(bound2)));
                    } else if (modBorder.compareTo(posPart.getLowerBound()) > 0 && modBorder.compareTo(posPart.getUpperBound()) < 0) {
                        SimpleInterval posPart1 = SimpleInterval.of(posPart.getLowerBound(), modBorder.subtract(BigInteger.ONE));
                        SimpleInterval posPart2 = SimpleInterval.of(modBorder, posPart.getUpperBound());
                        posRange = this.apply(posPart1, pValue).unionWith(this.apply(posPart2, pValue));
                    }
                }
                result = result.unionWith(posRange);
            }
            return result;
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundInterval.of(ISIOperator.MULTIPLY.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundInterval.of(ISIOperator.SHIFT_LEFT.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            return CompoundInterval.of(ISIOperator.SHIFT_RIGHT.apply(pFirstOperand, pSecondOperand));
        }
    };


    @Override
    public abstract CompoundInterval apply(SimpleInterval var1, BigInteger var2);
}

