/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.IntervalHelper;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

public enum ISIOperator implements Operator<SimpleInterval, BigInteger, SimpleInterval>
{
    ADD{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.equals(BigInteger.ZERO)) {
                return pFirstOperand;
            }
            BigInteger lowerBound = IntervalHelper.getLowerBoundOrNull(pFirstOperand);
            BigInteger upperBound = IntervalHelper.getUpperBoundOrNull(pFirstOperand);
            if (lowerBound != null) {
                lowerBound = lowerBound.add(pSecondOperand);
            }
            if (upperBound != null) {
                upperBound = upperBound.add(pSecondOperand);
            }
            return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
        }
    }
    ,
    MULTIPLY{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pSecondOperand.equals(BigInteger.ZERO)) {
                return SimpleInterval.singleton(BigInteger.ZERO);
            }
            if (pSecondOperand.equals(BigInteger.ONE) || pFirstOperand.isTop()) {
                return pFirstOperand;
            }
            if (pSecondOperand.signum() < 0) {
                return this.apply(pFirstOperand.negate(), pSecondOperand.negate());
            }
            BigInteger lowerBound = IntervalHelper.getLowerBoundOrNull(pFirstOperand);
            BigInteger upperBound = IntervalHelper.getUpperBoundOrNull(pFirstOperand);
            if (lowerBound != null) {
                lowerBound = lowerBound.multiply(pSecondOperand);
            }
            if (upperBound != null) {
                upperBound = upperBound.multiply(pSecondOperand);
            }
            return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
        }
    }
    ,
    DIVIDE{

        @Override
        @Nullable
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pSecondOperand.equals(BigInteger.ZERO)) {
                return null;
            }
            if (pSecondOperand.equals(BigInteger.ONE) || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            if (pSecondOperand.compareTo(BigInteger.ZERO) < 0) {
                return this.apply(pFirstOperand.negate(), pSecondOperand.negate());
            }
            BigInteger lowerBound = null;
            BigInteger upperBound = null;
            if (pFirstOperand.hasLowerBound()) {
                lowerBound = pFirstOperand.getLowerBound().divide(pSecondOperand);
            }
            if (pFirstOperand.hasUpperBound()) {
                upperBound = pFirstOperand.getUpperBound().divide(pSecondOperand);
            }
            return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
        }
    }
    ,
    MODULO{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pSecondOperand.equals(BigInteger.ZERO)) {
                return null;
            }
            if (pSecondOperand.signum() < 0) {
                return this.apply(pFirstOperand, pSecondOperand.negate());
            }
            if (pFirstOperand.isSingleton()) {
                return SimpleInterval.singleton(pFirstOperand.getLowerBound().remainder(pSecondOperand));
            }
            BigInteger largestPossibleValue = pSecondOperand.subtract(BigInteger.ONE);
            SimpleInterval moduloRange = null;
            if (pFirstOperand.containsNegative()) {
                moduloRange = SimpleInterval.of(largestPossibleValue.negate(), BigInteger.ZERO);
                if (pFirstOperand.hasLowerBound()) {
                    SimpleInterval negPart = pFirstOperand.containsZero() ? SimpleInterval.of(pFirstOperand.getLowerBound(), BigInteger.ZERO) : pFirstOperand;
                    moduloRange = this.apply(negPart.negate(), pSecondOperand).negate();
                }
            }
            if (pFirstOperand.containsPositive()) {
                BigInteger quotient;
                BigInteger modBorder;
                SimpleInterval posPart;
                BigInteger posPartLength;
                SimpleInterval posRange = SimpleInterval.of(BigInteger.ZERO, largestPossibleValue);
                if (pFirstOperand.hasUpperBound() && (posPartLength = (posPart = pFirstOperand.containsZero() ? SimpleInterval.of(BigInteger.ZERO, pFirstOperand.getUpperBound()) : pFirstOperand).size()).compareTo(pSecondOperand) < 0 && (modBorder = (quotient = posPart.getUpperBound().divide(pSecondOperand)).multiply(pSecondOperand)).compareTo(posPart.getLowerBound()) <= 0 && modBorder.add(largestPossibleValue).compareTo(posPart.getUpperBound()) >= 0) {
                    BigInteger bound1 = posPart.getLowerBound().remainder(pSecondOperand);
                    BigInteger bound2 = posPart.getUpperBound().remainder(pSecondOperand);
                    posRange = SimpleInterval.of(bound1.min(bound2), bound1.max(bound2));
                }
                assert (moduloRange != null || posRange != null);
                if (moduloRange == null) {
                    moduloRange = posRange;
                } else if (posRange != null) {
                    moduloRange = SimpleInterval.span(moduloRange, posRange);
                }
            }
            return moduloRange;
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.signum() == 0 || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            if (pSecondOperand.signum() < 0) {
                return this.apply(pFirstOperand, pSecondOperand.negate());
            }
            if (pSecondOperand.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                BigInteger lowerBound = null;
                BigInteger upperBound = null;
                if (pFirstOperand.hasLowerBound()) {
                    lowerBound = pFirstOperand.getLowerBound().shiftLeft(pSecondOperand.intValue());
                }
                if (pFirstOperand.hasUpperBound()) {
                    upperBound = pFirstOperand.getUpperBound().shiftLeft(pSecondOperand.intValue());
                }
                return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
            }
            return SimpleInterval.infinite();
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public SimpleInterval apply(SimpleInterval pFirstOperand, BigInteger pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.signum() == 0 || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return pFirstOperand;
            }
            if (pSecondOperand.signum() < 0) {
                return SHIFT_LEFT.apply(pFirstOperand, pSecondOperand.negate());
            }
            if (pSecondOperand.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                BigInteger lowerBound = null;
                BigInteger upperBound = null;
                if (pFirstOperand.hasLowerBound()) {
                    lowerBound = pFirstOperand.getLowerBound().shiftRight(pSecondOperand.intValue());
                }
                if (pFirstOperand.hasUpperBound()) {
                    upperBound = pFirstOperand.getUpperBound().shiftRight(pSecondOperand.intValue());
                }
                return IntervalHelper.ofNullableBounds(lowerBound, upperBound);
            }
            if (!pFirstOperand.hasLowerBound()) {
                return SimpleInterval.singleton(BigInteger.ZERO).extendToNegativeInfinity();
            }
            if (!pFirstOperand.hasUpperBound()) {
                return SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
            }
            return SimpleInterval.singleton(BigInteger.ZERO);
        }
    };


    @Override
    public abstract SimpleInterval apply(SimpleInterval var1, BigInteger var2);
}

