/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.ISIOperator;

public class ISIOperatorTest {
    @Test
    public void testModulo() {
        BigInteger scalarFour = BigInteger.valueOf(4L);
        BigInteger scalarFive = BigInteger.valueOf(5L);
        SimpleInterval zeroToFour = SimpleInterval.of(BigInteger.ZERO, scalarFour);
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        Assert.assertEquals((Object)zeroToFour.negate(), (Object)ISIOperator.MODULO.apply(zeroToInf.negate(), scalarFive));
        Assert.assertEquals((Object)zeroToFour.negate(), (Object)ISIOperator.MODULO.apply(zeroToInf.negate(), scalarFive.negate()));
    }

    @Test
    public void testShiftLeft() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval ten = SimpleInterval.singleton(BigInteger.TEN);
        SimpleInterval zeroToTen = SimpleInterval.span(zero, ten);
        SimpleInterval zeroToFive = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(5L));
        SimpleInterval two = SimpleInterval.singleton(BigInteger.valueOf(2L));
        SimpleInterval oneThousandTwentyFour = SimpleInterval.singleton(BigInteger.valueOf(1024L));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.ZERO));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.ONE));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_LEFT.apply(zero, BigInteger.TEN));
        Assert.assertEquals((Object)one, (Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.ZERO));
        Assert.assertEquals((Object)two, (Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.ONE));
        Assert.assertEquals((Object)oneThousandTwentyFour, (Object)ISIOperator.SHIFT_LEFT.apply(one, BigInteger.TEN));
        Assert.assertEquals((Object)ten, (Object)ISIOperator.SHIFT_LEFT.apply(ten, BigInteger.ZERO));
        Assert.assertEquals((Object)zeroToTen, (Object)ISIOperator.SHIFT_LEFT.apply(zeroToFive, BigInteger.ONE));
    }

    @Test
    public void testShiftRight() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval ten = SimpleInterval.singleton(BigInteger.TEN);
        SimpleInterval oneToTen = SimpleInterval.span(one, ten);
        SimpleInterval zeroToFive = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(5L));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.ZERO));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.ONE));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_RIGHT.apply(zero, BigInteger.TEN));
        Assert.assertEquals((Object)one, (Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.ZERO));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.ONE));
        Assert.assertEquals((Object)zero, (Object)ISIOperator.SHIFT_RIGHT.apply(one, BigInteger.TEN));
        Assert.assertEquals((Object)ten, (Object)ISIOperator.SHIFT_RIGHT.apply(ten, BigInteger.ZERO));
        Assert.assertEquals((Object)zeroToFive, (Object)ISIOperator.SHIFT_RIGHT.apply(oneToTen, BigInteger.ONE));
    }
}

