/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators;

import java.math.BigInteger;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

class IntervalHelper {
    private IntervalHelper() {
    }

    public static SimpleInterval ofNullableBounds(@Nullable BigInteger pLowerBound, @Nullable BigInteger pUpperBound) {
        if (pLowerBound == null) {
            if (pUpperBound == null) {
                return SimpleInterval.infinite();
            }
            return SimpleInterval.singleton(pUpperBound).extendToNegativeInfinity();
        }
        if (pUpperBound == null) {
            return SimpleInterval.singleton(pLowerBound).extendToPositiveInfinity();
        }
        return SimpleInterval.of(pLowerBound, pUpperBound);
    }

    public static BigInteger getLowerBoundOrNull(SimpleInterval pInterval) {
        if (pInterval.hasLowerBound()) {
            return pInterval.getLowerBound();
        }
        return null;
    }

    @Nullable
    public static BigInteger getUpperBoundOrNull(SimpleInterval pInterval) {
        if (pInterval.hasUpperBound()) {
            return pInterval.getUpperBound();
        }
        return null;
    }
}

