/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.variableselection;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormula;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptAllVariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelectionVisitor;

public class AcceptSpecifiedVariableSelection<ConstantType>
implements VariableSelection<ConstantType> {
    private final CollectVarsVisitor<ConstantType> collectVarsVisitor = new CollectVarsVisitor();
    private final VariableSelectionJoiner variableSelectionJoiner = new VariableSelectionJoiner();
    private final ImmutableSet<String> specifiedVariables;

    public AcceptSpecifiedVariableSelection(Iterable<? extends String> pIterable) {
        this.specifiedVariables = ImmutableSet.copyOf(pIterable);
    }

    @Override
    public boolean contains(final String pVariableName) {
        return FluentIterable.from(this.specifiedVariables).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String pArg0) {
                int arraySubscriptIndex;
                if (pVariableName.equals(pArg0)) {
                    return true;
                }
                if (pArg0.endsWith("[*]") && (arraySubscriptIndex = pVariableName.indexOf(91)) >= 0) {
                    String containedArray = pArg0.substring(0, pArg0.indexOf(91));
                    String array = pVariableName.substring(arraySubscriptIndex);
                    return containedArray.equals(array);
                }
                return false;
            }
        });
    }

    @Override
    public VariableSelection<ConstantType> acceptAssumption(InvariantsFormula<ConstantType> pAssumption) {
        Set involvedVariables = (Set)pAssumption.accept(this.collectVarsVisitor);
        for (String involvedVariable : involvedVariables) {
            if (!this.contains(involvedVariable)) continue;
            return this.join(involvedVariables);
        }
        return null;
    }

    @Override
    public VariableSelection<ConstantType> acceptAssignment(String pVariableName, InvariantsFormula<ConstantType> pAssumption) {
        if (this.contains(pVariableName)) {
            return this.join((Set)pAssumption.accept(this.collectVarsVisitor));
        }
        return null;
    }

    public String toString() {
        return this.specifiedVariables.toString();
    }

    @Override
    public VariableSelection<ConstantType> join(VariableSelection<ConstantType> pOther) {
        return (VariableSelection)pOther.acceptVisitor(this.variableSelectionJoiner);
    }

    @Override
    public <T> T acceptVisitor(VariableSelectionVisitor<ConstantType, T> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    private VariableSelection<ConstantType> join(Set<String> pSpecifiedVariables) {
        if (this.specifiedVariables == pSpecifiedVariables || this.specifiedVariables.containsAll(pSpecifiedVariables)) {
            return this;
        }
        AcceptSpecifiedVariableSelection<ConstantType> result = new AcceptSpecifiedVariableSelection<ConstantType>(Iterables.concat(this.specifiedVariables, pSpecifiedVariables));
        return result;
    }

    private class VariableSelectionJoiner
    implements VariableSelectionVisitor<ConstantType, VariableSelection<ConstantType>> {
        private VariableSelectionJoiner() {
        }

        @Override
        public VariableSelection<ConstantType> visit(AcceptAllVariableSelection<ConstantType> pAcceptAllVariableSelection) {
            return pAcceptAllVariableSelection;
        }

        @Override
        public VariableSelection<ConstantType> visit(AcceptSpecifiedVariableSelection<ConstantType> pAcceptSpecifiedVariableSelection) {
            if (AcceptSpecifiedVariableSelection.this == pAcceptSpecifiedVariableSelection || AcceptSpecifiedVariableSelection.this.specifiedVariables.containsAll((Collection)pAcceptSpecifiedVariableSelection.specifiedVariables)) {
                return AcceptSpecifiedVariableSelection.this;
            }
            return pAcceptSpecifiedVariableSelection.join((Set)AcceptSpecifiedVariableSelection.this.specifiedVariables);
        }
    }
}

