/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.ldd;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.ldd.LDDAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDDRegion;
import org.sosy_lab.cpachecker.util.predicates.ldd.LDDRegionManager;

public class LDDAbstractionTransferRelation
extends SingleEdgeTransferRelation {
    private final LDDRegionManager regionManager;
    private final Map<String, Integer> variables;
    private final Set<String> usedVars = new HashSet<String>();

    public LDDAbstractionTransferRelation(LDDRegionManager regionManager, Map<String, Integer> variables) {
        this.regionManager = regionManager;
        this.variables = variables;
    }

    public Collection<? extends LDDAbstractState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge edge) throws CPATransferException, InterruptedException {
        if (!(element instanceof LDDAbstractState)) {
            return Collections.emptyList();
        }
        LDDAbstractState analysisElement = (LDDAbstractState)element;
        LDDRegion region = this.toRegion(edge, analysisElement.getRegion());
        if (region == null || region.isFalse()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new LDDAbstractState(region));
    }

    private LDDRegion toRegion(CFAEdge edge, LDDRegion currentRegion) {
        LDDRegion edgePartialRegion = null;
        if (edge instanceof CAssumeEdge) {
            CAssumeEdge assumeEdge = (CAssumeEdge)edge;
            edgePartialRegion = this.assumeToRegion(assumeEdge.getExpression());
            if (edgePartialRegion != null && !assumeEdge.getTruthAssumption()) {
                edgePartialRegion = this.regionManager.makeNot(edgePartialRegion);
            }
        } else {
            if (edge instanceof CDeclarationEdge) {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)edge;
                return this.toRegion(declarationEdge.getDeclaration(), currentRegion);
            }
            if (edge instanceof CStatementEdge) {
                CStatementEdge statementEdge = (CStatementEdge)edge;
                CStatement statement = statementEdge.getStatement();
                return this.toRegion(statement, currentRegion);
            }
            if (edge instanceof CFunctionCallEdge || edge instanceof CFunctionReturnEdge) {
                // empty if block
            }
        }
        if (edgePartialRegion == null) {
            return currentRegion;
        }
        return this.regionManager.makeAnd(currentRegion, edgePartialRegion);
    }

    private LDDRegion toRegion(CStatement pStatement, LDDRegion previousRegion) {
        CExpressionAssignmentStatement eas;
        CLeftHandSide leftHandSide;
        if (pStatement instanceof CExpressionAssignmentStatement && (leftHandSide = (eas = (CExpressionAssignmentStatement)pStatement).getLeftHandSide()) instanceof CIdExpression) {
            CExpression rightHandSide = eas.getRightHandSide();
            CIdExpression lhsId = (CIdExpression)leftHandSide;
            return this.assign(lhsId.getName(), rightHandSide, previousRegion);
        }
        if (pStatement instanceof CFunctionCallAssignmentStatement || pStatement instanceof CFunctionCallStatement) {
            return this.regionManager.makeTrue();
        }
        return previousRegion;
    }

    private LDDRegion assumeToRegion(CExpression pExpression) {
        if (pExpression instanceof CIntegerLiteralExpression) {
            Integer constant = this.reduceToConstant(pExpression);
            if (constant == null || constant == 0) {
                return this.regionManager.makeFalse();
            }
            return this.regionManager.makeTrue();
        }
        if (pExpression instanceof CBinaryExpression) {
            boolean leq;
            CBinaryExpression binaryExpression = (CBinaryExpression)pExpression;
            CExpression left = binaryExpression.getOperand1();
            CExpression right = binaryExpression.getOperand2();
            CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
            switch (operator) {
                case LESS_EQUAL: 
                case LESS_THAN: {
                    break;
                }
                case GREATER_EQUAL: 
                case GREATER_THAN: {
                    CExpression temp = right;
                    right = left;
                    left = temp;
                    operator = operator == CBinaryExpression.BinaryOperator.GREATER_EQUAL ? CBinaryExpression.BinaryOperator.LESS_EQUAL : CBinaryExpression.BinaryOperator.LESS_THAN;
                    break;
                }
                case BINARY_AND: {
                    return this.regionManager.makeAnd(this.assumeToRegion(left), this.assumeToRegion(right));
                }
                case BINARY_OR: {
                    return this.regionManager.makeOr(this.assumeToRegion(left), this.assumeToRegion(right));
                }
                case BINARY_XOR: {
                    return this.regionManager.makeXor(this.assumeToRegion(left), this.assumeToRegion(right));
                }
                case EQUALS: {
                    Map<String, Integer> leftTerm = this.reduceToTerm(left);
                    if (leftTerm == null) {
                        return null;
                    }
                    Map<String, Integer> rightTerm = this.reduceToTerm(right);
                    if (rightTerm == null) {
                        return null;
                    }
                    return this.regionManager.makeAnd(this.makeNode(leftTerm, rightTerm, true), this.makeNode(rightTerm, leftTerm, true));
                }
                case NOT_EQUALS: {
                    Map<String, Integer> leftTerm = this.reduceToTerm(left);
                    if (leftTerm == null) {
                        return null;
                    }
                    Map<String, Integer> rightTerm = this.reduceToTerm(right);
                    if (rightTerm == null) {
                        return null;
                    }
                    return this.regionManager.makeNot(this.regionManager.makeAnd(this.makeNode(leftTerm, rightTerm, true), this.makeNode(rightTerm, leftTerm, true)));
                }
                default: {
                    return null;
                }
            }
            Map<String, Integer> leftTerm = this.reduceToTerm(left);
            boolean bl = leq = operator == CBinaryExpression.BinaryOperator.LESS_EQUAL;
            if (leftTerm == null) {
                return null;
            }
            Map<String, Integer> rightTerm = this.reduceToTerm(right);
            if (rightTerm == null) {
                return null;
            }
            return this.makeNode(leftTerm, rightTerm, leq);
        }
        return null;
    }

    private LDDRegion makeNode(Map<String, Integer> leftTerm, Map<String, Integer> rightTerm, boolean leq) {
        Integer leftConst = this.removeConstant(leftTerm);
        Integer rightConst = this.removeConstant(rightTerm);
        int constant = rightConst - leftConst;
        HashMap<String, Integer> term = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> rightCoeff : rightTerm.entrySet()) {
            Integer leftCoeff = this.removeCoefficient(leftTerm, rightCoeff.getKey());
            int value = leftCoeff - rightCoeff.getValue();
            term.put(rightCoeff.getKey(), value);
        }
        for (Map.Entry<String, Integer> leftCoeff : leftTerm.entrySet()) {
            if (term.containsKey(leftCoeff.getKey()) || leftCoeff.getValue() == null) continue;
            term.put(leftCoeff.getKey(), leftCoeff.getValue());
        }
        return this.toNode(term, leq, constant);
    }

    private LDDRegion assign(String variable, CExpression expression, LDDRegion previousRegion) {
        Integer reduced = this.reduceToConstant(expression);
        if (reduced != null) {
            this.usedVars.add(variable);
            return this.regionManager.makeAnd(previousRegion, this.toConstantAssignmentRegion(Collections.singleton(variable), (int)reduced));
        }
        Map<String, Integer> term = this.reduceToTerm(expression);
        if (term != null) {
            LDDRegion region;
            Integer constant = this.removeConstant(term);
            Integer coefficient = this.removeCoefficient(term = this.negate(term), variable);
            if (coefficient != 0) {
                return null;
            }
            if (this.usedVars.contains(variable)) {
                region = this.substituteByTerm(variable, term, constant, previousRegion);
            } else {
                term.put(variable, 1);
                for (String var : term.keySet()) {
                    this.usedVars.add(var);
                }
                region = this.regionManager.makeAnd(previousRegion, this.toConstantAssignmentRegion(term, (int)constant));
            }
            return region;
        }
        return previousRegion;
    }

    private LDDRegion substituteByTerm(String pVariable, Map<String, Integer> pTerm, int constant, LDDRegion region) {
        return this.regionManager.replace(this.variables.get(pVariable), this.toIndexCoefficients(pTerm), this.variables.size(), constant, region);
    }

    private Integer removeConstant(Map<String, Integer> coefficients) {
        return this.removeCoefficient(coefficients, "const");
    }

    private Integer removeCoefficient(Map<String, Integer> coefficients, String variable) {
        Integer coeff = coefficients.remove(variable);
        if (coeff == null) {
            coeff = 0;
        }
        return coeff;
    }

    private Pair<Integer, Integer> removeRationalCoefficient(Map<String, Pair<Integer, Integer>> coefficients, String variable) {
        Pair<Integer, Integer> rational = coefficients.remove(variable);
        if (rational == null) {
            return Pair.of((Object)0, (Object)1);
        }
        return rational;
    }

    private Map<String, Integer> negate(Map<String, Integer> toNegate) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> coeff : toNegate.entrySet()) {
            result.put(coeff.getKey(), -coeff.getValue().intValue());
        }
        return result;
    }

    private Map<String, Integer> reduceToTerm(CExpression expression) {
        HashMap<String, Integer> variableCoeffs = new HashMap<String, Integer>();
        Map<String, Pair<Integer, Integer>> rationalTerm = this.reduceToRationalTerm(expression);
        if (rationalTerm == null) {
            return null;
        }
        for (Map.Entry<String, Pair<Integer, Integer>> coeff : rationalTerm.entrySet()) {
            int num = (Integer)coeff.getValue().getFirst();
            int denom = (Integer)coeff.getValue().getSecond();
            if (denom == 0 || num % denom != 0) {
                return null;
            }
            int value = num / denom;
            variableCoeffs.put(coeff.getKey(), value);
        }
        return variableCoeffs;
    }

    private Pair<Integer, Integer> normalizeRational(int num, int denom) {
        if (num % denom == 0) {
            return Pair.of((Object)(num / denom), (Object)1);
        }
        return Pair.of((Object)num, (Object)denom);
    }

    private Map<String, Pair<Integer, Integer>> reduceToRationalTerm(CExpression expression) {
        expression.toASTString();
        HashMap<String, Pair<Integer, Integer>> variableCoeffs = new HashMap();
        if (expression instanceof CIntegerLiteralExpression) {
            CIntegerLiteralExpression literal = (CIntegerLiteralExpression)expression;
            return Collections.singletonMap("const", Pair.of((Object)literal.getValue().intValue(), (Object)1));
        }
        if (expression instanceof CIdExpression) {
            CIdExpression id = (CIdExpression)expression;
            return Collections.singletonMap(id.getName(), Pair.of((Object)1, (Object)1));
        }
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)expression;
            CExpression op1 = binaryExpression.getOperand1();
            CExpression op2 = binaryExpression.getOperand2();
            CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
            Map<String, Pair<Integer, Integer>> firstAsTerm = this.reduceToRationalTerm(op1);
            Map<String, Pair<Integer, Integer>> secondAsTerm = this.reduceToRationalTerm(op2);
            Integer firstAsConstant = this.reduceToConstant(op1);
            Integer secondAsConstant = this.reduceToConstant(op2);
            if (firstAsConstant != null && secondAsConstant != null) {
                Integer constant = this.reduceToConstant(expression);
                if (constant == null) {
                    return null;
                }
                return Collections.singletonMap("const", Pair.of((Object)constant, (Object)1));
            }
            if (firstAsTerm != null && secondAsTerm != null) {
                int multiplier;
                switch (operator) {
                    case PLUS: {
                        multiplier = 1;
                        break;
                    }
                    case MINUS: {
                        multiplier = -1;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                for (Map.Entry<String, Pair<Integer, Integer>> coeff : firstAsTerm.entrySet()) {
                    int denom2;
                    int num2;
                    int num1 = (Integer)coeff.getValue().getFirst();
                    int denom1 = (Integer)coeff.getValue().getSecond();
                    Pair<Integer, Integer> second = secondAsTerm.get(coeff.getKey());
                    if (second == null) {
                        num2 = 0;
                        denom2 = 1;
                    } else {
                        num2 = (Integer)second.getFirst();
                        denom2 = (Integer)second.getSecond();
                    }
                    int denom = denom1 * denom2;
                    int num = 0;
                    num = (num1 *= denom2) + (num2 *= denom1) * multiplier;
                    variableCoeffs.put(coeff.getKey(), this.normalizeRational(num, denom));
                }
                for (Map.Entry<String, Pair<Integer, Integer>> entry : secondAsTerm.entrySet()) {
                    if (variableCoeffs.containsKey(entry.getKey())) continue;
                    int num = (Integer)entry.getValue().getFirst() * multiplier;
                    int denom = (Integer)entry.getValue().getSecond();
                    variableCoeffs.put(entry.getKey(), (Pair<Integer, Integer>)Pair.of((Object)num, (Object)denom));
                }
                return variableCoeffs;
            }
            if (firstAsTerm != null && secondAsTerm != null && operator == CBinaryExpression.BinaryOperator.DIVIDE) {
                return null;
            }
            int constant = firstAsConstant != null ? firstAsConstant : secondAsConstant;
            Map<String, Pair<Integer, Integer>> term = firstAsTerm != null ? firstAsTerm : secondAsTerm;
            switch (operator) {
                case MULTIPLY: {
                    for (Map.Entry<String, Pair<Integer, Integer>> coeff : term.entrySet()) {
                        int num = (Integer)coeff.getValue().getFirst() * constant;
                        int denom = (Integer)coeff.getValue().getSecond();
                        variableCoeffs.put(coeff.getKey(), this.normalizeRational(num, denom));
                    }
                    break;
                }
                case DIVIDE: {
                    for (Map.Entry<String, Pair<Integer, Integer>> coeff : term.entrySet()) {
                        int num = (Integer)coeff.getValue().getFirst();
                        if (num % constant == 0) {
                            num /= constant;
                            constant = 1;
                        }
                        int denom = (Integer)coeff.getValue().getSecond() * constant;
                        variableCoeffs.put(coeff.getKey(), this.normalizeRational(num, denom));
                    }
                    break;
                }
                case MINUS: {
                    if (term == firstAsTerm) {
                        constant = -constant;
                    } else {
                        for (Map.Entry<String, Pair<Integer, Integer>> coeff : term.entrySet()) {
                            int num = -((Integer)coeff.getValue().getFirst()).intValue();
                            int denom = (Integer)coeff.getValue().getSecond();
                            variableCoeffs.put(coeff.getKey(), this.normalizeRational(num, denom));
                        }
                    }
                    term = variableCoeffs;
                }
                case PLUS: {
                    variableCoeffs = term;
                    Pair<Integer, Integer> previousConstVar = this.removeRationalCoefficient(variableCoeffs, "const");
                    int prevNum = (Integer)previousConstVar.getFirst();
                    int prevDenom = (Integer)previousConstVar.getSecond();
                    int num = prevNum + constant * prevDenom;
                    int denom = prevDenom;
                    variableCoeffs.put("const", this.normalizeRational(num, denom));
                    break;
                }
                default: {
                    return null;
                }
            }
            return variableCoeffs;
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)expression;
            CExpression operand = unaryExpression.getOperand();
            switch (unaryExpression.getOperator()) {
                case MINUS: {
                    Map<String, Pair<Integer, Integer>> innerTerm = this.reduceToRationalTerm(operand);
                    if (innerTerm != null) {
                        return this.negateRational(innerTerm);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    private Map<String, Pair<Integer, Integer>> negateRational(Map<String, Pair<Integer, Integer>> toNegate) {
        HashMap<String, Pair<Integer, Integer>> result = new HashMap<String, Pair<Integer, Integer>>();
        for (Map.Entry<String, Pair<Integer, Integer>> coeff : toNegate.entrySet()) {
            int num = -((Integer)coeff.getValue().getFirst()).intValue();
            int denom = (Integer)coeff.getValue().getSecond();
            result.put(coeff.getKey(), (Pair<Integer, Integer>)Pair.of((Object)num, (Object)denom));
        }
        return result;
    }

    private Integer reduceToConstant(CExpression expression) {
        if (expression instanceof CIntegerLiteralExpression) {
            CIntegerLiteralExpression literal = (CIntegerLiteralExpression)expression;
            return literal.getValue().intValue();
        }
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)expression;
            CExpression op1 = binaryExpression.getOperand1();
            CExpression op2 = binaryExpression.getOperand2();
            Integer reduced1 = this.reduceToConstant(op1);
            Integer reduced2 = this.reduceToConstant(op2);
            if (reduced1 == null || reduced2 == null) {
                return null;
            }
            switch (binaryExpression.getOperator()) {
                case PLUS: {
                    return reduced1 + reduced2;
                }
                case MINUS: {
                    return reduced1 - reduced2;
                }
                case MULTIPLY: {
                    return reduced1 * reduced2;
                }
                case DIVIDE: {
                    return reduced1 / reduced2;
                }
                case MODULO: {
                    return reduced1 % reduced2;
                }
            }
            return null;
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)expression;
            Integer reducedInner = this.reduceToConstant(unaryExpression.getOperand());
            if (reducedInner == null) {
                return null;
            }
            switch (unaryExpression.getOperator()) {
                case MINUS: {
                    return -reducedInner.intValue();
                }
                case TILDE: {
                    return ~reducedInner.intValue();
                }
            }
            return null;
        }
        return null;
    }

    private LDDRegion toNode(Map<String, Integer> coeffs, boolean leq, int constant) {
        return this.regionManager.makeNode(this.toIndexCoefficients(coeffs), this.variables.size(), leq, constant);
    }

    private LDDRegion toConstantAssignmentRegion(Collection<String> variables, int constant) {
        return this.regionManager.makeConstantAssignment(this.toIndexCoefficients(variables), this.variables.size(), constant);
    }

    private LDDRegion toConstantAssignmentRegion(Map<String, Integer> coeffs, int constant) {
        return this.regionManager.makeConstantAssignment(this.toIndexCoefficients(coeffs), this.variables.size(), constant);
    }

    private Collection<Pair<Integer, Integer>> toIndexCoefficients(Map<String, Integer> pCoeffs) {
        LinkedList<Pair<Integer, Integer>> indexCoeffs = new LinkedList<Pair<Integer, Integer>>();
        for (Map.Entry<String, Integer> coeff : pCoeffs.entrySet()) {
            indexCoeffs.add((Pair<Integer, Integer>)Pair.of((Object)this.variables.get(coeff.getKey()), (Object)coeff.getValue()));
        }
        return indexCoeffs;
    }

    private Collection<Pair<Integer, Integer>> toIndexCoefficients(Collection<String> variables) {
        LinkedList<Pair<Integer, Integer>> indexCoeffs = new LinkedList<Pair<Integer, Integer>>();
        for (String variable : variables) {
            indexCoeffs.add((Pair<Integer, Integer>)Pair.of((Object)this.variables.get(variable), (Object)1));
        }
        return indexCoeffs;
    }

    private LDDRegion toRegion(CDeclaration declaration, LDDRegion previousRegion) {
        String variable = declaration.getName();
        if (this.variables.containsKey(variable) && declaration instanceof CVariableDeclaration) {
            CVariableDeclaration varDecl = (CVariableDeclaration)declaration;
            CInitializer init = varDecl.getInitializer();
            if (init instanceof CInitializerExpression) {
                return this.assign(variable, ((CInitializerExpression)init).getExpression(), previousRegion);
            }
            if (init instanceof CInitializerList) {
                // empty if block
            }
        }
        return this.regionManager.makeTrue();
    }

    public Collection<? extends LDDAbstractState> strengthen(AbstractState pElement, List<AbstractState> otherElements, CFAEdge edge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }
}

