/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.livevar;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesState;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesTransferRelation;

@Options
public class LiveVariablesCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for LiveVariablesCPA")
    private String mergeType = "JOIN";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN", "NEVER"}, description="which stop operator to use for LiveVariablesCPA")
    private String stopType = "SEP";
    private final AbstractDomain domain;
    private final LiveVariablesTransferRelation transfer;
    private final MergeOperator merge;
    private final StopOperator stop;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(LiveVariablesCPA.class);
    }

    private LiveVariablesCPA(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this, LiveVariablesCPA.class);
        this.logger = pLogger;
        this.domain = DelegateAbstractDomain.getInstance();
        if (!cfa.getVarClassification().isPresent() && cfa.getLanguage() == Language.C) {
            throw new AssertionError((Object)"Without information of the variable classification the live variables analysis cannot be used.");
        }
        this.transfer = new LiveVariablesTransferRelation(cfa.getVarClassification(), pConfig, cfa.getLanguage());
        this.merge = this.mergeType.equals("SEP") ? MergeSepOperator.getInstance() : new MergeJoinOperator(this.domain);
        this.stop = this.stopType.equals("JOIN") ? new StopJoinOperator(this.domain) : new StopSepOperator(this.domain);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        if (pNode instanceof FunctionExitNode) {
            FunctionExitNode eNode = (FunctionExitNode)pNode;
            Optional<? extends AVariableDeclaration> returnVarName = eNode.getEntryNode().getReturnVariable();
            if (!returnVarName.isPresent()) {
                return new LiveVariablesState();
            }
            this.transfer.putInitialLiveVariables(pNode, Collections.singleton((ASimpleDeclaration)returnVarName.get()));
            return new LiveVariablesState((ImmutableSet<ASimpleDeclaration>)ImmutableSet.of((Object)((ASimpleDeclaration)returnVarName.get())));
        }
        this.logger.log(Level.FINEST, new Object[]{"No FunctionExitNode given, thus creating initial state without having the return variable."});
        return new LiveVariablesState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    public Multimap<CFANode, ASimpleDeclaration> getLiveVariables() {
        return this.transfer.getLiveVariables();
    }
}

