/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.livevar;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class LiveVariablesState
implements LatticeAbstractState<LiveVariablesState>,
Graphable {
    private final ImmutableSet<ASimpleDeclaration> liveVars;
    private static Function<ASimpleDeclaration, String> DECL_TO_QUALIFIED_NAME = new Function<ASimpleDeclaration, String>(){

        public String apply(ASimpleDeclaration pInput) {
            return pInput.getQualifiedName();
        }
    };

    public LiveVariablesState() {
        this.liveVars = ImmutableSet.of();
    }

    public LiveVariablesState(ImmutableSet<ASimpleDeclaration> pLiveVariables) {
        Preconditions.checkNotNull(pLiveVariables);
        this.liveVars = pLiveVariables;
    }

    public LiveVariablesState union(LiveVariablesState pState2) {
        if (this.isSubsetOf(pState2)) {
            return pState2;
        }
        if (pState2.isSubsetOf(this)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.liveVars);
        builder.addAll(pState2.liveVars);
        return new LiveVariablesState((ImmutableSet<ASimpleDeclaration>)builder.build());
    }

    public boolean isSubsetOf(LiveVariablesState pState2) {
        return pState2.liveVars.containsAll(this.liveVars);
    }

    public boolean contains(ASimpleDeclaration variableName) {
        return this.liveVars.contains((Object)variableName);
    }

    public LiveVariablesState addLiveVariables(Collection<ASimpleDeclaration> pLiveVariables) {
        Preconditions.checkNotNull(pLiveVariables);
        if (pLiveVariables.isEmpty() || this.liveVars.containsAll(pLiveVariables)) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.liveVars);
        builder.addAll(pLiveVariables);
        return new LiveVariablesState((ImmutableSet<ASimpleDeclaration>)builder.build());
    }

    public LiveVariablesState removeLiveVariables(Collection<ASimpleDeclaration> pNonLiveVariables) {
        Preconditions.checkNotNull(pNonLiveVariables);
        if (pNonLiveVariables.isEmpty()) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ASimpleDeclaration liveVar : this.liveVars) {
            if (pNonLiveVariables.contains(liveVar)) continue;
            builder.add((Object)liveVar);
        }
        return new LiveVariablesState((ImmutableSet<ASimpleDeclaration>)builder.build());
    }

    public LiveVariablesState removeAndAddLiveVariables(Collection<ASimpleDeclaration> pNonLiveVariables, Collection<ASimpleDeclaration> pLiveVariables) {
        Preconditions.checkNotNull(pLiveVariables);
        Preconditions.checkNotNull(pNonLiveVariables);
        if (pLiveVariables.isEmpty()) {
            return this.removeLiveVariables(pNonLiveVariables);
        }
        if (pNonLiveVariables.isEmpty() || pLiveVariables.containsAll(pNonLiveVariables)) {
            return this.addLiveVariables(pLiveVariables);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ASimpleDeclaration liveVar : this.liveVars) {
            if (pNonLiveVariables.contains(liveVar) && !pLiveVariables.contains(liveVar)) continue;
            builder.add((Object)liveVar);
        }
        builder.addAll(pLiveVariables);
        return new LiveVariablesState((ImmutableSet<ASimpleDeclaration>)builder.build());
    }

    public String toString() {
        return this.liveVars.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.liveVars);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveVariablesState)) {
            return false;
        }
        LiveVariablesState other = (LiveVariablesState)obj;
        return Objects.equals(this.liveVars, other.liveVars);
    }

    @Override
    public LiveVariablesState join(LiveVariablesState pOther) throws CPAException {
        return this.union(pOther);
    }

    @Override
    public boolean isLessOrEqual(LiveVariablesState pOther) throws CPAException, InterruptedException {
        return this.isSubsetOf(pOther);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").appendTo(sb, (Iterable)FluentIterable.from(this.liveVars).transform(DECL_TO_QUALIFIED_NAME));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    public Iterable<? extends ASimpleDeclaration> getLiveVariables() {
        return this.liveVars;
    }
}

