/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.livevar;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.livevar.DeclarationCollectingVisitor;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.VariableClassification;

@Options(prefix="cpa.liveVar")
public class LiveVariablesTransferRelation
extends ForwardingTransferRelation<LiveVariablesState, LiveVariablesState, Precision> {
    private final Multimap<CFANode, ASimpleDeclaration> liveVariables = HashMultimap.create();
    private final VariableClassification variableClassification;
    private final Language language;
    @Option(secure=true, description="With this option the handling of global variables during the analysis can be fine-tuned. For example while doing a function-wise analysis it is important to assume that all global variables are live. In contrast to that, while doing a global analysis, we do not need to assume global variables being live.")
    private boolean assumeGlobalVariablesAreAlwaysLive = true;
    private final Predicate<ASimpleDeclaration> ALWAYS_LIVE_PREDICATE = new Predicate<ASimpleDeclaration>(){

        public boolean apply(ASimpleDeclaration decl) {
            boolean retVal;
            boolean bl = retVal = LiveVariablesTransferRelation.this.assumeGlobalVariablesAreAlwaysLive && decl instanceof AVariableDeclaration && ((AVariableDeclaration)decl).isGlobal();
            if (LiveVariablesTransferRelation.this.language == Language.C) {
                retVal = retVal || LiveVariablesTransferRelation.this.variableClassification.getAddressedVariables().contains(decl.getQualifiedName());
            }
            return retVal;
        }
    };
    private final Predicate<ASimpleDeclaration> LOCALLY_LIVE_PREDICATE = Predicates.or(this.ALWAYS_LIVE_PREDICATE, (Predicate)new Predicate<ASimpleDeclaration>(){

        public boolean apply(ASimpleDeclaration decl) {
            return ((LiveVariablesState)LiveVariablesTransferRelation.this.state).contains(decl);
        }
    });

    public LiveVariablesTransferRelation(Optional<VariableClassification> pVarClass, Configuration pConfig, Language pLang) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.variableClassification = pLang == Language.C ? (VariableClassification)pVarClass.get() : null;
        this.language = pLang;
    }

    @Override
    protected Collection<LiveVariablesState> postProcessing(@Nullable LiveVariablesState successor) {
        if (successor == null) {
            return Collections.emptySet();
        }
        this.liveVariables.putAll((Object)this.edge.getPredecessor(), successor.getLiveVariables());
        return Collections.singleton(successor);
    }

    @Override
    protected LiveVariablesState handleMultiEdge(MultiEdge cfaEdge) throws CPATransferException {
        Iterator i$ = Lists.reverse(cfaEdge.getEdges()).iterator();
        while (i$.hasNext()) {
            CFAEdge innerEdge;
            this.edge = innerEdge = (CFAEdge)i$.next();
            this.state = (AbstractState)this.handleSimpleEdge(innerEdge);
        }
        this.edge = cfaEdge;
        return (LiveVariablesState)this.state;
    }

    private Collection<ASimpleDeclaration> handleExpression(AExpression expression) {
        return LiveVariablesTransferRelation.acceptAll(expression);
    }

    private Collection<ASimpleDeclaration> handleLeftHandSide(AExpression pLeftHandSide) {
        return LiveVariablesTransferRelation.acceptLeft(pLeftHandSide);
    }

    @Override
    protected LiveVariablesState handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthAssumption) throws CPATransferException {
        return ((LiveVariablesState)this.state).addLiveVariables(this.handleExpression(expression));
    }

    @Override
    protected LiveVariablesState handleDeclarationEdge(ADeclarationEdge cfaEdge, ADeclaration decl) throws CPATransferException {
        if (!(decl instanceof AVariableDeclaration)) {
            return (LiveVariablesState)this.state;
        }
        AVariableDeclaration varDecl = (AVariableDeclaration)decl;
        Set<ASimpleDeclaration> deadVar = Collections.singleton(varDecl);
        AInitializer init = varDecl.getInitializer();
        if (init == null) {
            return ((LiveVariablesState)this.state).removeLiveVariables(deadVar);
        }
        if (!((LiveVariablesState)this.state).contains(varDecl)) {
            return (LiveVariablesState)this.state;
        }
        return ((LiveVariablesState)this.state).removeAndAddLiveVariables(deadVar, this.getVariablesUsedForInitialization(init));
    }

    private Collection<ASimpleDeclaration> getVariablesUsedForInitialization(AInitializer init) throws CPATransferException {
        if (init instanceof CDesignatedInitializer) {
            return this.getVariablesUsedForInitialization(((CDesignatedInitializer)init).getRightHandSide());
        }
        if (init instanceof CInitializerList) {
            ArrayList<ASimpleDeclaration> readVars = new ArrayList<ASimpleDeclaration>();
            for (CInitializer inList : ((CInitializerList)init).getInitializers()) {
                readVars.addAll(this.getVariablesUsedForInitialization(inList));
            }
            return readVars;
        }
        if (init instanceof AInitializerExpression) {
            return this.handleExpression(((AInitializerExpression)init).getExpression());
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    @Override
    protected LiveVariablesState handleStatementEdge(AStatementEdge cfaEdge, AStatement statement) throws CPATransferException {
        if (statement instanceof AExpressionAssignmentStatement) {
            return this.handleAssignments((AAssignment)((Object)statement));
        }
        if (statement instanceof AExpressionStatement) {
            return (LiveVariablesState)this.state;
        }
        if (statement instanceof AFunctionCallAssignmentStatement) {
            return this.handleAssignments((AAssignment)((Object)statement));
        }
        if (statement instanceof AFunctionCallStatement) {
            AFunctionCallStatement funcStmt = (AFunctionCallStatement)statement;
            return ((LiveVariablesState)this.state).addLiveVariables(this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions()));
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    private LiveVariablesState handleAssignments(AAssignment assignment) {
        HashSet<ASimpleDeclaration> newLiveVariables = new HashSet<ASimpleDeclaration>();
        ALeftHandSide leftHandSide = assignment.getLeftHandSide();
        Collection<ASimpleDeclaration> assignedVariable = this.handleLeftHandSide(leftHandSide);
        Collection<ASimpleDeclaration> allLeftHandSideVariables = this.handleExpression(leftHandSide);
        Collection additionallyLeftHandSideVariables = Collections2.filter(allLeftHandSideVariables, (Predicate)Predicates.not((Predicate)Predicates.in(assignedVariable)));
        newLiveVariables.addAll(additionallyLeftHandSideVariables);
        if (assignment instanceof AExpressionAssignmentStatement) {
            newLiveVariables.addAll(this.handleExpression((AExpression)assignment.getRightHandSide()));
        } else if (assignment instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement funcStmt = (AFunctionCallAssignmentStatement)assignment;
            newLiveVariables.addAll(this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions()));
        } else {
            throw new AssertionError((Object)"Unhandled assignment type.");
        }
        if (this.isAlwaysLive(leftHandSide)) {
            newLiveVariables.addAll(assignedVariable);
            return ((LiveVariablesState)this.state).addLiveVariables(newLiveVariables);
        }
        if (assignment instanceof AFunctionCallAssignmentStatement || this.isLeftHandSideLive(leftHandSide)) {
            if (assignedVariable.size() > 1) {
                newLiveVariables.addAll(assignedVariable);
                return ((LiveVariablesState)this.state).addLiveVariables(newLiveVariables);
            }
            if (leftHandSide instanceof CFieldReference || leftHandSide instanceof AArraySubscriptExpression || leftHandSide instanceof CPointerExpression) {
                return ((LiveVariablesState)this.state).addLiveVariables(newLiveVariables);
            }
            return ((LiveVariablesState)this.state).removeAndAddLiveVariables(assignedVariable, newLiveVariables);
        }
        if (leftHandSide instanceof CFieldReference && (((CFieldReference)leftHandSide).isPointerDereference() || ((CFieldReference)leftHandSide).getFieldOwner() instanceof CPointerExpression) || leftHandSide instanceof AArraySubscriptExpression || leftHandSide instanceof CPointerExpression) {
            newLiveVariables.addAll(assignedVariable);
            return ((LiveVariablesState)this.state).addLiveVariables(newLiveVariables);
        }
        return (LiveVariablesState)this.state;
    }

    private boolean isAlwaysLive(ALeftHandSide expression) {
        return FluentIterable.from(LiveVariablesTransferRelation.acceptLeft(expression)).anyMatch(this.ALWAYS_LIVE_PREDICATE);
    }

    private boolean isLeftHandSideLive(ALeftHandSide expression) {
        return FluentIterable.from(LiveVariablesTransferRelation.acceptLeft(expression)).anyMatch(this.LOCALLY_LIVE_PREDICATE);
    }

    private Collection<ASimpleDeclaration> getVariablesUsedAsParameters(List<? extends AExpression> parameters) {
        ArrayList<ASimpleDeclaration> newLiveVars = new ArrayList<ASimpleDeclaration>();
        for (AExpression aExpression : parameters) {
            newLiveVars.addAll(this.handleExpression(aExpression));
        }
        return newLiveVars;
    }

    @Override
    protected LiveVariablesState handleReturnStatementEdge(AReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.asAssignment().isPresent()) {
            return (LiveVariablesState)this.state;
        }
        return this.handleAssignments((AAssignment)cfaEdge.asAssignment().get());
    }

    @Override
    protected LiveVariablesState handleFunctionCallEdge(FunctionCallEdge cfaEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        ArrayList<ASimpleDeclaration> variablesInArguments = new ArrayList<ASimpleDeclaration>();
        for (AExpression aExpression : arguments) {
            variablesInArguments.addAll(this.handleExpression(aExpression));
        }
        ArrayList<ASimpleDeclaration> parameterVars = new ArrayList<ASimpleDeclaration>(parameters.size());
        for (AParameterDeclaration aParameterDeclaration : parameters) {
            parameterVars.add(aParameterDeclaration);
        }
        return ((LiveVariablesState)this.state).removeAndAddLiveVariables(parameterVars, variablesInArguments);
    }

    @Override
    protected LiveVariablesState handleFunctionReturnEdge(FunctionReturnEdge cfaEdge, FunctionSummaryEdge fnkCall, AFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        if (summaryExpr instanceof AFunctionCallAssignmentStatement) {
            boolean isLeftHandsideLive = this.isLeftHandSideLive(((AFunctionCallAssignmentStatement)summaryExpr).getLeftHandSide());
            ASimpleDeclaration retVal = (ASimpleDeclaration)cfaEdge.getFunctionEntry().getReturnVariable().get();
            LiveVariablesState returnState = this.handleAssignments((AAssignment)((Object)summaryExpr));
            if (isLeftHandsideLive) {
                returnState = returnState.addLiveVariables(Collections.singleton(retVal));
            }
            return returnState;
        }
        return (LiveVariablesState)this.state;
    }

    @Override
    protected LiveVariablesState handleFunctionSummaryEdge(FunctionSummaryEdge cfaEdge) throws CPATransferException {
        AFunctionCall functionCall = cfaEdge.getExpression();
        if (functionCall instanceof AFunctionCallAssignmentStatement) {
            return this.handleAssignments((AAssignment)((Object)functionCall));
        }
        if (functionCall instanceof AFunctionCallStatement) {
            AFunctionCallStatement funcStmt = (AFunctionCallStatement)functionCall;
            return ((LiveVariablesState)this.state).addLiveVariables(this.getVariablesUsedAsParameters(funcStmt.getFunctionCallExpression().getParameterExpressions()));
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    public void putInitialLiveVariables(CFANode node, Collection<ASimpleDeclaration> liveVars) {
        this.liveVariables.putAll((Object)node, liveVars);
    }

    public Multimap<CFANode, ASimpleDeclaration> getLiveVariables() {
        return this.liveVariables;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }

    private static Set<ASimpleDeclaration> acceptLeft(AExpression exp) {
        return (Set)exp.accept_(new LeftHandSideIdExpressionVisitor());
    }

    private static Set<ASimpleDeclaration> acceptAll(AExpression exp) {
        return (Set)exp.accept_(new DeclarationCollectingVisitor());
    }

    private static final class LeftHandSideIdExpressionVisitor
    extends DeclarationCollectingVisitor {
        private LeftHandSideIdExpressionVisitor() {
        }

        @Override
        public Set<ASimpleDeclaration> visit(AArraySubscriptExpression pE) {
            return (Set)pE.getArrayExpression().accept_(this);
        }
    }
}

