/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Optional;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.location.LocationCPAFactory;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.location.LocationTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class LocationCPA
implements ConfigurableProgramAnalysis,
ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    private final LocationState.LocationStateFactory stateFactory;
    private final AbstractDomain abstractDomain = new FlatLatticeDomain();
    private final LocationTransferRelation transferRelation;
    private final StopOperator stopOperator = new StopSepOperator(this.abstractDomain);

    public LocationCPA(CFA pCfa, Configuration config) throws InvalidConfigurationException {
        this.stateFactory = new LocationState.LocationStateFactory(pCfa, LocationState.LocationStateFactory.LocationStateType.FORWARD, config);
        this.transferRelation = new LocationTransferRelation(this.stateFactory);
        Optional<CFAInfo> cfaInfo = GlobalInfo.getInstance().getCFAInfo();
        if (cfaInfo.isPresent()) {
            ((CFAInfo)cfaInfo.get()).storeLocationStateFactory(this.stateFactory);
        }
    }

    public static CPAFactory factory() {
        return new LocationCPAFactory(LocationState.LocationStateFactory.LocationStateType.FORWARD);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.stateFactory.getState(pNode);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        return pSuccessors.equals(this.transferRelation.getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge));
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.abstractDomain.isLessOrEqual(pElement, pOtherElement);
    }
}

