/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwards;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwardsNoTargets;
import org.sosy_lab.cpachecker.cpa.location.LocationState;

class LocationCPAFactory
extends AbstractCPAFactory {
    private final LocationState.LocationStateFactory.LocationStateType locationType;
    private CFA cfa;

    public LocationCPAFactory(LocationState.LocationStateFactory.LocationStateType pLocationType) {
        this.locationType = pLocationType;
    }

    @Override
    public <T> LocationCPAFactory set(T pObject, Class<T> pClass) {
        if (CFA.class.isAssignableFrom(pClass)) {
            this.cfa = (CFA)pObject;
        } else {
            super.set(pObject, pClass);
        }
        return this;
    }

    @Override
    public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)this.cfa, (Object)"CFA instance needed to create LocationCPA");
        switch (this.locationType) {
            case BACKWARD: {
                return new LocationCPABackwards(this.cfa, this.getConfiguration());
            }
            case BACKWARDNOTARGET: {
                return new LocationCPABackwardsNoTargets(this.cfa, this.getConfiguration());
            }
        }
        return new LocationCPA(this.cfa, this.getConfiguration());
    }
}

