/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Comparator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class LocationState
implements AbstractStateWithLocation,
AbstractQueryableState,
Partitionable,
Serializable {
    private static final long serialVersionUID = -801176497691618779L;
    private transient CFANode locationNode;
    private boolean followFunctionCalls;

    private LocationState(CFANode pLocationNode, boolean pFollowFunctionCalls) {
        this.locationNode = pLocationNode;
        this.followFunctionCalls = pFollowFunctionCalls;
    }

    @Override
    public CFANode getLocationNode() {
        return this.locationNode;
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        if (this.followFunctionCalls) {
            return CFAUtils.leavingEdges(this.locationNode);
        }
        return CFAUtils.allLeavingEdges(this.locationNode).filter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(FunctionReturnEdge.class), (Predicate)Predicates.instanceOf(FunctionCallEdge.class))));
    }

    public String toString() {
        String loc = this.locationNode.describeFileLocation();
        return this.locationNode + (loc.isEmpty() ? "" : " (" + loc + ")");
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        if (parts[0].toLowerCase().equals("line")) {
            try {
                int queryLine = Integer.parseInt(parts[1]);
                for (CFAEdge edge : CFAUtils.enteringEdges(this.locationNode)) {
                    if (edge.getLineNumber() != queryLine) continue;
                    return true;
                }
                return false;
            }
            catch (NumberFormatException nfe) {
                throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the integer \"" + parts[1] + "\"");
            }
        }
        if (parts[0].toLowerCase().equals("functionname")) {
            return this.locationNode.getFunctionName().equals(parts[1]);
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. \"" + parts[0] + "\" is no valid keyword");
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        throw new InvalidQueryException("The location CPA does not support modification.");
    }

    @Override
    public String getCPAName() {
        return "location";
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equalsIgnoreCase("lineno")) {
            if (this.locationNode.getNumEnteringEdges() > 0) {
                return this.locationNode.getEnteringEdge(0).getLineNumber();
            }
            return 0;
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialProxy(this.locationNode.getNodeNumber());
    }

    private static class SerialProxy
    implements Serializable {
        private static final long serialVersionUID = 6889568471468710163L;
        private final int nodeNumber;

        public SerialProxy(int nodeNumber) {
            this.nodeNumber = nodeNumber;
        }

        private Object readResolve() throws ObjectStreamException {
            CFAInfo cfaInfo = (CFAInfo)GlobalInfo.getInstance().getCFAInfo().get();
            return cfaInfo.getLocationStateFactory().getState(cfaInfo.getNodeByNodeNumber(this.nodeNumber));
        }
    }

    private static class BackwardsLocationStateNoTarget
    extends BackwardsLocationState {
        protected BackwardsLocationStateNoTarget(CFANode pLocationNode, CFA pCfa, boolean pFollowFunctionCalls) {
            super(pLocationNode, pCfa, pFollowFunctionCalls);
        }

        @Override
        public boolean isTarget() {
            return false;
        }
    }

    private static class BackwardsLocationState
    extends LocationState
    implements AbstractQueryableState,
    Targetable {
        private final CFA cfa;
        private boolean followFunctionCalls;

        protected BackwardsLocationState(CFANode locationNode, CFA pCfa, boolean pFollowFunctionCalls) {
            super(locationNode, pFollowFunctionCalls);
            this.cfa = pCfa;
            this.followFunctionCalls = pFollowFunctionCalls;
        }

        @Override
        public Iterable<CFAEdge> getOutgoingEdges() {
            if (this.followFunctionCalls) {
                return CFAUtils.enteringEdges(this.getLocationNode());
            }
            return CFAUtils.allEnteringEdges(this.getLocationNode()).filter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(FunctionReturnEdge.class), (Predicate)Predicates.instanceOf(FunctionCallEdge.class))));
        }

        @Override
        public boolean isTarget() {
            return this.cfa.getMainFunction() == this.getLocationNode();
        }

        @Override
        public String getViolatedPropertyDescription() throws IllegalStateException {
            return "Entry node reached backwards.";
        }
    }

    @Options(prefix="cpa.location")
    public static class LocationStateFactory {
        private final LocationState[] states;
        @Option(secure=true, description="with this option enabled, unction calls taht occur in the CFA are followed. By disabling this option one can traverse a function withou following function calls (in this case FunctionSummaryEdges are used)")
        private boolean followFunctionCalls = true;

        public LocationStateFactory(CFA pCfa, LocationStateType locationType, Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
            ImmutableSortedSet allNodes = FluentIterable.from(pCfa.getAllNodes()).transformAndConcat((Function)new Function<CFANode, Iterable<CFAEdge>>(){

                public Iterable<CFAEdge> apply(CFANode pInput) {
                    return CFAUtils.leavingEdges(pInput);
                }
            }).filter(MultiEdge.class).transformAndConcat((Function)new Function<MultiEdge, Iterable<CFAEdge>>(){

                public Iterable<CFAEdge> apply(MultiEdge pInput) {
                    return pInput.getEdges();
                }
            }).transform(CFAUtils.TO_SUCCESSOR).append(pCfa.getAllNodes()).toSortedSet((Comparator)Ordering.natural());
            int maxNodeNumber = ((CFANode)allNodes.last()).getNodeNumber();
            this.states = new LocationState[maxNodeNumber + 1];
            for (CFANode node : allNodes) {
                LocationState state = locationType == LocationStateType.BACKWARD ? new BackwardsLocationState(node, pCfa, this.followFunctionCalls) : (locationType == LocationStateType.BACKWARDNOTARGET ? new BackwardsLocationStateNoTarget(node, pCfa, this.followFunctionCalls) : new LocationState(node, this.followFunctionCalls));
                this.states[node.getNodeNumber()] = state;
            }
        }

        public LocationState getState(CFANode node) {
            return (LocationState)Preconditions.checkNotNull((Object)this.states[((CFANode)Preconditions.checkNotNull((Object)node)).getNodeNumber()], (String)"LocationState for CFANode %s in function %s requested, but this node is not part of the current CFA.", (Object[])new Object[]{node, node.getFunctionName()});
        }

        static enum LocationStateType {
            FORWARD,
            BACKWARD,
            BACKWARDNOTARGET;

        }
    }
}

