/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.location;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LocationTransferRelation
implements TransferRelation {
    private final LocationState.LocationStateFactory factory;

    public LocationTransferRelation(LocationState.LocationStateFactory pFactory) {
        this.factory = pFactory;
    }

    public Collection<LocationState> getAbstractSuccessorsForEdge(AbstractState element, Precision prec, CFAEdge cfaEdge) {
        MultiEdge multiEdge;
        LocationState inputElement = (LocationState)element;
        CFANode node = inputElement.getLocationNode();
        if (CFAUtils.allLeavingEdges(node).contains((Object)cfaEdge)) {
            return Collections.singleton(this.factory.getState(cfaEdge.getSuccessor()));
        }
        if (node.getNumLeavingEdges() == 1 && node.getLeavingEdge(0) instanceof MultiEdge && ((CFAEdge)(multiEdge = (MultiEdge)node.getLeavingEdge(0)).getEdges().get(0)).equals(cfaEdge)) {
            return Collections.singleton(this.factory.getState(cfaEdge.getSuccessor()));
        }
        return Collections.emptySet();
    }

    public Collection<LocationState> getAbstractSuccessors(AbstractState element, Precision prec) throws CPATransferException {
        CFANode node = ((LocationState)element).getLocationNode();
        ArrayList<LocationState> allSuccessors = new ArrayList<LocationState>(node.getNumLeavingEdges());
        for (CFANode successor : CFAUtils.successorsOf(node)) {
            allSuccessors.add(this.factory.getState(successor));
        }
        return allSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }
}

