/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackCPAFactory;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackState;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;

@Options(prefix="cpa.loopstack")
public class LoopstackCPA
extends AbstractCPA
implements ReachedSetAdjustingCPA,
StatisticsProvider,
Statistics {
    private final LogManager logger;
    @Option(secure=true, description="threshold for unrolling loops of the program (0 is infinite)\nworks only if assumption storage CPA is enabled, because otherwise it would be unsound")
    private int maxLoopIterations = 0;
    @Option(secure=true, description="this option controls how the maxLoopIterations condition is adjusted when a condition adjustment is invoked.")
    private MaxLoopIterationAdjusters maxLoopIterationAdjusterFactory = MaxLoopIterationAdjusters.STATIC;
    @Option(secure=true, description="threshold for adjusting the threshold for unrolling loops of the program (0 is infinite).\nonly relevant in combination with a non-static maximum loop iteration adjuster.")
    private int maxLoopIterationsUpperBound = 0;
    private final DelegatingTransferRelation transferRelation;
    private final CFA cfa;

    public static CPAFactory factory() {
        return new LoopstackCPAFactory();
    }

    public LoopstackCPA(Configuration config, CFA pCfa, LogManager pLogger) throws InvalidConfigurationException, CPAException {
        this(config, pCfa, pLogger, new DelegatingTransferRelation());
    }

    private LoopstackCPA(Configuration config, CFA pCfa, LogManager pLogger, DelegatingTransferRelation pDelegatingTransferRelation) throws InvalidConfigurationException, InvalidCFAException {
        super("sep", "sep", pDelegatingTransferRelation);
        config.inject((Object)this);
        this.transferRelation = pDelegatingTransferRelation;
        this.transferRelation.setDelegate(new LoopstackTransferRelation(this.maxLoopIterations, pCfa));
        this.logger = pLogger;
        this.cfa = pCfa;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        if (pNode instanceof FunctionEntryNode) {
            return new LoopstackState();
        }
        LoopStructure.Loop loop = null;
        HashSet<String> functionNames = new HashSet<String>();
        functionNames.add(pNode.getFunctionName());
        functionNames.add(" ");
        for (String functionName : functionNames) {
            ImmutableCollection<LoopStructure.Loop> loops = ((LoopStructure)this.cfa.getLoopStructure().get()).getLoopsForFunction(functionName);
            if (loops == null) continue;
            for (LoopStructure.Loop l : loops) {
                if (!l.getLoopNodes().contains((Object)pNode)) continue;
                Preconditions.checkState((loop == null ? 1 : 0) != 0, (Object)"Cannot create initial nodes for locations in nested loops");
                loop = l;
            }
            if (loop == null) continue;
            break;
        }
        LoopstackState e = new LoopstackState();
        if (loop != null) {
            e = new LoopstackState(e, loop, 1, false);
        }
        return e;
    }

    @Override
    public TransferRelation getTransferRelation() {
        if (this.transferRelation == null) {
            return super.getTransferRelation();
        }
        return this.transferRelation;
    }

    @Override
    public boolean adjustPrecision() {
        MaxLoopIterationAdjuster maxLoopIterationAdjuster = this.maxLoopIterationAdjusterFactory.getMaxLoopIterationAdjuster(this);
        if (maxLoopIterationAdjuster.canAdjust(this.maxLoopIterations)) {
            int maxLoopIterations = maxLoopIterationAdjuster.adjust(this.maxLoopIterations);
            this.logger.log(Level.INFO, new Object[]{"Adjusting maxLoopIterations to " + maxLoopIterations});
            try {
                this.setMaxLoopIterations(maxLoopIterations);
            }
            catch (InvalidCFAException e) {
                this.logger.logException(Level.WARNING, (Throwable)e, "Exception while trying to adjust the maximum amount of loop iterations.");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void adjustReachedSet(ReachedSet pReachedSet) {
        ImmutableSet toRemove = FluentIterable.from((Iterable)pReachedSet).filter((Predicate)new Predicate<AbstractState>(){

            public boolean apply(@Nullable AbstractState pArg0) {
                if (pArg0 == null) {
                    return false;
                }
                LoopstackState loopstackState = AbstractStates.extractStateByType(pArg0, LoopstackState.class);
                return loopstackState != null && loopstackState.mustDumpAssumptionForAvoidance();
            }
        }).toSet();
        if (toRemove.contains(pReachedSet.getFirstState())) {
            pReachedSet.clear();
            return;
        }
        ImmutableList waitlist = FluentIterable.from((Iterable)toRemove).transformAndConcat((Function)new Function<AbstractState, Iterable<? extends AbstractState>>(){

            public Iterable<? extends AbstractState> apply(@Nullable AbstractState pArg0) {
                if (pArg0 == null) {
                    return Collections.emptyList();
                }
                ARGState argState = AbstractStates.extractStateByType(pArg0, ARGState.class);
                if (argState == null) {
                    return Collections.emptyList();
                }
                return argState.getParents();
            }
        }).toSet().asList();
        pReachedSet.removeAll((Iterable<? extends AbstractState>)toRemove);
        for (AbstractState s : FluentIterable.from((Iterable)toRemove).filter(ARGState.class)) {
            s.removeFromARG();
        }
        for (AbstractState s : waitlist) {
            pReachedSet.reAddToWaitlist(s);
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        pOut.println("Bound k:" + this.maxLoopIterations);
        int maximumLoopIterationReached = 0;
        for (AbstractState state : pReached) {
            LoopstackState loopstackState = AbstractStates.extractStateByType(state, LoopstackState.class);
            if (loopstackState == null) continue;
            maximumLoopIterationReached = Math.max(maximumLoopIterationReached, loopstackState.getIteration());
        }
        pOut.print("Maximum loop iteration reached:" + maximumLoopIterationReached);
    }

    @Override
    public String getName() {
        return "Loopstack CPA";
    }

    public void setMaxLoopIterations(int pMaxLoopIterations) throws InvalidCFAException {
        this.maxLoopIterations = pMaxLoopIterations;
        this.transferRelation.setDelegate(new LoopstackTransferRelation(this.maxLoopIterations, this.cfa));
    }

    public int getMaxLoopIterations() {
        return this.maxLoopIterations;
    }

    private static class DelegatingTransferRelation
    extends SingleEdgeTransferRelation {
        private TransferRelation delegate = null;

        public DelegatingTransferRelation() {
            this(null);
        }

        public DelegatingTransferRelation(TransferRelation pDelegate) {
            this.delegate = pDelegate;
        }

        public void setDelegate(TransferRelation pNewDelegate) {
            this.delegate = pNewDelegate;
        }

        @Override
        public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0);
            return this.delegate.getAbstractSuccessorsForEdge(pState, pPrecision, pCfaEdge);
        }

        @Override
        public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
            return this.delegate.strengthen(pState, pOtherStates, pCfaEdge, pPrecision);
        }
    }

    private static class DoublingLoopIterationAdjuster
    implements MaxLoopIterationAdjuster {
        private final LoopstackCPA cpa;

        public DoublingLoopIterationAdjuster(LoopstackCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public int adjust(int pCurrentValue) {
            return 2 * pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return this.cpa.maxLoopIterationsUpperBound <= 0 || pCurrentValue * 2 <= this.cpa.maxLoopIterationsUpperBound;
        }
    }

    private static class IncrementalLoopIterationAdjuster
    implements MaxLoopIterationAdjuster {
        private final LoopstackCPA cpa;

        public IncrementalLoopIterationAdjuster(LoopstackCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public int adjust(int pCurrentValue) {
            return ++pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return this.cpa.maxLoopIterationsUpperBound <= 0 || pCurrentValue < this.cpa.maxLoopIterationsUpperBound;
        }
    }

    private static enum StaticLoopIterationAdjuster implements MaxLoopIterationAdjuster
    {
        INSTANCE;


        @Override
        public int adjust(int pCurrentValue) {
            return pCurrentValue;
        }

        @Override
        public boolean canAdjust(int pCurrentValue) {
            return false;
        }
    }

    private static enum MaxLoopIterationAdjusters implements MaxLoopIterationAdjusterFactory
    {
        STATIC{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopstackCPA pCPA) {
                return StaticLoopIterationAdjuster.INSTANCE;
            }
        }
        ,
        INCREMENT{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopstackCPA pCPA) {
                return new IncrementalLoopIterationAdjuster(pCPA);
            }
        }
        ,
        DOUBLE{

            @Override
            public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopstackCPA pCPA) {
                return new DoublingLoopIterationAdjuster(pCPA);
            }
        };

    }

    private static interface MaxLoopIterationAdjusterFactory {
        public MaxLoopIterationAdjuster getMaxLoopIterationAdjuster(LoopstackCPA var1);
    }

    private static interface MaxLoopIterationAdjuster {
        public int adjust(int var1);

        public boolean canAdjust(int var1);
    }
}

