/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class LoopstackState
implements AbstractState,
Partitionable,
AvoidanceReportingState {
    private final LoopstackState previousState;
    private final LoopStructure.Loop loop;
    private final int depth;
    private final int iteration;
    private final boolean stop;

    public LoopstackState(LoopstackState previousElement, LoopStructure.Loop loop, int iteration, boolean stop) {
        this.previousState = (LoopstackState)Preconditions.checkNotNull((Object)previousElement);
        this.loop = (LoopStructure.Loop)Preconditions.checkNotNull((Object)loop);
        this.depth = previousElement.getDepth() + 1;
        Preconditions.checkArgument((iteration >= 0 ? 1 : 0) != 0);
        this.iteration = iteration;
        this.stop = stop;
    }

    public LoopstackState() {
        this.previousState = null;
        this.loop = null;
        this.depth = 0;
        this.iteration = 0;
        this.stop = false;
    }

    public LoopstackState getPreviousState() {
        return this.previousState;
    }

    public LoopStructure.Loop getLoop() {
        return this.loop;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.stop;
    }

    public String toString() {
        if (this.loop == null) {
            return "Loop stack empty";
        }
        return " Loop starting at node " + this.loop.getLoopHeads() + " in iteration " + this.iteration + ", stack depth " + this.depth + " [" + Integer.toHexString(super.hashCode()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoopstackState)) {
            return false;
        }
        LoopstackState other = (LoopstackState)obj;
        return this.previousState == other.previousState && this.iteration == other.iteration && this.loop == other.loop;
    }

    public int hashCode() {
        return this.iteration * 17 + (this.loop == null ? 0 : this.loop.hashCode());
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView manager) {
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        if (this.stop) {
            return PreventingHeuristic.LOOPITERATIONS.getFormula(manager, this.iteration);
        }
        return bfmgr.makeBoolean(true);
    }
}

