/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.loopstack;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidCFAException;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class LoopstackTransferRelation
extends SingleEdgeTransferRelation {
    private Map<CFAEdge, LoopStructure.Loop> loopEntryEdges = null;
    private Map<CFAEdge, LoopStructure.Loop> loopExitEdges = null;
    private Multimap<CFANode, LoopStructure.Loop> loopHeads = null;
    private final int maxLoopIterations;

    public LoopstackTransferRelation(int maxLoopIterations, CFA pCfa) throws InvalidCFAException {
        this.maxLoopIterations = maxLoopIterations;
        if (!pCfa.getLoopStructure().isPresent()) {
            throw new InvalidCFAException("LoopstackCPA does not work without loop information!");
        }
        LoopStructure loops = (LoopStructure)pCfa.getLoopStructure().get();
        ImmutableMap.Builder entryEdges = ImmutableMap.builder();
        ImmutableMap.Builder exitEdges = ImmutableMap.builder();
        ImmutableMultimap.Builder heads = ImmutableMultimap.builder();
        for (LoopStructure.Loop l : loops.getAllLoops()) {
            Iterable incomingEdges = Iterables.filter(l.getIncomingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(CFunctionReturnEdge.class)));
            Iterable outgoingEdges = Iterables.filter(l.getOutgoingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(CFunctionCallEdge.class)));
            for (CFAEdge e : incomingEdges) {
                entryEdges.put((Object)e, (Object)l);
            }
            for (CFAEdge e : outgoingEdges) {
                exitEdges.put((Object)e, (Object)l);
            }
            for (CFANode h : l.getLoopHeads()) {
                heads.put((Object)h, (Object)l);
            }
        }
        this.loopEntryEdges = entryEdges.build();
        this.loopExitEdges = exitEdges.build();
        this.loopHeads = heads.build();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        if (pCfaEdge instanceof CFunctionCallEdge) {
            return Collections.singleton(pElement);
        }
        CFANode loc = pCfaEdge.getSuccessor();
        LoopstackState e = (LoopstackState)pElement;
        LoopStructure.Loop oldLoop = this.loopExitEdges.get(pCfaEdge);
        if (oldLoop != null) {
            assert (oldLoop.equals(e.getLoop())) : e + " " + oldLoop + " " + pCfaEdge;
            e = e.getPreviousState();
        }
        if (pCfaEdge instanceof CFunctionReturnEdge) {
            return Collections.singleton(pElement);
        }
        LoopStructure.Loop newLoop = this.loopEntryEdges.get(pCfaEdge);
        if (newLoop != null) {
            e = new LoopstackState(e, newLoop, 0, false);
        }
        Collection loops = this.loopHeads.get((Object)loc);
        assert (loops.size() <= 1);
        if (loops.contains(e.getLoop())) {
            boolean stop = this.maxLoopIterations > 0 && e.getIteration() >= this.maxLoopIterations;
            e = new LoopstackState(e.getPreviousState(), e.getLoop(), e.getIteration() + 1, stop);
        }
        return Collections.singleton(e);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, List<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) {
        return null;
    }
}

